/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest;

import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.codegentest.CustomEnumType;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;

public class CustomEnumConversion
extends Conversion<CustomEnumType> {
    public Class<CustomEnumType> getConvertedType() {
        return CustomEnumType.class;
    }

    public Schema getRecommendedSchema() {
        return new LogicalType("custom-enum").addToSchema(Schema.create((Schema.Type)Schema.Type.ENUM));
    }

    public String getLogicalTypeName() {
        return "custom-enum";
    }

    public CustomEnumType fromEnumSymbol(GenericEnumSymbol value, Schema schema, LogicalType type) {
        return new CustomEnumType(value.toString());
    }

    public GenericEnumSymbol toEnumSymbol(CustomEnumType value, Schema schema, LogicalType type) {
        return new GenericData.EnumSymbol(schema, value.getUnderlying());
    }
}

