/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.pointables.nonvisitor.ARecordPointable;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class RecordNamesDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new RecordNamesDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.RecordAccessorTypeInferer.INSTANCE_LAX;
        }
    };
    private static final long serialVersionUID = 1L;
    private ARecordType recType;

    public void setImmutableStates(Object ... states) {
        this.recType = (ARecordType)states[0];
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private IScalarEvaluator eval0;
                    private final IPointable argPtr;
                    private final ARecordPointable recordPointable;
                    private final AOrderedListType listType;
                    private final OrderedListBuilder listBuilder;
                    private final ArrayBackedValueStorage itemStorage;
                    private final DataOutput itemOut;
                    private final ArrayBackedValueStorage resultStorage;
                    private final DataOutput resultOut;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.argPtr = new VoidPointable();
                        this.recordPointable = ARecordPointable.FACTORY.createPointable();
                        this.listType = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
                        this.listBuilder = new OrderedListBuilder();
                        this.itemStorage = new ArrayBackedValueStorage();
                        this.itemOut = this.itemStorage.getDataOutput();
                        this.resultStorage = new ArrayBackedValueStorage();
                        this.resultOut = this.resultStorage.getDataOutput();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
                        int offset;
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.argPtr);
                        if (PointableHelper.checkAndSetMissingOrNull(resultPointable, this.argPtr)) {
                            return;
                        }
                        byte[] data = this.argPtr.getByteArray();
                        if (data[offset = this.argPtr.getStartOffset()] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                            PointableHelper.setNull(resultPointable);
                            return;
                        }
                        this.recordPointable.set(data, offset, this.argPtr.getLength());
                        this.listBuilder.reset((AbstractCollectionType)this.listType);
                        try {
                            int i;
                            int n = this.recordPointable.getSchemeFieldCount(RecordNamesDescriptor.this.recType);
                            for (i = 0; i < n; ++i) {
                                this.itemStorage.reset();
                                this.recordPointable.getClosedFieldName(RecordNamesDescriptor.this.recType, i, this.itemOut);
                                this.listBuilder.addItem((IValueReference)this.itemStorage);
                            }
                            n = this.recordPointable.getOpenFieldCount(RecordNamesDescriptor.this.recType);
                            for (i = 0; i < n; ++i) {
                                this.itemStorage.reset();
                                this.recordPointable.getOpenFieldName(RecordNamesDescriptor.this.recType, i, this.itemOut);
                                this.listBuilder.addItem((IValueReference)this.itemStorage);
                            }
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                        this.listBuilder.write(this.resultOut, true);
                        resultPointable.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.RECORD_NAMES;
    }
}

