/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class ArrayIndexUtil {
    public static IAType getSubFieldType(ARecordType recordType, List<List<String>> unnestList, List<String> projectList) throws AlgebricksException {
        List<String> flattenedFieldName = ArrayIndexUtil.getFlattenedKeyFieldNames(unnestList, projectList);
        List<Boolean> unnestFlags = ArrayIndexUtil.getUnnestFlags(unnestList, projectList);
        IAType subType = recordType.getFieldType(flattenedFieldName.get(0));
        for (int i = 1; i < flattenedFieldName.size(); ++i) {
            if (subType == null) {
                return null;
            }
            if (subType.getTypeTag().equals((Object)ATypeTag.UNION) && !(subType = ((AUnionType)subType).getActualType()).getTypeTag().equals((Object)ATypeTag.OBJECT) && !subType.getTypeTag().equals((Object)ATypeTag.ARRAY) && !subType.getTypeTag().equals((Object)ATypeTag.MULTISET)) {
                throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Field accessor is not defined for values of type " + subType.getTypeTag()});
            }
            if (subType.getTypeTag().equals((Object)ATypeTag.OBJECT) && !unnestFlags.get(i - 1).booleanValue()) {
                subType = ((ARecordType)subType).getFieldType(flattenedFieldName.get(i));
                continue;
            }
            if ((subType.getTypeTag().equals((Object)ATypeTag.ARRAY) || subType.getTypeTag().equals((Object)ATypeTag.MULTISET)) && unnestFlags.get(i - 1).booleanValue()) {
                subType = (subType = TypeComputeUtils.extractListItemType((IAType)subType)) != null ? ((ARecordType)subType).getFieldType(flattenedFieldName.get(i)) : null;
                continue;
            }
            throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{unnestFlags.get(i - 1) != false ? "Object type given, but unnest flag is also raised." : "Array/multiset type given, but unnest flag is lowered."});
        }
        if (subType != null && unnestFlags.get(unnestFlags.size() - 1).booleanValue()) {
            if (subType instanceof AbstractCollectionType) {
                subType = TypeComputeUtils.extractListItemType((IAType)subType);
            } else {
                throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Array type expected for last term, but given: " + subType.getTypeTag()});
            }
        }
        return subType;
    }

    public static boolean isSubFieldNullable(ARecordType recordType, List<List<String>> unnestList, List<String> projectList) throws AlgebricksException {
        List<String> flattenedFieldName = ArrayIndexUtil.getFlattenedKeyFieldNames(unnestList, projectList);
        List<Boolean> unnestFlags = ArrayIndexUtil.getUnnestFlags(unnestList, projectList);
        IAType subType = recordType.getFieldType(flattenedFieldName.get(0));
        for (int i = 1; i < flattenedFieldName.size(); ++i) {
            if (subType == null) {
                return true;
            }
            if (subType.getTypeTag().equals((Object)ATypeTag.UNION)) {
                if (NonTaggedFormatUtil.isOptional((IAType)subType)) {
                    return true;
                }
                if ((subType = ((AUnionType)subType).getActualType()).getTypeTag() != ATypeTag.OBJECT) {
                    throw new AsterixException("Field accessor is not defined for values of type " + subType.getTypeTag());
                }
            }
            if (subType instanceof ARecordType) {
                subType = ((ARecordType)subType).getFieldType(flattenedFieldName.get(i));
                continue;
            }
            if (subType instanceof AbstractCollectionType && unnestFlags.get(i - 1).booleanValue()) {
                subType = (subType = TypeComputeUtils.extractListItemType((IAType)subType)) != null ? ((ARecordType)subType).getFieldType(flattenedFieldName.get(i)) : null;
                continue;
            }
            throw CompilationException.create((ErrorCode)ErrorCode.COMPILATION_ILLEGAL_STATE, (Serializable[])new Serializable[]{"Illegal field type " + subType.getTypeTag() + " when checking field nullability"});
        }
        return subType == null || NonTaggedFormatUtil.isOptional((IAType)subType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pair<IAType, Boolean> getNonNullableOpenFieldType(IAType fieldType, List<List<String>> unnestList, List<String> projectList, ARecordType recType) throws AlgebricksException {
        Pair<IAType, Boolean> keyPairType = null;
        ARecordType subType = recType;
        boolean nullable = false;
        List<String> flattenedFieldName = ArrayIndexUtil.getFlattenedKeyFieldNames(unnestList, projectList);
        List<Boolean> unnestFlags = ArrayIndexUtil.getUnnestFlags(unnestList, projectList);
        for (int i = 0; i < flattenedFieldName.size(); ++i) {
            if (subType instanceof AUnionType) {
                nullable = nullable || ((AUnionType)subType).isUnknownableType();
                subType = ((AUnionType)subType).getActualType();
            }
            if (subType instanceof ARecordType) {
                subType = subType.getFieldType(flattenedFieldName.get(i));
            } else {
                if (!(subType instanceof AOrderedListType) && !(subType instanceof AUnorderedListType) || !unnestFlags.get(i - 1).booleanValue()) throw AsterixException.create((ErrorCode)ErrorCode.COMPILATION_ILLEGAL_STATE, (Serializable[])new Serializable[]{"Unexpected type " + (IAType)subType + ", expected record, array, or multi-set."});
                if (!((subType = TypeComputeUtils.extractListItemType((IAType)subType)) instanceof ARecordType)) throw AsterixException.create((ErrorCode)ErrorCode.COMPILATION_ILLEGAL_STATE, (Serializable[])new Serializable[]{"Unexpected type " + (IAType)subType + ", expected record."});
                subType = subType.getFieldType(flattenedFieldName.get(i));
            }
            if (subType != null) continue;
            keyPairType = Index.getNonNullableType(fieldType);
            break;
        }
        if (subType != null) {
            IAType keyType = ArrayIndexUtil.getSubFieldType(recType, unnestList, projectList);
            Pair<IAType, Boolean> pair = Index.getNonNullableType(keyType);
            pair.second = (Boolean)pair.second != false || ArrayIndexUtil.isSubFieldNullable(recType, unnestList, projectList);
            keyPairType = pair;
        }
        keyPairType.second = (Boolean)keyPairType.second != false || nullable;
        return keyPairType;
    }

    public static List<String> getFlattenedKeyFieldNames(List<List<String>> unnestList, List<String> projectList) {
        if (unnestList == null) {
            return projectList;
        }
        ArrayList<String> flattenedKeyNameList = new ArrayList<String>();
        for (List<String> unnestField : unnestList) {
            flattenedKeyNameList.addAll(unnestField);
        }
        if (projectList != null) {
            flattenedKeyNameList.addAll(projectList);
        }
        return flattenedKeyNameList;
    }

    public static List<Boolean> getUnnestFlags(List<List<String>> unnestList, List<String> projectList) {
        if (unnestList.isEmpty()) {
            ArrayList<Boolean> unnestFlags = new ArrayList<Boolean>();
            for (String ignored : projectList) {
                unnestFlags.add(false);
            }
            return unnestFlags;
        }
        ArrayList<Boolean> unnestFlagsPrefix = new ArrayList<Boolean>();
        for (List<String> unnestField : unnestList) {
            for (int i = 0; i < unnestField.size() - 1; ++i) {
                unnestFlagsPrefix.add(false);
            }
            unnestFlagsPrefix.add(true);
        }
        if (projectList == null) {
            return unnestFlagsPrefix;
        }
        ArrayList<Boolean> unnestFlags = new ArrayList<Boolean>(unnestFlagsPrefix);
        for (int i = 0; i < projectList.size(); ++i) {
            unnestFlags.add(false);
        }
        return unnestFlags;
    }

    public static void walkArrayPath(Index index, ARecordType baseRecordType, List<String> flattenedFieldName, List<Boolean> unnestFlags, TypeTrackerCommandExecutor commandExecutor) throws AlgebricksException {
        ArrayPath arrayPath = new ArrayPath(flattenedFieldName, unnestFlags).invoke();
        List<List<String>> fieldNamesPerArray = arrayPath.fieldNamesPerArray;
        List<Boolean> unnestFlagsPerArray = arrayPath.unnestFlagsPerArray;
        boolean requiresOnlyOneUnnest = unnestFlags.stream().filter(f -> f).count() == 1L;
        boolean isTrackingType = baseRecordType != null;
        ARecordType workingType = baseRecordType;
        for (int i = 0; i < fieldNamesPerArray.size(); ++i) {
            ARecordType startingStepRecordType;
            ARecordType aRecordType = startingStepRecordType = isTrackingType ? workingType : null;
            if (isTrackingType) {
                if (!workingType.getTypeTag().equals((Object)ATypeTag.OBJECT)) {
                    throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Mismatched record type to depth-indicators. Expected record type, but got: " + workingType.getTypeTag()});
                }
                ARecordType intermediateRecordType = startingStepRecordType;
                List<String> fieldName = fieldNamesPerArray.get(i);
                for (String fieldPart : fieldName) {
                    if (!(isTrackingType = isTrackingType && intermediateRecordType.doesFieldExist(fieldPart)) || !((workingType = (IAType)Index.getNonNullableOpenFieldType((Index)index, (IAType)intermediateRecordType.getFieldType((String)fieldPart), Collections.singletonList(fieldPart), (ARecordType)intermediateRecordType).first) instanceof ARecordType)) continue;
                    intermediateRecordType = workingType;
                }
            }
            if (unnestFlagsPerArray.get(i).booleanValue()) {
                if (isTrackingType && (workingType = TypeComputeUtils.extractListItemType((IAType)workingType)) == null) {
                    throw new AsterixException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{"Expected list type inside record: " + startingStepRecordType});
                }
                boolean isFirstArrayStep = i == 0;
                boolean isLastUnnestInIntermediateStep = i < fieldNamesPerArray.size() - 1;
                commandExecutor.executeActionOnEachArrayStep(startingStepRecordType, (IAType)workingType, fieldNamesPerArray.get(i), isFirstArrayStep, isLastUnnestInIntermediateStep);
            }
            if (i != fieldNamesPerArray.size() - 1) continue;
            boolean isNonArrayStep = unnestFlagsPerArray.get(i) == false;
            commandExecutor.executeActionOnFinalArrayStep(startingStepRecordType, fieldNamesPerArray.get(i), isNonArrayStep, requiresOnlyOneUnnest);
        }
    }

    public static void walkArrayPath(List<String> flattenedFieldName, List<Boolean> unnestFlags, ActionCounterCommandExecutor commandExecutor) throws AlgebricksException {
        ArrayPath arrayPath = new ArrayPath(flattenedFieldName, unnestFlags).invoke();
        List<List<String>> fieldNamesPerArray = arrayPath.fieldNamesPerArray;
        List<Boolean> unnestFlagsPerArray = arrayPath.unnestFlagsPerArray;
        int numberOfActionsPerformed = 0;
        for (int i = 0; i < fieldNamesPerArray.size(); ++i) {
            boolean isUnnestFlagRaised = unnestFlagsPerArray.get(i);
            if (i == 0) {
                commandExecutor.executeActionOnFirstArrayStep();
                ++numberOfActionsPerformed;
                isUnnestFlagRaised = false;
            }
            if (isUnnestFlagRaised) {
                commandExecutor.executeActionOnIntermediateArrayStep(numberOfActionsPerformed++);
            }
            if (i != fieldNamesPerArray.size() - 1) continue;
            commandExecutor.executeActionOnFinalArrayStep(numberOfActionsPerformed++);
        }
    }

    private static class ArrayPath {
        private final List<String> flattenedFieldName;
        private final List<Boolean> unnestFlags;
        private List<List<String>> fieldNamesPerArray;
        private List<Boolean> unnestFlagsPerArray;

        public ArrayPath(List<String> flattenedFieldName, List<Boolean> unnestFlags) {
            this.flattenedFieldName = flattenedFieldName;
            this.unnestFlags = unnestFlags;
        }

        public ArrayPath invoke() {
            this.fieldNamesPerArray = new ArrayList<List<String>>();
            this.unnestFlagsPerArray = new ArrayList<Boolean>();
            ArrayList<String> workingRecordPath = new ArrayList<String>();
            for (int i = 0; i < this.unnestFlags.size(); ++i) {
                workingRecordPath.add(this.flattenedFieldName.get(i));
                if (i != this.unnestFlags.size() - 1 && !this.unnestFlags.get(i).booleanValue()) continue;
                this.unnestFlagsPerArray.add(this.unnestFlags.get(i));
                this.fieldNamesPerArray.add(workingRecordPath);
                workingRecordPath = new ArrayList();
            }
            return this;
        }
    }

    public static interface TypeTrackerCommandExecutor {
        public void executeActionOnEachArrayStep(ARecordType var1, IAType var2, List<String> var3, boolean var4, boolean var5) throws AlgebricksException;

        public void executeActionOnFinalArrayStep(ARecordType var1, List<String> var2, boolean var3, boolean var4) throws AlgebricksException;
    }

    public static interface ActionCounterCommandExecutor {
        public void executeActionOnFirstArrayStep() throws AlgebricksException;

        public void executeActionOnIntermediateArrayStep(int var1) throws AlgebricksException;

        public void executeActionOnFinalArrayStep(int var1) throws AlgebricksException;
    }
}

