/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.util.NoSuchElementException;

public class OptionalBoolean {
    private static final OptionalBoolean EMPTY = new OptionalBoolean(false){

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return -1;
        }

        @Override
        public boolean get() {
            throw new NoSuchElementException();
        }
    };
    private static final OptionalBoolean TRUE = new OptionalBoolean(true);
    private static final OptionalBoolean FALSE = new OptionalBoolean(false);
    private final boolean value;

    public static OptionalBoolean of(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static OptionalBoolean ofNullable(Boolean value) {
        return value == null ? EMPTY : (value != false ? TRUE : FALSE);
    }

    public static OptionalBoolean empty() {
        return EMPTY;
    }

    public static OptionalBoolean TRUE() {
        return TRUE;
    }

    public static OptionalBoolean FALSE() {
        return FALSE;
    }

    private OptionalBoolean(boolean value) {
        this.value = value;
    }

    public boolean isPresent() {
        return true;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean get() {
        return this.value;
    }

    public boolean getOrElse(boolean alternate) {
        return this.isPresent() ? this.get() : alternate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this == EMPTY || o == EMPTY) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionalBoolean that = (OptionalBoolean)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }
}

