/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.options;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;

public class BlockBlobSimpleUploadOptions {
    private final Flux<ByteBuffer> dataFlux;
    private final InputStream dataStream;
    private final long length;
    private BlobHttpHeaders headers;
    private Map<String, String> metadata;
    private Map<String, String> tags;
    private AccessTier tier;
    private byte[] contentMd5;
    private BlobRequestConditions requestConditions;
    private BlobImmutabilityPolicy immutabilityPolicy;
    private Boolean legalHold;

    public BlockBlobSimpleUploadOptions(Flux<ByteBuffer> data, long length) {
        StorageImplUtils.assertNotNull((String)"dataFlux", data);
        StorageImplUtils.assertInBounds((String)"length", (long)length, (long)0L, (long)Long.MAX_VALUE);
        this.dataFlux = data;
        this.length = length;
        this.dataStream = null;
    }

    public BlockBlobSimpleUploadOptions(InputStream data, long length) {
        StorageImplUtils.assertNotNull((String)"dataStream", (Object)data);
        StorageImplUtils.assertInBounds((String)"length", (long)length, (long)0L, (long)Long.MAX_VALUE);
        this.dataStream = data;
        this.length = length;
        this.dataFlux = null;
    }

    public Flux<ByteBuffer> getDataFlux() {
        return this.dataFlux;
    }

    public InputStream getDataStream() {
        return this.dataStream;
    }

    public long getLength() {
        return this.length;
    }

    public BlobHttpHeaders getHeaders() {
        return this.headers;
    }

    public BlockBlobSimpleUploadOptions setHeaders(BlobHttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public BlockBlobSimpleUploadOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public BlockBlobSimpleUploadOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public AccessTier getTier() {
        return this.tier;
    }

    public BlockBlobSimpleUploadOptions setTier(AccessTier tier) {
        this.tier = tier;
        return this;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    public BlockBlobSimpleUploadOptions setContentMd5(byte[] contentMd5) {
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        return this;
    }

    public BlobRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public BlockBlobSimpleUploadOptions setRequestConditions(BlobRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }

    public BlobImmutabilityPolicy getImmutabilityPolicy() {
        return this.immutabilityPolicy;
    }

    public BlockBlobSimpleUploadOptions setImmutabilityPolicy(BlobImmutabilityPolicy immutabilityPolicy) {
        this.immutabilityPolicy = immutabilityPolicy;
        return this;
    }

    public Boolean isLegalHold() {
        return this.legalHold;
    }

    public BlockBlobSimpleUploadOptions setLegalHold(Boolean legalHold) {
        this.legalHold = legalHold;
        return this;
    }
}

