/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.api.http.server.ClusterApiServlet;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterControllerDetailsApiServlet
extends ClusterApiServlet {
    private static final Logger LOGGER = LogManager.getLogger();

    public ClusterControllerDetailsApiServlet(ICcApplicationContext appCtx, ConcurrentMap<String, Object> ctx, String ... paths) {
        super(appCtx, ctx, paths);
    }

    @Override
    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
        PrintWriter responseWriter = response.writer();
        IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        try {
            response.setStatus(HttpResponseStatus.OK);
            ObjectNode json = "".equals(this.localPath(request)) ? (ObjectNode)this.getClusterStateJSON(request, "../").get("cc") : this.processNode(request, hcc);
            responseWriter.write(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
        }
        catch (IllegalArgumentException e) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "exception thrown for " + request, (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            responseWriter.write(e.toString());
        }
        responseWriter.flush();
    }

    private ObjectNode processNode(IServletRequest request, IHyracksClientConnection hcc) throws Exception {
        String localPath = this.localPath(request);
        if (localPath.endsWith("/")) {
            throw new IllegalArgumentException();
        }
        String[] parts = localPath.substring(1).split("/");
        if ("".equals(localPath)) {
            return (ObjectNode)this.getClusterStateJSON(request, "../../").get("cc");
        }
        if (parts.length == 1) {
            switch (parts[0]) {
                case "config": {
                    return (ObjectNode)OBJECT_MAPPER.readValue(this.processNodeDetails(hcc, false, true), ObjectNode.class);
                }
                case "stats": {
                    return (ObjectNode)OBJECT_MAPPER.readValue(this.processNodeDetails(hcc, true, false), ObjectNode.class);
                }
                case "threaddump": {
                    return this.processCCThreadDump(hcc);
                }
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private String processNodeDetails(IHyracksClientConnection hcc, boolean includeStats, boolean includeConfig) throws Exception {
        String details = hcc.getNodeDetailsJSON(null, includeStats, includeConfig);
        if (details == null) {
            throw new IllegalStateException("unable to retrieve details for CC");
        }
        return details;
    }

    private ObjectNode processCCThreadDump(IHyracksClientConnection hcc) throws Exception {
        String dump = hcc.getThreadDump(null);
        if (dump == null) {
            throw new IllegalStateException("unable to retrieve thread dump for CC");
        }
        return (ObjectNode)OBJECT_MAPPER.readTree(dump);
    }
}

