/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;

public class ThreadDumpUtil {
    private static final ObjectMapper om = new ObjectMapper();
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    private ThreadDumpUtil() {
    }

    public static String takeDumpJSONString() throws IOException {
        ObjectNode json = ThreadDumpUtil.takeDumpJSON();
        return om.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
    }

    public static ObjectNode takeDumpJSON() {
        ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(true, true);
        ArrayList threads = new ArrayList();
        for (ThreadInfo thread : threadInfos) {
            HashMap<String, Object> threadMap = new HashMap<String, Object>();
            threadMap.put("name", thread.getThreadName());
            threadMap.put("id", thread.getThreadId());
            threadMap.put("state", thread.getThreadState().name());
            ArrayList<String> stacktrace = new ArrayList<String>();
            for (StackTraceElement element : thread.getStackTrace()) {
                stacktrace.add(element.toString());
            }
            threadMap.put("stack", stacktrace);
            if (thread.getLockName() != null) {
                threadMap.put("lock_name", thread.getLockName());
            }
            if (thread.getLockOwnerId() != -1L) {
                threadMap.put("lock_owner_id", thread.getLockOwnerId());
            }
            if (thread.getBlockedTime() > 0L) {
                threadMap.put("blocked_time", thread.getBlockedTime());
            }
            if (thread.getBlockedCount() > 0L) {
                threadMap.put("blocked_count", thread.getBlockedCount());
            }
            if (thread.getLockedMonitors().length > 0) {
                threadMap.put("locked_monitors", thread.getLockedMonitors());
            }
            if (thread.getLockedSynchronizers().length > 0) {
                threadMap.put("locked_synchronizers", thread.getLockedSynchronizers());
            }
            threads.add(threadMap);
        }
        ObjectNode json = om.createObjectNode();
        json.put("date", String.valueOf(new Date()));
        json.putPOJO("threads", threads);
        long[] deadlockedThreads = threadMXBean.findDeadlockedThreads();
        long[] monitorDeadlockedThreads = threadMXBean.findMonitorDeadlockedThreads();
        if (deadlockedThreads != null && deadlockedThreads.length > 0) {
            json.putPOJO("deadlocked_thread_ids", (Object)deadlockedThreads);
        }
        if (monitorDeadlockedThreads != null && monitorDeadlockedThreads.length > 0) {
            json.putPOJO("monitor_deadlocked_thread_ids", (Object)monitorDeadlockedThreads);
        }
        return json;
    }

    public static String takeDumpString() {
        ThreadDumpHelper helper = new ThreadDumpHelper();
        Stream.of(threadMXBean.dumpAllThreads(true, true)).forEach(x$0 -> helper.addThread((ThreadInfo)x$0));
        return helper.dumpAsString();
    }

    static {
        om.enable(SerializationFeature.INDENT_OUTPUT);
    }

    static class ThreadDumpHelper {
        private final StringBuilder buf = new StringBuilder(32768);

        private ThreadDumpHelper() {
        }

        private void addThread(ThreadInfo ti) {
            this.buf.append('\n');
            this.quote(ti.getThreadName()).append(" [tid=").append(ti.getThreadId()).append(" state=").append((Object)ti.getThreadState());
            if (ti.getLockName() != null) {
                this.buf.append(" lock=").append(ti.getLockName());
                if (ti.getLockOwnerName() != null) {
                    this.buf.append(" lockOwner=");
                    this.quote(ti.getLockOwnerName()).append(" (tid=").append(ti.getLockOwnerId());
                }
            }
            if (ti.isSuspended()) {
                this.buf.append(" suspended=true");
            }
            this.buf.append("]\n");
            MutableInt depth = new MutableInt();
            for (StackTraceElement frame : ti.getStackTrace()) {
                int thisDepth = depth.getAndIncrement();
                this.buf.append("\tat ").append(frame).append('\n');
                Stream.of(ti.getLockedMonitors()).filter(m -> m.getLockedStackDepth() == thisDepth).forEach(this::output);
            }
            LockInfo[] lockedSynchronizers = ti.getLockedSynchronizers();
            if (lockedSynchronizers.length > 0) {
                this.buf.append("\n\tLocked synchronizers:\n");
                Stream.of(lockedSynchronizers).forEachOrdered(this::output);
            }
        }

        private StringBuilder quote(Object quotable) {
            return this.buf.append('\"').append(quotable).append('\"');
        }

        private StringBuilder output(MonitorInfo info) {
            return this.buf.append("\t- <").append("locked ").append(info).append(">\n");
        }

        private StringBuilder output(LockInfo info) {
            return this.buf.append("\t- ").append("").append(info).append("\n");
        }

        public String dumpAsString() {
            return this.buf.toString();
        }
    }
}

