/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.messaging.PartitionResourcesListResponse;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartitionResourcesListTask
implements IReplicaTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int partition;

    public PartitionResourcesListTask(int partition) {
        this.partition = partition;
    }

    @Override
    public void perform(INcApplicationContext appCtx, IReplicationWorker worker) throws HyracksDataException {
        LOGGER.debug("processing {}", (Object)this);
        PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)appCtx.getLocalResourceRepository();
        localResourceRepository.cleanup(this.partition);
        LOGGER.debug("cleaned up partition {}", (Object)this.partition);
        IReplicationStrategy replicationStrategy = appCtx.getReplicationManager().getReplicationStrategy();
        Map partitionReplicatedResources = localResourceRepository.getPartitionReplicatedResources(this.partition, replicationStrategy);
        LOGGER.debug("got partition {} resources", (Object)this.partition);
        List<String> partitionFiles = localResourceRepository.getPartitionReplicatedFiles(this.partition, replicationStrategy).stream().map(StoragePathUtil::getFileRelativePath).collect(Collectors.toList());
        LOGGER.debug("got partition {} files ({})", (Object)this.partition, (Object)partitionFiles.size());
        PartitionResourcesListResponse response = new PartitionResourcesListResponse(this.partition, partitionReplicatedResources, partitionFiles, appCtx.getReplicaManager().isPartitionOrigin(this.partition));
        ReplicationProtocol.sendTo(worker.getChannel(), response, worker.getReusableBuffer());
        LOGGER.debug("sent partition {} files list to requester", (Object)this.partition);
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.PARTITION_RESOURCES_REQUEST;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeInt(this.partition);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public String toString() {
        return "PartitionResourcesListTask{partition=" + this.partition + "}";
    }

    public static PartitionResourcesListTask create(DataInput input) throws HyracksDataException {
        try {
            int partition = input.readInt();
            return new PartitionResourcesListTask(partition);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

