/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushProjectDownRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.PROJECT) {
            return false;
        }
        ProjectOperator pi = (ProjectOperator)op;
        Mutable opRef2 = (Mutable)pi.getInputs().get(0);
        LinkedHashSet<LogicalVariable> toPush = new LinkedHashSet<LogicalVariable>();
        toPush.addAll(pi.getVariables());
        boolean recomputeSchema = op.getSchema() != null;
        Pair<Boolean, Boolean> p = PushProjectDownRule.pushThroughOp(toPush, (Mutable<ILogicalOperator>)opRef2, (ILogicalOperator)op, context, recomputeSchema);
        boolean smthWasPushed = (Boolean)p.first;
        if (((Boolean)p.second).booleanValue()) {
            opRef.setValue((Object)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()));
            smthWasPushed = true;
        }
        return smthWasPushed;
    }

    private static Pair<Boolean, Boolean> pushThroughOp(Set<LogicalVariable> toPush, Mutable<ILogicalOperator> opRef2, ILogicalOperator initialOp, IOptimizationContext context, boolean recomputeSchema) throws AlgebricksException {
        boolean canCommuteProjection;
        ArrayList<LogicalVariable> initProjectList = new ArrayList<LogicalVariable>(toPush);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        while (true) {
            boolean isMapOrLimit;
            if (op2.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE || op2.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE || op2.getOperatorTag() == LogicalOperatorTag.PROJECT || op2.getOperatorTag() == LogicalOperatorTag.REPLICATE || op2.getOperatorTag() == LogicalOperatorTag.SPLIT || op2.getOperatorTag() == LogicalOperatorTag.UNIONALL) {
                return new Pair((Object)false, (Object)false);
            }
            boolean bl = isMapOrLimit = op2.isMap() || op2.getOperatorTag() == LogicalOperatorTag.LIMIT;
            if (!isMapOrLimit) break;
            LinkedList usedVars = new LinkedList();
            VariableUtilities.getUsedVariables((ILogicalOperator)op2, usedVars);
            toPush.addAll(usedVars);
            LinkedList producedVars = new LinkedList();
            VariableUtilities.getProducedVariables((ILogicalOperator)op2, producedVars);
            toPush.removeAll(producedVars);
            opRef2 = (Mutable)op2.getInputs().get(0);
            op2 = (AbstractLogicalOperator)opRef2.getValue();
        }
        LinkedList produced2 = new LinkedList();
        VariableUtilities.getProducedVariables((ILogicalOperator)op2, produced2);
        LinkedList used2 = new LinkedList();
        VariableUtilities.getUsedVariables((ILogicalOperator)op2, used2);
        boolean bl = canCommuteProjection = initProjectList.containsAll(toPush) && initProjectList.containsAll(produced2) && initProjectList.containsAll(used2);
        if (!canCommuteProjection && op2.getOperatorTag() == LogicalOperatorTag.GROUP) {
            boolean gbyChanged = false;
            GroupByOperator gby = (GroupByOperator)op2;
            ArrayList<Pair> newDecorList = new ArrayList<Pair>();
            for (Pair p : gby.getDecorList()) {
                LogicalVariable decorVar = GroupByOperator.getDecorVariable((Pair)p);
                if (!toPush.contains(decorVar)) {
                    used2.remove(decorVar);
                    gbyChanged = true;
                    continue;
                }
                newDecorList.add(p);
            }
            gby.getDecorList().clear();
            gby.getDecorList().addAll(newDecorList);
            if (gbyChanged) {
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)gby);
                if (recomputeSchema) {
                    gby.recomputeSchema();
                }
            }
        }
        used2.clear();
        VariableUtilities.getUsedVariables((ILogicalOperator)op2, used2);
        toPush.addAll(used2);
        toPush.removeAll(produced2);
        if (toPush.isEmpty()) {
            return new Pair((Object)false, (Object)false);
        }
        boolean smthWasPushed = false;
        for (Mutable c : op2.getInputs()) {
            if (!PushProjectDownRule.pushNeededProjections(toPush, (Mutable<ILogicalOperator>)c, context, initialOp, recomputeSchema)) continue;
            smthWasPushed = true;
        }
        if (op2.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans n = (AbstractOperatorWithNestedPlans)op2;
            for (ILogicalPlan p : n.getNestedPlans()) {
                for (Mutable r : p.getRoots()) {
                    if (!PushProjectDownRule.pushNeededProjections(toPush, (Mutable<ILogicalOperator>)r, context, initialOp, recomputeSchema)) continue;
                    smthWasPushed = true;
                }
            }
        }
        return new Pair((Object)smthWasPushed, (Object)canCommuteProjection);
    }

    private static boolean pushNeededProjections(Set<LogicalVariable> toPush, Mutable<ILogicalOperator> opRef, IOptimizationContext context, ILogicalOperator initialOp, boolean recomputeSchema) throws AlgebricksException {
        LinkedHashSet allP = new LinkedHashSet();
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        VariableUtilities.getSubplanLocalLiveVariables((ILogicalOperator)op, allP);
        LinkedHashSet<LogicalVariable> toProject = new LinkedHashSet<LogicalVariable>();
        for (LogicalVariable v : toPush) {
            if (!allP.contains(v)) continue;
            toProject.add(v);
        }
        if (toProject.equals(allP)) {
            boolean push = false;
            if (((Boolean)PushProjectDownRule.pushThroughOp(toProject, opRef, (ILogicalOperator)initialOp, (IOptimizationContext)context, (boolean)recomputeSchema).first).booleanValue()) {
                push = true;
            }
            return push;
        }
        return PushProjectDownRule.pushAllProjectionsOnTopOf(toProject, opRef, context, initialOp, recomputeSchema);
    }

    private static boolean pushAllProjectionsOnTopOf(Collection<LogicalVariable> toPush, Mutable<ILogicalOperator> opRef, IOptimizationContext context, ILogicalOperator initialOp, boolean recomputeSchema) throws AlgebricksException {
        if (toPush.isEmpty()) {
            return false;
        }
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkAndAddToAlreadyCompared(initialOp, (ILogicalOperator)op)) {
            return false;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.PROJECT) {
            return false;
        }
        ProjectOperator pi2 = new ProjectOperator(new ArrayList<LogicalVariable>(toPush));
        pi2.setSourceLocation(op.getSourceLocation());
        pi2.getInputs().add(new MutableObject((Object)op));
        opRef.setValue((Object)pi2);
        pi2.setExecutionMode(op.getExecutionMode());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)pi2);
        if (recomputeSchema) {
            pi2.recomputeSchema();
        }
        return true;
    }
}

