/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.library.PythonLibraryEvaluator;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.ipc.impl.IPCSystem;

public class PythonLibraryEvaluatorFactory {
    private final ILibraryManager libraryManager;
    private final IPCSystem ipcSys;
    private final File pythonPath;
    private final IHyracksTaskContext ctx;
    private final ExternalFunctionResultRouter router;
    private final String sitePackagesPath;
    private final List<String> pythonArgs;
    private final Map<String, String> pythonEnv;

    public PythonLibraryEvaluatorFactory(IHyracksTaskContext ctx) throws AsterixException {
        String[] pythonArgsRaw;
        String[] addlSitePackages;
        this.ctx = ctx;
        this.libraryManager = ((INcApplicationContext)ctx.getJobletContext().getServiceContext().getApplicationContext()).getLibraryManager();
        this.router = this.libraryManager.getRouter();
        this.ipcSys = this.libraryManager.getIPCI();
        IApplicationConfig appCfg = ctx.getJobletContext().getServiceContext().getAppConfig();
        String pythonPathCmd = appCfg.getString((IOption)NCConfig.Option.PYTHON_CMD);
        boolean findPython = appCfg.getBoolean((IOption)NCConfig.Option.PYTHON_CMD_AUTOLOCATE);
        this.pythonArgs = new ArrayList<String>();
        if (pythonPathCmd == null) {
            if (findPython) {
                pythonPathCmd = "/usr/bin/env";
                this.pythonArgs.add("python3");
            } else {
                throw AsterixException.create((ErrorCode)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{"Python interpreter not specified, and " + NCConfig.Option.PYTHON_CMD_AUTOLOCATE.ini() + " is false"});
            }
        }
        this.pythonEnv = new HashMap<String, String>();
        String[] envRaw = appCfg.getStringArray((IOption)NCConfig.Option.PYTHON_ENV);
        if (envRaw != null) {
            for (String rawEnvArg : envRaw) {
                if (rawEnvArg.length() < 1) continue;
                String[] rawArgSplit = rawEnvArg.split("(?<!\\\\)=", 2);
                if (rawArgSplit.length < 2) {
                    throw AsterixException.create((ErrorCode)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{"Invalid environment variable format detected."});
                }
                this.pythonEnv.put(rawArgSplit[0], rawArgSplit[1]);
            }
        }
        this.pythonPath = new File(pythonPathCmd);
        ArrayList<Object> sitePkgs = new ArrayList<Object>();
        sitePkgs.add("site-packages");
        for (String sitePkg : addlSitePackages = appCfg.getStringArray((IOption)NCConfig.Option.PYTHON_ADDITIONAL_PACKAGES)) {
            if (sitePkg.length() <= 0) continue;
            sitePkgs.add(sitePkg);
        }
        if (appCfg.getBoolean((IOption)NCConfig.Option.PYTHON_USE_BUNDLED_MSGPACK)) {
            sitePkgs.add("ipc" + File.separator + "site-packages" + File.separator);
        }
        if ((pythonArgsRaw = appCfg.getStringArray((IOption)NCConfig.Option.PYTHON_ARGS)) != null) {
            for (String arg : pythonArgsRaw) {
                if (arg.length() <= 0) continue;
                this.pythonArgs.add(arg);
            }
        }
        StringBuilder sitePackagesPathBuilder = new StringBuilder();
        for (int i = 0; i < sitePkgs.size() - 1; ++i) {
            sitePackagesPathBuilder.append((String)sitePkgs.get(i));
            sitePackagesPathBuilder.append(File.pathSeparator);
        }
        sitePackagesPathBuilder.append((String)sitePkgs.get(sitePkgs.size() - 1));
        this.sitePackagesPath = sitePackagesPathBuilder.toString();
    }

    public PythonLibraryEvaluator getEvaluator(IExternalFunctionInfo fnInfo, SourceLocation sourceLoc) throws IOException, AsterixException {
        return PythonLibraryEvaluator.getInstance(fnInfo, this.libraryManager, this.router, this.ipcSys, this.pythonPath, this.ctx, this.sitePackagesPath, this.pythonArgs, this.pythonEnv, this.ctx.getWarningCollector(), sourceLoc);
    }
}

