/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractArrayAddRemoveEval;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.asterix.runtime.utils.DescriptorFactoryUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ArrayRemoveDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private IAType[] argTypes;
    public static final IFunctionDescriptorFactory FACTORY = DescriptorFactoryUtil.createFactory(ArrayRemoveDescriptor::new, FunctionTypeInferers.SET_ARGUMENTS_TYPE);

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_REMOVE;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArrayRemoveEval(args, ctx, ArrayRemoveDescriptor.this.argTypes);
            }
        };
    }

    public void setImmutableStates(Object ... states) {
        this.argTypes = (IAType[])states;
    }

    public static class ArrayRemoveEval
    extends AbstractArrayAddRemoveEval {
        private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
        private final IPointable item = new VoidPointable();
        private final IBinaryComparator[] comp;

        ArrayRemoveEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx, IAType[] argTypes) throws HyracksDataException {
            super(args, ctx, 0, 1, args.length - 1, argTypes, false, false);
            this.comp = ArrayRemoveEval.createValuesComparators(argTypes);
        }

        @Override
        protected int getPosition(IFrameTupleReference tuple, IPointable listArg, ATypeTag listTag) {
            return 0;
        }

        @Override
        protected void processList(ListAccessor listAccessor, IAsterixListBuilder listBuilder, IPointable[] removed, int position) throws IOException {
            for (int i = 0; i < listAccessor.size(); ++i) {
                listAccessor.getOrWriteItem(i, this.item, this.storage);
                boolean addItem = true;
                for (int j = 0; j < removed.length; ++j) {
                    if (this.comp[j].compare(this.item.getByteArray(), this.item.getStartOffset(), this.item.getLength(), removed[j].getByteArray(), removed[j].getStartOffset(), removed[j].getLength()) != 0) continue;
                    addItem = false;
                    break;
                }
                if (!addItem) continue;
                listBuilder.addItem((IValueReference)this.item);
            }
        }

        private static IBinaryComparator[] createValuesComparators(IAType[] argTypes) {
            BuiltinType itemType = argTypes[0].getTypeTag().isListType() ? ((AbstractCollectionType)argTypes[0]).getItemType() : BuiltinType.ANY;
            IBinaryComparator[] comparators = new IBinaryComparator[argTypes.length - 1];
            for (int i = 1; i < argTypes.length; ++i) {
                comparators[i - 1] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)itemType, (Object)argTypes[i], true).createBinaryComparator();
            }
            return comparators;
        }
    }
}

