/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.util.HashMap;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BuiltinFeedPolicies {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final FeedPolicyEntity BASIC = BuiltinFeedPolicies.initializeBasicPolicy();
    public static final FeedPolicyEntity ADVANCED_FT_DISCARD = BuiltinFeedPolicies.initializeAdvancedFTDiscardPolicy();
    public static final FeedPolicyEntity ADVANCED_FT_SPILL = BuiltinFeedPolicies.initializeAdvancedFTSpillPolicy();
    public static final FeedPolicyEntity ELASTIC = BuiltinFeedPolicies.initializeAdvancedFTElasticPolicy();
    private static final FeedPolicyEntity[] POLICIES = new FeedPolicyEntity[]{BASIC, ADVANCED_FT_DISCARD, ADVANCED_FT_SPILL, ELASTIC};
    public static final FeedPolicyEntity DEFAULT_POLICY = BASIC;
    public static final String CONFIG_FEED_POLICY_KEY = "policy";

    private BuiltinFeedPolicies() {
    }

    public static FeedPolicyEntity getFeedPolicy(String policyName) {
        for (FeedPolicyEntity policy : POLICIES) {
            if (!policy.getPolicyName().equalsIgnoreCase(policyName)) continue;
            return policy;
        }
        return null;
    }

    private static FeedPolicyEntity initializeBasicPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("elastic", Boolean.toString(false));
        String description = "Basic";
        return new FeedPolicyEntity(MetadataConstants.METADATA_DATAVERSE_NAME, "Basic", description, policyParams);
    }

    private static FeedPolicyEntity initializeAdvancedFTDiscardPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("elastic", Boolean.toString(false));
        policyParams.put("flowcontrol.enabled", Boolean.toString(true));
        policyParams.put("max.spill.size.on.disk", Boolean.toString(false));
        policyParams.put("max.fraction.discard", "100");
        policyParams.put("logging.statistics", Boolean.toString(true));
        String description = "FlowControl 100% Discard during congestion";
        return new FeedPolicyEntity(MetadataConstants.METADATA_DATAVERSE_NAME, "Discard", description, policyParams);
    }

    private static FeedPolicyEntity initializeAdvancedFTSpillPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("elastic", Boolean.toString(false));
        policyParams.put("flowcontrol.enabled", Boolean.toString(true));
        policyParams.put("spill.to.disk.on.congestion", "" + Boolean.TRUE);
        policyParams.put("max.spill.size.on.disk", Long.toString(-1L));
        String description = "FlowControl 100% Spill during congestion";
        return new FeedPolicyEntity(MetadataConstants.METADATA_DATAVERSE_NAME, "Spill", description, policyParams);
    }

    private static FeedPolicyEntity initializeAdvancedFTElasticPolicy() {
        HashMap<String, String> policyParams = new HashMap<String, String>();
        policyParams.put("elastic", Boolean.toString(true));
        policyParams.put("flowcontrol.enabled", Boolean.toString(true));
        policyParams.put("logging.statistics", Boolean.toString(true));
        String description = "Basic Monitored Fault-Tolerant Elastic";
        return new FeedPolicyEntity(MetadataConstants.METADATA_DATAVERSE_NAME, "AdvancedFT_Elastic", description, policyParams);
    }

    public static void insertInitialFeedPolicies(MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        for (FeedPolicyEntity feedPolicy : POLICIES) {
            MetadataManager.INSTANCE.addFeedPolicy(mdTxnCtx, feedPolicy);
        }
        LOGGER.info("Finished adding built-in feed policies.");
    }
}

