/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.env.resources.ShutdownHook;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.internal.schedulers.NewThreadWorker;
import rx.internal.schedulers.ScheduledAction;
import rx.internal.util.RxThreadFactory;
import rx.internal.util.SubscriptionList;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public class CoreScheduler
extends Scheduler
implements ShutdownHook {
    private static final String THREAD_NAME_PREFIX = "cb-computations-";
    private static final RxThreadFactory THREAD_FACTORY = new RxThreadFactory("cb-computations-");
    final AtomicReference<FixedSchedulerPool> pool;
    private final int poolSize;
    static final FixedSchedulerPool NONE = new FixedSchedulerPool(0);
    static final PoolWorker SHUTDOWN_WORKER = new PoolWorker((ThreadFactory)new RxThreadFactory("cb-computationShutdown-"));

    public CoreScheduler(int poolSize) {
        this.poolSize = poolSize;
        this.pool = new AtomicReference<FixedSchedulerPool>(NONE);
        this.start();
    }

    public void start() {
        FixedSchedulerPool update = new FixedSchedulerPool(this.poolSize);
        if (!this.pool.compareAndSet(NONE, update)) {
            update.shutdown();
        }
    }

    @Override
    public Observable<Boolean> shutdown() {
        FixedSchedulerPool curr;
        do {
            if ((curr = this.pool.get()) != NONE) continue;
            return Observable.just((Object)true);
        } while (!this.pool.compareAndSet(curr, NONE));
        curr.shutdown();
        return Observable.just((Object)true);
    }

    @Override
    public boolean isShutdown() {
        return this.pool.get() == NONE;
    }

    public Scheduler.Worker createWorker() {
        return new EventLoopWorker(this.pool.get().getEventLoop());
    }

    public Subscription scheduleDirect(Action0 action) {
        PoolWorker pw = this.pool.get().getEventLoop();
        return pw.scheduleActual(action, -1L, TimeUnit.NANOSECONDS);
    }

    static {
        SHUTDOWN_WORKER.unsubscribe();
    }

    private static final class PoolWorker
    extends NewThreadWorker {
        PoolWorker(ThreadFactory threadFactory) {
            super(threadFactory);
        }
    }

    private static class EventLoopWorker
    extends Scheduler.Worker {
        private final SubscriptionList serial = new SubscriptionList();
        private final CompositeSubscription timed = new CompositeSubscription();
        private final SubscriptionList both = new SubscriptionList(new Subscription[]{this.serial, this.timed});
        private final PoolWorker poolWorker;

        EventLoopWorker(PoolWorker poolWorker) {
            this.poolWorker = poolWorker;
        }

        public void unsubscribe() {
            this.both.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.both.isUnsubscribed();
        }

        public Subscription schedule(Action0 action) {
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            ScheduledAction s = this.poolWorker.scheduleActual(action, 0L, null, this.serial);
            return s;
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            ScheduledAction s = this.poolWorker.scheduleActual(action, delayTime, unit, this.timed);
            return s;
        }
    }

    static final class FixedSchedulerPool {
        final int size;
        final PoolWorker[] eventLoops;
        long n;

        FixedSchedulerPool(int poolSize) {
            this.size = poolSize;
            this.eventLoops = new PoolWorker[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.eventLoops[i] = new PoolWorker((ThreadFactory)THREAD_FACTORY);
            }
        }

        public PoolWorker getEventLoop() {
            int c = this.size;
            if (c == 0) {
                return SHUTDOWN_WORKER;
            }
            return this.eventLoops[(int)(this.n++ % (long)c)];
        }

        public void shutdown() {
            for (PoolWorker w : this.eventLoops) {
                w.unsubscribe();
            }
        }
    }
}

