/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.trace;

import java.util.concurrent.TimeUnit;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.hyracks.util.trace.TraceCategoryRegistry;

final class Event {
    private static final long NANOTIME_DELTA_TO_EPOCH = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    public final String name;
    public final long cat;
    public final ITracer.Phase ph;
    public final long ts;
    public final long pid;
    public final long tid;
    public final ITracer.Scope scope;
    public final String args;
    public final TraceCategoryRegistry registry;

    private Event(String name, long cat, ITracer.Phase ph, long ts, long pid, long tid, ITracer.Scope scope, String args, TraceCategoryRegistry registry) {
        this.name = name;
        this.cat = cat;
        this.ph = ph;
        this.ts = ts;
        this.pid = pid;
        this.tid = tid;
        this.scope = scope;
        this.args = args;
        this.registry = registry;
    }

    private static long timestamp() {
        return (System.nanoTime() - NANOTIME_DELTA_TO_EPOCH) / 1000L;
    }

    public static Event create(String name, long cat, ITracer.Phase ph, long pid, long tid, ITracer.Scope scope, String args, TraceCategoryRegistry registry) {
        return new Event(name, cat, ph, Event.timestamp(), pid, tid, scope, args, registry);
    }

    public String toJson() {
        return this.append(new StringBuilder()).toString();
    }

    public StringBuilder append(StringBuilder sb) {
        sb.append("{");
        if (this.name != null) {
            sb.append("\"name\":\"").append(this.name).append("\",");
        }
        if (this.cat != 0L) {
            String catName = this.registry.getName(this.cat);
            sb.append("\"cat\":\"").append(catName).append("\",");
        }
        sb.append("\"ph\":\"").append((Object)this.ph).append("\",");
        sb.append("\"pid\":\"").append(this.pid).append("\",");
        sb.append("\"tid\":").append(this.tid).append(",");
        sb.append("\"ts\":").append(this.ts);
        if (this.scope != null) {
            sb.append(",\"s\":\"").append((Object)this.scope).append("\"");
        }
        if (this.args != null) {
            if (this.args.isEmpty()) {
                sb.append(",\"args\":").append("\"\"");
            } else {
                sb.append(",\"args\":").append(this.args);
            }
        }
        sb.append("}");
        return sb;
    }
}

