/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job.profiling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.com.job.profiling.counters.Counter;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.IndexStats;
import org.apache.hyracks.api.job.profiling.counters.ICounter;

public class OperatorStats
implements IOperatorStats {
    private static final long serialVersionUID = 6401830963367567167L;
    public final String operatorName;
    public final ICounter tupleCounter;
    public final ICounter timeCounter;
    public final ICounter diskIoCounter;
    private final Map<String, IndexStats> indexesStats;

    public OperatorStats(String operatorName) {
        if (operatorName == null || operatorName.isEmpty()) {
            throw new IllegalArgumentException("operatorName must not be null or empty");
        }
        this.operatorName = operatorName;
        this.tupleCounter = new Counter("tupleCounter");
        this.timeCounter = new Counter("timeCounter");
        this.diskIoCounter = new Counter("diskIoCounter");
        this.indexesStats = new HashMap<String, IndexStats>();
    }

    public static IOperatorStats create(DataInput input) throws IOException {
        String name = input.readUTF();
        OperatorStats operatorStats = new OperatorStats(name);
        operatorStats.readFields(input);
        return operatorStats;
    }

    @Override
    public String getName() {
        return this.operatorName;
    }

    @Override
    public ICounter getTupleCounter() {
        return this.tupleCounter;
    }

    @Override
    public ICounter getTimeCounter() {
        return this.timeCounter;
    }

    @Override
    public ICounter getDiskIoCounter() {
        return this.diskIoCounter;
    }

    @Override
    public void updateIndexesStats(Map<String, IndexStats> stats) {
        if (stats == null) {
            return;
        }
        for (Map.Entry<String, IndexStats> stat : stats.entrySet()) {
            String indexName = stat.getKey();
            IndexStats indexStat = stat.getValue();
            IndexStats existingIndexStat = this.indexesStats.get(indexName);
            if (existingIndexStat == null) {
                this.indexesStats.put(indexName, new IndexStats(indexName, indexStat.getNumPages()));
                continue;
            }
            existingIndexStat.updateNumPages(indexStat.getNumPages());
        }
    }

    @Override
    public Map<String, IndexStats> getIndexesStats() {
        return this.indexesStats;
    }

    @Override
    public void updateFrom(IOperatorStats stats) {
        this.tupleCounter.update(stats.getTupleCounter().get());
        this.timeCounter.update(stats.getTimeCounter().get());
        this.diskIoCounter.update(stats.getDiskIoCounter().get());
        this.updateIndexesStats(stats.getIndexesStats());
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        output.writeUTF(this.operatorName);
        output.writeLong(this.tupleCounter.get());
        output.writeLong(this.timeCounter.get());
        output.writeLong(this.diskIoCounter.get());
        this.writeIndexesStats(output);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.tupleCounter.set(input.readLong());
        this.timeCounter.set(input.readLong());
        this.diskIoCounter.set(input.readLong());
        this.readIndexesStats(input);
    }

    private void writeIndexesStats(DataOutput output) throws IOException {
        output.writeInt(this.indexesStats.size());
        for (Map.Entry<String, IndexStats> indexStat : this.indexesStats.entrySet()) {
            output.writeUTF(indexStat.getKey());
            indexStat.getValue().writeFields(output);
        }
    }

    private void readIndexesStats(DataInput input) throws IOException {
        int numIndexes = input.readInt();
        for (int i = 0; i < numIndexes; ++i) {
            String indexName = input.readUTF();
            IndexStats indexStats = IndexStats.create(input);
            this.indexesStats.put(indexName, indexStats);
        }
    }

    public String toString() {
        return "{ \"operatorName\": \"" + this.operatorName + "\", \"" + this.tupleCounter.getName() + "\": " + this.tupleCounter.get() + ", \"" + this.timeCounter.getName() + "\": " + this.timeCounter.get() + ", \", \"indexStats\": \"" + this.indexesStats + "\" }";
    }
}

