/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.message;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.app.cc.CCExtensionManager;
import org.apache.asterix.app.message.ExecuteStatementRequestMessage;
import org.apache.asterix.app.message.InternalRequestResponse;
import org.apache.asterix.app.result.ResponsePrinter;
import org.apache.asterix.app.translator.RequestParameters;
import org.apache.asterix.common.api.IRequestReference;
import org.apache.asterix.common.api.IResponsePrinter;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.hyracks.bootstrap.CCApplication;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.sqlpp.parser.TokenMgrError;
import org.apache.asterix.messaging.CCMessageBroker;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.translator.IRequestParameters;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.translator.ResultProperties;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.commons.io.output.NullWriter;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractInternalRequestMessage
implements ICcAddressedMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    final String nodeRequestId;
    final long requestMessageId;
    final IRequestReference requestReference;
    final Map<String, String> additionalParams;

    public AbstractInternalRequestMessage(String nodeRequestId, long requestMessageId, IRequestReference requestReference, Map<String, String> additionalParams) {
        this.nodeRequestId = nodeRequestId;
        this.requestMessageId = requestMessageId;
        this.requestReference = requestReference;
        this.additionalParams = additionalParams;
    }

    public void handle(ICcApplicationContext ccAppCtx) throws HyracksDataException {
        ICCServiceContext ccSrvContext = ccAppCtx.getServiceContext();
        ClusterControllerService ccSrv = (ClusterControllerService)ccSrvContext.getControllerService();
        CCApplication ccApp = (CCApplication)ccSrv.getApplication();
        CCMessageBroker messageBroker = (CCMessageBroker)ccSrvContext.getMessageBroker();
        RuntimeDataException rejectionReason = ExecuteStatementRequestMessage.getRejectionReason(ccSrv, this.nodeRequestId);
        if (rejectionReason != null) {
            this.sendRejection((Exception)rejectionReason, messageBroker, this.requestMessageId, this.nodeRequestId);
            return;
        }
        CCExtensionManager ccExtMgr = (CCExtensionManager)ccAppCtx.getExtensionManager();
        ILangCompilationProvider compilationProvider = ccExtMgr.getCompilationProvider(ILangExtension.Language.SQLPP);
        IStorageComponentProvider componentProvider = ccAppCtx.getStorageComponentProvider();
        IStatementExecutorFactory statementExecutorFactory = ccApp.getStatementExecutorFactory();
        InternalRequestResponse responseMsg = new InternalRequestResponse(this.requestMessageId);
        SessionOutput sessionOutput = new SessionOutput(new SessionConfig(SessionConfig.OutputFormat.ADM), new PrintWriter((Writer)NullWriter.NULL_WRITER));
        ResponsePrinter printer = new ResponsePrinter(sessionOutput);
        ResultProperties resultProperties = new ResultProperties(IStatementExecutor.ResultDelivery.IMMEDIATE, 1L);
        RequestParameters requestParams = new RequestParameters(this.requestReference, "", null, resultProperties, new IStatementExecutor.Stats(), new IStatementExecutor.StatementProperties(), null, null, null, this.additionalParams, Collections.emptyMap(), false);
        MetadataManager.INSTANCE.init();
        IStatementExecutor translator = statementExecutorFactory.create(ccAppCtx, Collections.singletonList(this.produceStatement()), sessionOutput, compilationProvider, componentProvider, (IResponsePrinter)printer);
        try {
            translator.compileAndExecute(ccAppCtx.getHcc(), (IRequestParameters)requestParams);
        }
        catch (TokenMgrError | AlgebricksException | HyracksException pe) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.WARN, pe.getMessage(), pe);
            responseMsg.setError(pe);
        }
        catch (Exception e) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.ERROR, "Unexpected exception", (Throwable)e);
            responseMsg.setError(e);
        }
        try {
            messageBroker.sendApplicationMessageToNC(responseMsg, this.nodeRequestId);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, e.toString(), (Throwable)e);
        }
    }

    protected abstract Statement produceStatement();

    private void sendRejection(Exception reason, CCMessageBroker messageBroker, long requestMessageId, String requestNodeId) {
        InternalRequestResponse msg = new InternalRequestResponse(requestMessageId);
        msg.setError(reason);
        try {
            messageBroker.sendApplicationMessageToNC(msg, requestNodeId);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, e.toString(), (Throwable)e);
        }
    }
}

