/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.normalizers;

import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyProperties;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;

public class ByteArrayNormalizedKeyComputerFactory
implements INormalizedKeyComputerFactory {
    private static final long serialVersionUID = 1L;
    public static final INormalizedKeyProperties PROPERTIES = new INormalizedKeyProperties(){
        private static final long serialVersionUID = 1L;

        public int getNormalizedKeyLength() {
            return 1;
        }

        public boolean isDecisive() {
            return false;
        }
    };
    public static ByteArrayNormalizedKeyComputerFactory INSTANCE = new ByteArrayNormalizedKeyComputerFactory();

    public INormalizedKeyComputer createNormalizedKeyComputer() {
        return new INormalizedKeyComputer(){

            public void normalize(byte[] bytes, int start, int length, int[] normalizedKeys, int keyStart) {
                normalizedKeys[keyStart] = ByteArrayPointable.normalize((byte[])bytes, (int)start);
            }

            public INormalizedKeyProperties getNormalizedKeyProperties() {
                return PROPERTIES;
            }
        };
    }

    public INormalizedKeyProperties getNormalizedKeyProperties() {
        return PROPERTIES;
    }
}

