/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.TimeoutException;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func3;
import rx.functions.Func4;
import rx.internal.producers.ProducerArbiter;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.SerialSubscription;

class OperatorTimeoutBase<T>
implements Observable.Operator<T, T> {
    final FirstTimeoutStub<T> firstTimeoutStub;
    final TimeoutStub<T> timeoutStub;
    final Observable<? extends T> other;
    final Scheduler scheduler;

    OperatorTimeoutBase(FirstTimeoutStub<T> firstTimeoutStub, TimeoutStub<T> timeoutStub, Observable<? extends T> other, Scheduler scheduler) {
        this.firstTimeoutStub = firstTimeoutStub;
        this.timeoutStub = timeoutStub;
        this.other = other;
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> subscriber) {
        Scheduler.Worker inner = this.scheduler.createWorker();
        subscriber.add(inner);
        SerializedSubscriber<T> synchronizedSubscriber = new SerializedSubscriber<T>(subscriber);
        SerialSubscription serial = new SerialSubscription();
        synchronizedSubscriber.add(serial);
        TimeoutSubscriber<? extends T> timeoutSubscriber = new TimeoutSubscriber<T>(synchronizedSubscriber, this.timeoutStub, serial, this.other, inner);
        synchronizedSubscriber.add(timeoutSubscriber);
        synchronizedSubscriber.setProducer(timeoutSubscriber.arbiter);
        serial.set((Subscription)this.firstTimeoutStub.call(timeoutSubscriber, 0L, inner));
        return timeoutSubscriber;
    }

    static final class TimeoutSubscriber<T>
    extends Subscriber<T> {
        final SerialSubscription serial;
        final SerializedSubscriber<T> serializedSubscriber;
        final TimeoutStub<T> timeoutStub;
        final Observable<? extends T> other;
        final Scheduler.Worker inner;
        final ProducerArbiter arbiter;
        boolean terminated;
        long actual;

        TimeoutSubscriber(SerializedSubscriber<T> serializedSubscriber, TimeoutStub<T> timeoutStub, SerialSubscription serial, Observable<? extends T> other, Scheduler.Worker inner) {
            this.serializedSubscriber = serializedSubscriber;
            this.timeoutStub = timeoutStub;
            this.serial = serial;
            this.other = other;
            this.inner = inner;
            this.arbiter = new ProducerArbiter();
        }

        @Override
        public void setProducer(Producer p) {
            this.arbiter.setProducer(p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T value) {
            long a;
            boolean onNextWins = false;
            TimeoutSubscriber timeoutSubscriber = this;
            synchronized (timeoutSubscriber) {
                if (!this.terminated) {
                    a = ++this.actual;
                    onNextWins = true;
                } else {
                    a = this.actual;
                }
            }
            if (onNextWins) {
                this.serializedSubscriber.onNext(value);
                this.serial.set((Subscription)this.timeoutStub.call(this, a, value, this.inner));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable error) {
            boolean onErrorWins = false;
            TimeoutSubscriber timeoutSubscriber = this;
            synchronized (timeoutSubscriber) {
                if (!this.terminated) {
                    this.terminated = true;
                    onErrorWins = true;
                }
            }
            if (onErrorWins) {
                this.serial.unsubscribe();
                this.serializedSubscriber.onError(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            boolean onCompletedWins = false;
            TimeoutSubscriber timeoutSubscriber = this;
            synchronized (timeoutSubscriber) {
                if (!this.terminated) {
                    this.terminated = true;
                    onCompletedWins = true;
                }
            }
            if (onCompletedWins) {
                this.serial.unsubscribe();
                this.serializedSubscriber.onCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimeout(long seqId) {
            long expected = seqId;
            boolean timeoutWins = false;
            TimeoutSubscriber timeoutSubscriber = this;
            synchronized (timeoutSubscriber) {
                if (expected == this.actual && !this.terminated) {
                    this.terminated = true;
                    timeoutWins = true;
                }
            }
            if (timeoutWins) {
                if (this.other == null) {
                    this.serializedSubscriber.onError(new TimeoutException());
                } else {
                    Subscriber second = new Subscriber<T>(){

                        @Override
                        public void onNext(T t) {
                            TimeoutSubscriber.this.serializedSubscriber.onNext(t);
                        }

                        @Override
                        public void onError(Throwable e) {
                            TimeoutSubscriber.this.serializedSubscriber.onError(e);
                        }

                        @Override
                        public void onCompleted() {
                            TimeoutSubscriber.this.serializedSubscriber.onCompleted();
                        }

                        @Override
                        public void setProducer(Producer p) {
                            TimeoutSubscriber.this.arbiter.setProducer(p);
                        }
                    };
                    this.other.unsafeSubscribe(second);
                    this.serial.set(second);
                }
            }
        }
    }

    static interface TimeoutStub<T>
    extends Func4<TimeoutSubscriber<T>, Long, T, Scheduler.Worker, Subscription> {
    }

    static interface FirstTimeoutStub<T>
    extends Func3<TimeoutSubscriber<T>, Long, Scheduler.Worker, Subscription> {
    }
}

