/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.function.Function;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.control.common.controllers.ControllerConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.util.file.FileUtil;

public class NodeProperties
extends AbstractProperties {
    public NodeProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public boolean isInitialRun() {
        return this.accessor.getBoolean(Option.INITIAL_RUN);
    }

    public boolean isVirtualNc() {
        return this.accessor.getInt((IOption)NCConfig.Option.NCSERVICE_PORT) == -1;
    }

    public String getTxnLogDir() {
        return this.accessor.getString(Option.TXN_LOG_DIR);
    }

    public static enum Option implements IOption
    {
        INITIAL_RUN(OptionTypes.BOOLEAN, false, "A flag indicating if it's the first time the NC is started"),
        CORE_DUMP_DIR(OptionTypes.STRING, appConfig -> FileUtil.joinPath((String[])new String[]{appConfig.getString((IOption)ControllerConfig.Option.DEFAULT_DIR), "coredump"}), "The directory where node core dumps should be written", "<value of " + ControllerConfig.Option.DEFAULT_DIR.cmdline() + ">/coredump"),
        TXN_LOG_DIR(OptionTypes.STRING, appConfig -> FileUtil.joinPath((String[])new String[]{appConfig.getString((IOption)ControllerConfig.Option.DEFAULT_DIR), "txn-log"}), "The directory where transaction logs should be stored", "<value of " + ControllerConfig.Option.DEFAULT_DIR.cmdline() + ">/txn-log"),
        STARTING_PARTITION_ID(OptionTypes.INTEGER, -1, "The first partition id to assign to iodevices on this node (-1 == auto-assign)");

        private final IOptionType type;
        private final Object defaultValue;
        private final String description;
        private final String defaultValueDescription;

        private <T> Option(IOptionType<T> type, T defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
            this.defaultValueDescription = null;
        }

        private <T> Option(IOptionType<T> type, Function<IApplicationConfig, T> defaultValue, String description, String defaultValueDescription) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
            this.defaultValueDescription = defaultValueDescription;
        }

        public Section section() {
            return Section.NC;
        }

        public String description() {
            return this.description;
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public String usageDefaultOverride(IApplicationConfig accessor, Function<IOption, String> optionPrinter) {
            return this.defaultValueDescription;
        }

        public boolean hidden() {
            return this == INITIAL_RUN;
        }
    }
}

