/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.AbstractUTF8TokenFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.UTF8NGramTokenFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.UTF8WordToken;

public class UTF8WordTokenFactory
extends AbstractUTF8TokenFactory {
    private static final long serialVersionUID = 1L;

    public UTF8WordTokenFactory() {
    }

    public UTF8WordTokenFactory(byte tokenTypeTag, byte countTypeTag) {
        super(tokenTypeTag, countTypeTag);
    }

    @Override
    public IToken createToken() {
        return new UTF8WordToken(this.tokenTypeTag, this.countTypeTag);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.put("tokenTypeTag", (short)this.tokenTypeTag);
        json.put("countTypeTag", (short)this.countTypeTag);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        byte tokenTypeTag = (byte)json.get("tokenTypeTag").asInt();
        byte countTypeTag = (byte)json.get("countTypeTag").asInt();
        return new UTF8NGramTokenFactory(tokenTypeTag, countTypeTag);
    }
}

