/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common;

import com.azure.storage.common.ProgressReceiver;
import com.azure.storage.common.implementation.StorageImplUtils;

public final class ParallelTransferOptions {
    private final Integer blockSize;
    private final Integer numBuffers;
    private final ProgressReceiver progressReceiver;
    private final Integer maxSingleUploadSize;

    public ParallelTransferOptions(Integer blockSize, Integer numBuffers, ProgressReceiver progressReceiver, Integer maxSingleUploadSize) {
        this.blockSize = blockSize;
        if (numBuffers != null) {
            StorageImplUtils.assertInBounds("numBuffers", numBuffers.intValue(), 2L, Integer.MAX_VALUE);
        }
        this.numBuffers = numBuffers;
        this.progressReceiver = progressReceiver;
        this.maxSingleUploadSize = maxSingleUploadSize;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public Integer getNumBuffers() {
        return this.numBuffers;
    }

    public ProgressReceiver getProgressReceiver() {
        return this.progressReceiver;
    }

    public Integer getMaxSingleUploadSize() {
        return this.maxSingleUploadSize;
    }
}

