/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job.profiling.counters;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hyracks.api.io.IWritable;

public class MultiResolutionEventProfiler
implements IWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int[] times;
    private long offset;
    private int ptr;
    private int resolution;
    private int eventCounter;

    public static MultiResolutionEventProfiler create(DataInput dis) throws IOException {
        MultiResolutionEventProfiler multiResolutionEventProfiler = new MultiResolutionEventProfiler();
        multiResolutionEventProfiler.readFields(dis);
        return multiResolutionEventProfiler;
    }

    private MultiResolutionEventProfiler() {
    }

    public MultiResolutionEventProfiler(int nSamples) {
        this.times = new int[nSamples];
        this.offset = -1L;
        this.ptr = 0;
        this.resolution = 1;
        this.eventCounter = 0;
    }

    public void reportEvent() {
        ++this.eventCounter;
        if (this.eventCounter % this.resolution != 0) {
            return;
        }
        if (this.ptr >= this.times.length) {
            this.compact();
            return;
        }
        this.eventCounter = 0;
        long time = System.currentTimeMillis();
        if (this.offset < 0L) {
            this.offset = time;
        }
        int value = (int)(time - this.offset);
        this.times[this.ptr++] = value;
    }

    private void compact() {
        for (int i = 1; i < this.ptr / 2; ++i) {
            this.times[i] = this.times[i * 2];
        }
        this.resolution <<= 1;
        this.ptr >>= 1;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getCount() {
        return this.ptr;
    }

    public int[] getSamples() {
        return this.times;
    }

    public long getOffset() {
        return this.offset;
    }

    public void writeFields(DataOutput output) throws IOException {
        output.writeInt(this.eventCounter);
        output.writeLong(this.offset);
        output.writeInt(this.ptr);
        output.writeInt(this.resolution);
        output.writeInt(this.times.length);
        for (int i = 0; i < this.times.length; ++i) {
            output.writeInt(this.times[i]);
        }
    }

    public void readFields(DataInput input) throws IOException {
        this.eventCounter = input.readInt();
        this.offset = input.readLong();
        this.ptr = input.readInt();
        this.resolution = input.readInt();
        int nSamples = input.readInt();
        this.times = new int[nSamples];
        for (int i = 0; i < this.times.length; ++i) {
            this.times[i] = input.readInt();
        }
    }
}

