/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.impls;

import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProvider;

public class Rectangle {
    private int dim;
    private double[] low;
    private double[] high;

    public Rectangle(int dim) {
        this.dim = dim;
        this.low = new double[this.dim];
        this.high = new double[this.dim];
    }

    public int getDim() {
        return this.dim;
    }

    public double getLow(int i) {
        return this.low[i];
    }

    public double getHigh(int i) {
        return this.high[i];
    }

    public void setLow(int i, double value) {
        this.low[i] = value;
    }

    public void setHigh(int i, double value) {
        this.high[i] = value;
    }

    public void set(ITupleReference tuple, IPrimitiveValueProvider[] valueProviders) {
        for (int i = 0; i < this.getDim(); ++i) {
            int j = i + this.getDim();
            this.setLow(i, valueProviders[i].getValue(tuple.getFieldData(i), tuple.getFieldStart(i)));
            this.setHigh(i, valueProviders[j].getValue(tuple.getFieldData(j), tuple.getFieldStart(j)));
        }
    }

    public void enlarge(ITupleReference tupleToBeInserted, IPrimitiveValueProvider[] valueProviders) {
        for (int i = 0; i < this.getDim(); ++i) {
            int j = this.getDim() + i;
            double low = valueProviders[i].getValue(tupleToBeInserted.getFieldData(i), tupleToBeInserted.getFieldStart(i));
            if (this.getLow(i) > low) {
                this.setLow(i, low);
            }
            double high = valueProviders[j].getValue(tupleToBeInserted.getFieldData(j), tupleToBeInserted.getFieldStart(j));
            if (!(this.getHigh(i) < high)) continue;
            this.setHigh(i, high);
        }
    }

    public double enlargedArea(ITupleReference tupleToBeInserted, IPrimitiveValueProvider[] valueProviders) {
        double areaBeforeEnlarge = this.area();
        double areaAfterEnlarge = 1.0;
        for (int i = 0; i < this.getDim(); ++i) {
            int j = this.getDim() + i;
            double low = valueProviders[i].getValue(tupleToBeInserted.getFieldData(i), tupleToBeInserted.getFieldStart(i));
            double lowAfterEnlargement = this.getLow(i) > low ? low : this.getLow(i);
            double high = valueProviders[j].getValue(tupleToBeInserted.getFieldData(j), tupleToBeInserted.getFieldStart(j));
            double highAfterEnlargement = this.getHigh(i) < high ? high : this.getHigh(i);
            areaAfterEnlarge *= highAfterEnlargement - lowAfterEnlargement;
        }
        return areaAfterEnlarge - areaBeforeEnlarge;
    }

    public double margin() {
        double margin = 0.0;
        double mul = Math.pow(2.0, (double)this.getDim() - 1.0);
        for (int i = 0; i < this.getDim(); ++i) {
            margin += (this.getHigh(i) - this.getLow(i)) * mul;
        }
        return margin;
    }

    public double overlappedArea(Rectangle rec) {
        double area = 1.0;
        for (int i = 0; i < this.getDim(); ++i) {
            if (this.getLow(i) > rec.getHigh(i) || this.getHigh(i) < rec.getLow(i)) {
                return 0.0;
            }
            double f1 = Math.max(this.getLow(i), rec.getLow(i));
            double f2 = Math.min(this.getHigh(i), rec.getHigh(i));
            area *= f2 - f1;
        }
        return area;
    }

    public double area() {
        double area = 1.0;
        for (int i = 0; i < this.getDim(); ++i) {
            area *= this.getHigh(i) - this.getLow(i);
        }
        return area;
    }
}

