/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.utils.NormalizedKeyUtils;
import org.apache.hyracks.dataflow.std.buffermanager.IDeletableTupleBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.ITuplePointerAccessor;
import org.apache.hyracks.dataflow.std.sort.ITupleSorter;
import org.apache.hyracks.dataflow.std.structures.IResetableComparable;
import org.apache.hyracks.dataflow.std.structures.IResetableComparableFactory;
import org.apache.hyracks.dataflow.std.structures.MaxHeap;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TupleSorterHeapSort
implements ITupleSorter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IDeletableTupleBufferManager bufferManager;
    private final ITuplePointerAccessor bufferAccessor1;
    private final ITuplePointerAccessor bufferAccessor2;
    private final int topK;
    private final FrameTupleAppender outputAppender;
    private final IFrame outputFrame;
    private final int[] sortFields;
    private final INormalizedKeyComputer[] nkcs;
    private final boolean normalizedKeyDecisive;
    private final int[] normalizedKeyLength;
    private final int normalizedKeyTotalLength;
    private final IBinaryComparator[] comparators;
    private final HeapEntry maxEntry;
    private final HeapEntry newEntry;
    private MaxHeap heap;
    private boolean isSorted;
    private final int[] nmk;
    private static final Comparator<IResetableComparable> entryComparator = new Comparator<IResetableComparable>(){

        @Override
        public int compare(IResetableComparable o1, IResetableComparable o2) {
            return o1.compareTo(o2);
        }
    };

    public TupleSorterHeapSort(IHyracksTaskContext ctx, IDeletableTupleBufferManager bufferManager, int topK, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories) throws HyracksDataException {
        this.bufferManager = bufferManager;
        this.bufferAccessor1 = bufferManager.createTuplePointerAccessor();
        this.bufferAccessor2 = bufferManager.createTuplePointerAccessor();
        this.topK = topK;
        this.outputFrame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.outputAppender = new FrameTupleAppender();
        this.sortFields = sortFields;
        int runningNormalizedKeyTotalLength = 0;
        if (keyNormalizerFactories != null) {
            int decisivePrefixLength = NormalizedKeyUtils.getDecisivePrefixLength((INormalizedKeyComputerFactory[])keyNormalizerFactories);
            int normalizedKeys = decisivePrefixLength < keyNormalizerFactories.length ? decisivePrefixLength + 1 : decisivePrefixLength;
            this.nkcs = new INormalizedKeyComputer[normalizedKeys];
            this.normalizedKeyLength = new int[normalizedKeys];
            for (int i = 0; i < normalizedKeys; ++i) {
                this.nkcs[i] = keyNormalizerFactories[i].createNormalizedKeyComputer();
                this.normalizedKeyLength[i] = keyNormalizerFactories[i].getNormalizedKeyProperties().getNormalizedKeyLength();
                runningNormalizedKeyTotalLength += this.normalizedKeyLength[i];
            }
            this.normalizedKeyDecisive = decisivePrefixLength == comparatorFactories.length;
        } else {
            this.nkcs = null;
            this.normalizedKeyLength = null;
            this.normalizedKeyDecisive = false;
        }
        this.normalizedKeyTotalLength = runningNormalizedKeyTotalLength;
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.heap = new MaxHeap(new HeapEntryFactory(), topK);
        this.maxEntry = new HeapEntry();
        this.newEntry = new HeapEntry();
        this.isSorted = false;
        this.nmk = new int[runningNormalizedKeyTotalLength];
    }

    @Override
    public int getTupleCount() {
        return this.heap.getNumEntries();
    }

    @Override
    public boolean insertTuple(IFrameTupleAccessor frameTupleAccessor, int index) throws HyracksDataException {
        if (this.isSorted) {
            throw new HyracksDataException("The Heap haven't be reset after sorting, the order of using this class is not correct.");
        }
        int[] nmkey = this.getPNK(frameTupleAccessor, index);
        if (this.heap.getNumEntries() >= this.topK) {
            this.heap.peekMax(this.maxEntry);
            if (this.compareTuple(frameTupleAccessor, index, nmkey, this.maxEntry) >= 0) {
                return true;
            }
        }
        this.newEntry.reset(nmkey);
        if (!this.bufferManager.insertTuple(frameTupleAccessor, index, this.newEntry.tuplePointer)) {
            return false;
        }
        if (this.heap.getNumEntries() < this.topK) {
            this.heap.insert(this.newEntry);
        } else {
            this.bufferManager.deleteTuple(this.maxEntry.tuplePointer);
            this.heap.replaceMax(this.newEntry);
        }
        return true;
    }

    private int[] getPNK(IFrameTupleAccessor fta, int tIx) {
        if (this.nkcs == null) {
            return this.nmk;
        }
        int keyPos = 0;
        byte[] buffer = fta.getBuffer().array();
        for (int i = 0; i < this.nkcs.length; ++i) {
            int sfIdx = this.sortFields[i];
            this.nkcs[i].normalize(buffer, fta.getAbsoluteFieldStartOffset(tIx, sfIdx), fta.getFieldLength(tIx, sfIdx), this.nmk, keyPos);
            keyPos += this.normalizedKeyLength[i];
        }
        return this.nmk;
    }

    private int compareTuple(IFrameTupleAccessor frameTupleAccessor, int tid, int[] nmkey, HeapEntry maxEntry) throws HyracksDataException {
        int cmpNormalizedKey = NormalizedKeyUtils.compareNormalizeKeys((int[])nmkey, (int)0, (int[])maxEntry.nmk, (int)0, (int)this.normalizedKeyTotalLength);
        if (cmpNormalizedKey != 0 || this.normalizedKeyDecisive) {
            return cmpNormalizedKey;
        }
        this.bufferAccessor2.reset(maxEntry.tuplePointer);
        byte[] b1 = frameTupleAccessor.getBuffer().array();
        byte[] b2 = this.bufferAccessor2.getBuffer().array();
        for (int f = 0; f < this.comparators.length; ++f) {
            int l2;
            int s2;
            int l1;
            int fIdx = this.sortFields[f];
            int s1 = frameTupleAccessor.getAbsoluteFieldStartOffset(tid, fIdx);
            int c = this.comparators[f].compare(b1, s1, l1 = frameTupleAccessor.getFieldLength(tid, fIdx), b2, s2 = this.bufferAccessor2.getAbsFieldStartOffset(fIdx), l2 = this.bufferAccessor2.getFieldLength(fIdx));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public boolean hasRemaining() {
        return this.getTupleCount() > 0;
    }

    @Override
    public void reset() throws HyracksDataException {
        this.bufferManager.reset();
        this.heap.reset();
        this.isSorted = false;
    }

    @Override
    public void sort() throws HyracksDataException {
        IResetableComparable[] entries = this.heap.getEntries();
        int count = this.heap.getNumEntries();
        Arrays.sort(entries, 0, count, entryComparator);
        this.isSorted = true;
    }

    @Override
    public void close() throws HyracksDataException {
        this.heap = null;
        this.bufferManager.close();
        this.isSorted = false;
    }

    @Override
    public int flush(IFrameWriter writer) throws HyracksDataException {
        this.outputAppender.reset(this.outputFrame, true);
        int maxFrameSize = this.outputFrame.getFrameSize();
        int numEntries = this.heap.getNumEntries();
        IResetableComparable[] entries = this.heap.getEntries();
        int io = 0;
        for (int i = 0; i < numEntries; ++i) {
            HeapEntry minEntry = (HeapEntry)entries[i];
            this.bufferAccessor1.reset(minEntry.tuplePointer);
            int flushed = FrameUtils.appendToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.outputAppender, (byte[])this.bufferAccessor1.getBuffer().array(), (int)this.bufferAccessor1.getTupleStartOffset(), (int)this.bufferAccessor1.getTupleLength());
            if (flushed <= 0) continue;
            maxFrameSize = Math.max(maxFrameSize, flushed);
            ++io;
        }
        maxFrameSize = Math.max(maxFrameSize, this.outputFrame.getFrameSize());
        this.outputAppender.write(writer, true);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Flushed records:" + numEntries + "; Flushed through " + (io + 1) + " frames");
        }
        return maxFrameSize;
    }

    class HeapEntry
    implements IResetableComparable<HeapEntry> {
        int[] nmk;
        TuplePointer tuplePointer = new TuplePointer();

        public HeapEntry() {
            this.nmk = new int[TupleSorterHeapSort.this.normalizedKeyTotalLength];
        }

        @Override
        public int compareTo(HeapEntry o) {
            int cmpNormalizedKey = NormalizedKeyUtils.compareNormalizeKeys((int[])this.nmk, (int)0, (int[])o.nmk, (int)0, (int)TupleSorterHeapSort.this.normalizedKeyTotalLength);
            if (cmpNormalizedKey != 0 || TupleSorterHeapSort.this.normalizedKeyDecisive) {
                return cmpNormalizedKey;
            }
            TupleSorterHeapSort.this.bufferAccessor1.reset(this.tuplePointer);
            TupleSorterHeapSort.this.bufferAccessor2.reset(o.tuplePointer);
            byte[] b1 = TupleSorterHeapSort.this.bufferAccessor1.getBuffer().array();
            byte[] b2 = TupleSorterHeapSort.this.bufferAccessor2.getBuffer().array();
            for (int f = 0; f < TupleSorterHeapSort.this.comparators.length; ++f) {
                int c;
                int fIdx = TupleSorterHeapSort.this.sortFields[f];
                int s1 = TupleSorterHeapSort.this.bufferAccessor1.getAbsFieldStartOffset(fIdx);
                int l1 = TupleSorterHeapSort.this.bufferAccessor1.getFieldLength(fIdx);
                int s2 = TupleSorterHeapSort.this.bufferAccessor2.getAbsFieldStartOffset(fIdx);
                int l2 = TupleSorterHeapSort.this.bufferAccessor2.getFieldLength(fIdx);
                try {
                    c = TupleSorterHeapSort.this.comparators[f].compare(b1, s1, l1, b2, s2, l2);
                }
                catch (HyracksDataException e) {
                    throw new IllegalStateException(e);
                }
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        @Override
        public void reset(int[] nmkey) {
            if (TupleSorterHeapSort.this.normalizedKeyTotalLength > 0) {
                System.arraycopy(nmkey, 0, this.nmk, 0, TupleSorterHeapSort.this.normalizedKeyTotalLength);
            }
        }

        @Override
        public void reset(HeapEntry other) {
            this.reset(other.nmk);
            this.tuplePointer.reset(other.tuplePointer);
        }
    }

    class HeapEntryFactory
    implements IResetableComparableFactory<HeapEntry> {
        HeapEntryFactory() {
        }

        @Override
        public IResetableComparable<HeapEntry> createResetableComparable() {
            return new HeapEntry();
        }
    }
}

