/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.dataflow.std.buffermanager.ITuplePointerAccessor;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;

public abstract class AbstractTuplePointerAccessor
implements ITuplePointerAccessor {
    protected int tid = -1;

    abstract IFrameTupleAccessor getInnerAccessor();

    abstract void resetInnerAccessor(TuplePointer var1);

    @Override
    public void reset(TuplePointer tuplePointer) {
        this.resetInnerAccessor(tuplePointer);
        this.tid = tuplePointer.getTupleIndex();
    }

    @Override
    public int getTupleStartOffset() {
        return this.getTupleStartOffset(this.tid);
    }

    @Override
    public int getTupleLength() {
        return this.getTupleLength(this.tid);
    }

    @Override
    public int getAbsFieldStartOffset(int fieldId) {
        return this.getAbsoluteFieldStartOffset(this.tid, fieldId);
    }

    @Override
    public int getFieldLength(int fieldId) {
        return this.getFieldLength(this.tid, fieldId);
    }

    public ByteBuffer getBuffer() {
        return this.getInnerAccessor().getBuffer();
    }

    public int getFieldCount() {
        return this.getInnerAccessor().getFieldCount();
    }

    public int getFieldSlotsLength() {
        return this.getInnerAccessor().getFieldSlotsLength();
    }

    protected void checkTupleIndex(int tupleIndex) {
        if (tupleIndex != this.tid) {
            throw new IllegalArgumentException("ITupleBufferAccessor can not access the different tid other than the one given in reset function");
        }
    }

    public int getFieldEndOffset(int tupleIndex, int fIdx) {
        this.checkTupleIndex(tupleIndex);
        return this.getInnerAccessor().getFieldEndOffset(this.tid, fIdx);
    }

    public int getFieldStartOffset(int tupleIndex, int fIdx) {
        this.checkTupleIndex(tupleIndex);
        return this.getInnerAccessor().getFieldStartOffset(tupleIndex, fIdx);
    }

    public int getFieldLength(int tupleIndex, int fIdx) {
        this.checkTupleIndex(tupleIndex);
        return this.getInnerAccessor().getFieldLength(tupleIndex, fIdx);
    }

    public int getTupleLength(int tupleIndex) {
        this.checkTupleIndex(tupleIndex);
        return this.getInnerAccessor().getTupleLength(tupleIndex);
    }

    public int getTupleEndOffset(int tupleIndex) {
        this.checkTupleIndex(tupleIndex);
        return this.getInnerAccessor().getTupleEndOffset(tupleIndex);
    }

    public int getTupleStartOffset(int tupleIndex) {
        this.checkTupleIndex(tupleIndex);
        return this.getInnerAccessor().getTupleStartOffset(tupleIndex);
    }

    public int getAbsoluteFieldStartOffset(int tupleIndex, int fIdx) {
        this.checkTupleIndex(tupleIndex);
        return this.getInnerAccessor().getAbsoluteFieldStartOffset(tupleIndex, fIdx);
    }

    public int getTupleCount() {
        return this.getInnerAccessor().getTupleCount();
    }

    public void reset(ByteBuffer buffer) {
        throw new IllegalAccessError("Should never call this reset");
    }
}

