/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.Calendar;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DataverseTupleTranslator
extends AbstractTupleTranslator<Dataverse> {
    private static final int DATAVERSE_PAYLOAD_TUPLE_FIELD_INDEX = 1;
    protected AMutableInt32 aInt32;

    protected DataverseTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.DATAVERSE_DATASET, 1);
        if (getTuple) {
            this.aInt32 = new AMutableInt32(-1);
        }
    }

    @Override
    protected Dataverse createMetadataEntityFromARecord(ARecord dataverseRecord) {
        String dataverseCanonicalName = ((AString)dataverseRecord.getValueByPos(0)).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        String format = ((AString)dataverseRecord.getValueByPos(1)).getStringValue();
        int pendingOp = ((AInt32)dataverseRecord.getValueByPos(3)).getIntegerValue();
        return new Dataverse(dataverseName, format, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Dataverse dataverse) throws HyracksDataException {
        String dataverseCanonicalName = dataverse.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.DATAVERSE_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataverse.getDataFormat());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(dataverse.getPendingOp());
        this.int32Serde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

