/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.util.StorageUtil;

public class CompilerProperties
extends AbstractProperties {
    public static final String COMPILER_SORTMEMORY_KEY = Option.COMPILER_SORTMEMORY.ini();
    public static final String COMPILER_GROUPMEMORY_KEY = Option.COMPILER_GROUPMEMORY.ini();
    public static final String COMPILER_JOINMEMORY_KEY = Option.COMPILER_JOINMEMORY.ini();
    public static final String COMPILER_WINDOWMEMORY_KEY = Option.COMPILER_WINDOWMEMORY.ini();
    public static final String COMPILER_TEXTSEARCHMEMORY_KEY = Option.COMPILER_TEXTSEARCHMEMORY.ini();
    public static final String COMPILER_PARALLELISM_KEY = Option.COMPILER_PARALLELISM.ini();
    public static final String COMPILER_SORT_PARALLEL_KEY = Option.COMPILER_SORT_PARALLEL.ini();
    public static final String COMPILER_SORT_SAMPLES_KEY = Option.COMPILER_SORT_SAMPLES.ini();
    public static final String COMPILER_INDEXONLY_KEY = Option.COMPILER_INDEXONLY.ini();
    public static final String COMPILER_INTERNAL_SANITYCHECK_KEY = Option.COMPILER_INTERNAL_SANITYCHECK.ini();
    public static final int COMPILER_PARALLELISM_AS_STORAGE = 0;

    public CompilerProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public long getSortMemorySize() {
        return this.accessor.getLong(Option.COMPILER_SORTMEMORY);
    }

    public long getJoinMemorySize() {
        return this.accessor.getLong(Option.COMPILER_JOINMEMORY);
    }

    public long getGroupMemorySize() {
        return this.accessor.getLong(Option.COMPILER_GROUPMEMORY);
    }

    public long getWindowMemorySize() {
        return this.accessor.getLong(Option.COMPILER_WINDOWMEMORY);
    }

    public long getTextSearchMemorySize() {
        return this.accessor.getLong(Option.COMPILER_TEXTSEARCHMEMORY);
    }

    public int getFrameSize() {
        return this.accessor.getInt(Option.COMPILER_FRAMESIZE);
    }

    public int getParallelism() {
        return this.accessor.getInt(Option.COMPILER_PARALLELISM);
    }

    public boolean getSortParallel() {
        return this.accessor.getBoolean(Option.COMPILER_SORT_PARALLEL);
    }

    public int getSortSamples() {
        return this.accessor.getInt(Option.COMPILER_SORT_SAMPLES);
    }

    public boolean isIndexOnly() {
        return this.accessor.getBoolean(Option.COMPILER_INDEXONLY);
    }

    public boolean isSanityCheck() {
        return this.accessor.getBoolean(Option.COMPILER_INTERNAL_SANITYCHECK);
    }

    public static enum Option implements IOption
    {
        COMPILER_SORTMEMORY(OptionTypes.LONG_BYTE_UNIT, StorageUtil.getLongSizeInBytes((long)32L, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE), "The memory budget (in bytes) for a sort operator instance in a partition"),
        COMPILER_JOINMEMORY(OptionTypes.LONG_BYTE_UNIT, StorageUtil.getLongSizeInBytes((long)32L, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE), "The memory budget (in bytes) for a join operator instance in a partition"),
        COMPILER_GROUPMEMORY(OptionTypes.LONG_BYTE_UNIT, StorageUtil.getLongSizeInBytes((long)32L, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE), "The memory budget (in bytes) for a group by operator instance in a partition"),
        COMPILER_WINDOWMEMORY(OptionTypes.LONG_BYTE_UNIT, StorageUtil.getLongSizeInBytes((long)32L, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE), "The memory budget (in bytes) for a window operator instance in a partition"),
        COMPILER_TEXTSEARCHMEMORY(OptionTypes.LONG_BYTE_UNIT, StorageUtil.getLongSizeInBytes((long)32L, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE), "The memory budget (in bytes) for an inverted-index-search operator instance in a partition"),
        COMPILER_FRAMESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)32, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE), "The page size (in bytes) for computation"),
        COMPILER_PARALLELISM(OptionTypes.INTEGER, 0, "The degree of parallelism for query execution. Zero means to use the storage parallelism as the query execution parallelism, while other integer values dictate the number of query execution parallel partitions. The system will fall back to use the number of all available CPU cores in the cluster as the degree of parallelism if the number set by a user is too large or too small"),
        COMPILER_SORT_PARALLEL(OptionTypes.BOOLEAN, true, "Enabling/Disabling full parallel sort"),
        COMPILER_SORT_SAMPLES(OptionTypes.POSITIVE_INTEGER, 100, "The number of samples which parallel sorting should take from each partition"),
        COMPILER_INDEXONLY(OptionTypes.BOOLEAN, true, "Enabling/disabling index-only plans"),
        COMPILER_INTERNAL_SANITYCHECK(OptionTypes.BOOLEAN, false, "Enable/disable compiler sanity check");

        private final IOptionType type;
        private final Object defaultValue;
        private final String description;

        private Option(IOptionType type, Object defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public Section section() {
            return Section.COMMON;
        }

        public String description() {
            return this.description;
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }
    }
}

