/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.web.util.IJSONOutputFunction;
import org.apache.hyracks.control.cc.web.util.JSONOutputRequestUtil;
import org.apache.hyracks.control.cc.work.GetNodeDetailsJSONWork;
import org.apache.hyracks.control.cc.work.GetNodeSummariesJSONWork;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class NodesRESTAPIFunction
implements IJSONOutputFunction {
    private ClusterControllerService ccs;

    public NodesRESTAPIFunction(ClusterControllerService ccs) {
        this.ccs = ccs;
    }

    @Override
    public ObjectNode invoke(String host, String servletPath, String[] arguments) throws Exception {
        ObjectMapper om = new ObjectMapper();
        ObjectNode result = om.createObjectNode();
        switch (arguments.length) {
            case 1: {
                if ("".equals(arguments[0])) {
                    GetNodeSummariesJSONWork gnse = new GetNodeSummariesJSONWork(this.ccs.getNodeManager());
                    this.ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)gnse);
                    result.set("result", (JsonNode)NodesRESTAPIFunction.enhanceSummaries(gnse.getSummaries(), host, servletPath));
                    break;
                }
                String nodeId = arguments[0];
                GetNodeDetailsJSONWork gnde = new GetNodeDetailsJSONWork(this.ccs.getNodeManager(), this.ccs.getCCConfig(), nodeId, true, true);
                this.ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)gnde);
                result.set("result", (JsonNode)gnde.getDetail());
            }
        }
        return result;
    }

    private static ArrayNode enhanceSummaries(ArrayNode summaries, String host, String servletPath) throws URISyntaxException {
        for (int i = 0; i < summaries.size(); ++i) {
            ObjectNode node = (ObjectNode)summaries.get(i);
            URI detailsUri = JSONOutputRequestUtil.uri(host, servletPath, node.get("node-id").asText());
            node.put("details", detailsUri.toString());
        }
        return summaries;
    }
}

