/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.dataflow;

import java.nio.ByteBuffer;
import org.apache.asterix.external.feed.dataflow.FeedExceptionHandler;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;

public class SyncFeedRuntimeInputHandler
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    private final FeedExceptionHandler exceptionHandler;

    public SyncFeedRuntimeInputHandler(IHyracksTaskContext ctx, IFrameWriter writer, FrameTupleAccessor fta) {
        this.writer = writer;
        this.exceptionHandler = new FeedExceptionHandler(ctx, fta);
    }

    public void open() throws HyracksDataException {
        this.writer.open();
    }

    public void nextFrame(ByteBuffer frame) throws HyracksDataException {
        while (frame != null) {
            try {
                this.writer.nextFrame(frame);
                return;
            }
            catch (HyracksDataException e) {
                if ((frame = this.exceptionHandler.handle(e, frame)) != null) continue;
                throw e;
            }
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void close() throws HyracksDataException {
        this.writer.close();
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }
}

