/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jms.internal;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.aries.transaction.jms.internal.PooledSession;
import org.apache.aries.transaction.jms.internal.SessionKey;
import org.apache.aries.transaction.jms.internal.SessionPool;
import org.apache.commons.pool.ObjectPoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPool {
    private Connection connection;
    private ConcurrentHashMap<SessionKey, SessionPool> cache;
    private ConcurrentLinkedQueue<PooledSession> loanedSessions = new ConcurrentLinkedQueue();
    private AtomicBoolean started = new AtomicBoolean(false);
    private int referenceCount;
    private ObjectPoolFactory poolFactory;
    private long lastUsed;
    private long firstUsed = this.lastUsed = System.currentTimeMillis();
    private boolean hasFailed;
    private boolean hasExpired;
    private int idleTimeout = 30000;
    private long expiryTimeout = 0L;

    public ConnectionPool(Connection connection, ObjectPoolFactory poolFactory) throws JMSException {
        this(connection, new ConcurrentHashMap<SessionKey, SessionPool>(), poolFactory);
        connection.setExceptionListener(new ExceptionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onException(JMSException exception) {
                ConnectionPool connectionPool = ConnectionPool.this;
                synchronized (connectionPool) {
                    ConnectionPool.this.hasFailed = true;
                }
            }
        });
    }

    public ConnectionPool(Connection connection, ConcurrentHashMap<SessionKey, SessionPool> cache, ObjectPoolFactory poolFactory) {
        this.connection = connection;
        this.cache = cache;
        this.poolFactory = poolFactory;
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.connection.start();
            }
            catch (JMSException e) {
                this.started.set(false);
                throw e;
            }
        }
    }

    public synchronized Connection getConnection() {
        return this.connection;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        SessionKey key = new SessionKey(transacted, ackMode);
        SessionPool pool = null;
        pool = this.cache.get(key);
        if (pool == null) {
            SessionPool newPool = this.createSessionPool(key);
            SessionPool prevPool = this.cache.putIfAbsent(key, newPool);
            if (prevPool != null && prevPool != newPool) {
                try {
                    newPool.close();
                }
                catch (Exception e) {
                    throw new JMSException(e.getMessage());
                }
            }
            pool = this.cache.get(key);
        }
        PooledSession session = pool.borrowSession();
        this.loanedSessions.add(session);
        return session;
    }

    public Session createXaSession(boolean transacted, int ackMode) throws JMSException {
        SessionKey key = new SessionKey(transacted, ackMode);
        SessionPool pool = null;
        pool = this.cache.get(key);
        if (pool == null) {
            SessionPool newPool = this.createSessionPool(key);
            SessionPool prevPool = this.cache.putIfAbsent(key, newPool);
            if (prevPool != null && prevPool != newPool) {
                try {
                    newPool.close();
                }
                catch (Exception e) {
                    throw new JMSException(e.getMessage());
                }
            }
            pool = this.cache.get(key);
        }
        PooledSession session = pool.borrowSession();
        this.loanedSessions.add(session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.connection != null) {
            try {
                Iterator<SessionPool> i = this.cache.values().iterator();
                while (i.hasNext()) {
                    SessionPool pool = i.next();
                    i.remove();
                    try {
                        pool.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    public synchronized void incrementReferenceCount() {
        ++this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
    }

    public synchronized void decrementReferenceCount() {
        --this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
        if (this.referenceCount == 0) {
            this.expiredCheck();
            for (PooledSession session : this.loanedSessions) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
            this.loanedSessions.clear();
            if (this.getConnection() != null) {
                // empty if block
            }
        }
    }

    public synchronized boolean expiredCheck() {
        if (this.connection == null) {
            return true;
        }
        if (this.hasExpired) {
            if (this.referenceCount == 0) {
                this.close();
            }
            return true;
        }
        if (this.hasFailed || this.idleTimeout > 0 && System.currentTimeMillis() > this.lastUsed + (long)this.idleTimeout || this.expiryTimeout > 0L && System.currentTimeMillis() > this.firstUsed + this.expiryTimeout) {
            this.hasExpired = true;
            if (this.referenceCount == 0) {
                this.close();
            }
            return true;
        }
        return false;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    protected SessionPool createSessionPool(SessionKey key) {
        return new SessionPool(this, key, this.poolFactory.createPool());
    }

    public void setExpiryTimeout(long expiryTimeout) {
        this.expiryTimeout = expiryTimeout;
    }

    public long getExpiryTimeout() {
        return this.expiryTimeout;
    }

    void onSessionReturned(PooledSession session) {
        this.loanedSessions.remove(session);
    }

    void onSessionInvalidated(PooledSession session) {
        this.loanedSessions.remove(session);
    }
}

