/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import org.apache.aries.subsystem.core.archive.AbstractDirective;

public class ProvisionPolicyDirective
extends AbstractDirective {
    public static final String NAME = "provision-policy";
    public static final String VALUE_ACCEPT_DEPENDENCIES = "acceptDependencies";
    public static final String VALUE_REJECT_DEPENDENCIES = "rejectDependencies";
    public static final ProvisionPolicyDirective ACCEPT_DEPENDENCIES = new ProvisionPolicyDirective("acceptDependencies");
    public static final ProvisionPolicyDirective REJECT_DEPENDENCIES;
    public static final ProvisionPolicyDirective DEFAULT;

    public static ProvisionPolicyDirective getInstance(String value) {
        if (VALUE_ACCEPT_DEPENDENCIES.equals(value)) {
            return ACCEPT_DEPENDENCIES;
        }
        if (VALUE_REJECT_DEPENDENCIES.equals(value)) {
            return REJECT_DEPENDENCIES;
        }
        return new ProvisionPolicyDirective(value);
    }

    public ProvisionPolicyDirective(String value) {
        super(NAME, value);
        if (!VALUE_ACCEPT_DEPENDENCIES.equals(value) && !VALUE_REJECT_DEPENDENCIES.equals(value)) {
            throw new IllegalArgumentException("Invalid provision-policy directive value: " + value);
        }
    }

    public String getProvisionPolicy() {
        return this.getValue();
    }

    public boolean isAcceptDependencies() {
        return this == ACCEPT_DEPENDENCIES || VALUE_ACCEPT_DEPENDENCIES.equals(this.getProvisionPolicy());
    }

    public boolean isRejectDependencies() {
        return this == REJECT_DEPENDENCIES || VALUE_REJECT_DEPENDENCIES.equals(this.getProvisionPolicy());
    }

    static {
        DEFAULT = REJECT_DEPENDENCIES = new ProvisionPolicyDirective(VALUE_REJECT_DEPENDENCIES);
    }
}

