/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.url;

import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.aries.jndi.services.ServiceHelper;
import org.apache.aries.jndi.url.AbstractServiceRegistryContext;
import org.apache.aries.jndi.url.OsgiName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistryListContext
extends AbstractServiceRegistryContext
implements Context {
    private OsgiName parentName;

    public ServiceRegistryListContext(BundleContext callerContext, Map<String, Object> env, OsgiName validName) {
        super(callerContext, env);
        this.parentName = validName;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        if (!"".equals(name)) {
            throw new NameNotFoundException(name);
        }
        ServiceReference[] refs = ServiceHelper.getServiceReferences(this.callerContext, this.parentName.getInterface(), this.parentName.getFilter(), this.parentName.getServiceName(), this.env);
        return new ServiceNamingEnumeration<NameClassPair>(this.callerContext, refs, new ThingManager<NameClassPair>(){

            @Override
            public NameClassPair get(BundleContext ctx, ServiceReference ref) {
                String serviceId = String.valueOf(ref.getProperty("service.id"));
                String className = null;
                Object service = ctx.getService(ref);
                if (service != null) {
                    className = service.getClass().getName();
                }
                ctx.ungetService(ref);
                return new NameClassPair(serviceId, className, true);
            }

            @Override
            public void release(BundleContext ctx, ServiceReference ref) {
            }
        });
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        if (!"".equals(name)) {
            throw new NameNotFoundException(name);
        }
        ServiceReference[] refs = ServiceHelper.getServiceReferences(this.callerContext, this.parentName.getInterface(), this.parentName.getFilter(), this.parentName.getServiceName(), this.env);
        return new ServiceNamingEnumeration<Binding>(this.callerContext, refs, new ThingManager<Binding>(){

            @Override
            public Binding get(BundleContext ctx, ServiceReference ref) {
                String serviceId = String.valueOf(ref.getProperty("service.id"));
                Object service = ServiceHelper.getService(ctx, ref);
                return new Binding(serviceId, service, true);
            }

            @Override
            public void release(BundleContext ctx, ServiceReference ref) {
                ctx.ungetService(ref);
            }
        });
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object result = null;
        result = ServiceHelper.getService(this.callerContext, this.parentName, name, false, this.env, true);
        if (result == null) {
            throw new NameNotFoundException(name.toString());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceNamingEnumeration<T>
    implements NamingEnumeration<T> {
        private BundleContext ctx;
        private ServiceReference[] refs;
        private int position = 0;
        private ThingManager<T> mgr;
        private T last;

        private ServiceNamingEnumeration(BundleContext context, ServiceReference[] theRefs, ThingManager<T> manager) {
            this.ctx = context;
            this.refs = theRefs != null ? theRefs : new ServiceReference[]{};
            this.mgr = manager;
        }

        @Override
        public void close() throws NamingException {
            this.mgr.release(this.ctx, this.refs[this.position - 1]);
            this.last = null;
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public T next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public boolean hasMoreElements() {
            return this.position < this.refs.length;
        }

        @Override
        public T nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            if (this.position > 0) {
                this.mgr.release(this.ctx, this.refs[this.position - 1]);
            }
            this.last = this.mgr.get(this.ctx, this.refs[this.position++]);
            return this.last;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ThingManager<T> {
        public T get(BundleContext var1, ServiceReference var2);

        public void release(BundleContext var1, ServiceReference var2);
    }
}

