/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.AbortException;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Messages;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.reader.ExtensionBindingChecker;
import com.sun.tools.xjc.reader.dtd.TDTDReader;
import com.sun.tools.xjc.reader.internalizer.DOMForest;
import com.sun.tools.xjc.reader.internalizer.DOMForestScanner;
import com.sun.tools.xjc.reader.internalizer.InternalizationLogic;
import com.sun.tools.xjc.reader.internalizer.SCDBasedBindingSet;
import com.sun.tools.xjc.reader.internalizer.VersionChecker;
import com.sun.tools.xjc.reader.relaxng.RELAXNGCompiler;
import com.sun.tools.xjc.reader.relaxng.RELAXNGInternalizationLogic;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.AnnotationParserFactoryImpl;
import com.sun.tools.xjc.reader.xmlschema.parser.CustomizationContextChecker;
import com.sun.tools.xjc.reader.xmlschema.parser.IncorrectNamespaceURIChecker;
import com.sun.tools.xjc.reader.xmlschema.parser.SchemaConstraintChecker;
import com.sun.tools.xjc.reader.xmlschema.parser.XMLSchemaInternalizationLogic;
import com.sun.tools.xjc.util.ErrorReceiverFilter;
import com.sun.xml.bind.v2.util.XmlFactory;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.parser.JAXPParser;
import com.sun.xml.xsom.parser.XMLParser;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.IOException;
import java.io.StringReader;
import org.kohsuke.rngom.ast.builder.SchemaBuilder;
import org.kohsuke.rngom.ast.util.CheckingSchemaBuilder;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.digested.DSchemaBuilderImpl;
import org.kohsuke.rngom.parse.IllegalSchemaException;
import org.kohsuke.rngom.parse.Parseable;
import org.kohsuke.rngom.parse.compact.CompactParseable;
import org.kohsuke.rngom.parse.xml.SAXParseable;
import org.kohsuke.rngom.xml.sax.XMLReaderCreator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public final class ModelLoader {
    private final Options opt;
    private final ErrorReceiverFilter errorReceiver;
    private final JCodeModel codeModel;
    private SCDBasedBindingSet scdBasedBindingSet;

    public static Model load(Options opt, JCodeModel codeModel, ErrorReceiver er) {
        return new ModelLoader(opt, codeModel, er).load();
    }

    public ModelLoader(Options _opt, JCodeModel _codeModel, ErrorReceiver er) {
        this.opt = _opt;
        this.codeModel = _codeModel;
        this.errorReceiver = new ErrorReceiverFilter(er);
    }

    private Model load() {
        if (!this.sanityCheck()) {
            return null;
        }
        try {
            Model grammar;
            switch (this.opt.getSchemaLanguage()) {
                case DTD: {
                    InputSource bindFile = null;
                    if (this.opt.getBindFiles().length > 0) {
                        bindFile = this.opt.getBindFiles()[0];
                    }
                    if (bindFile == null) {
                        bindFile = new InputSource(new StringReader("<?xml version='1.0'?><xml-java-binding-schema><options package='" + (this.opt.defaultPackage == null ? "generated" : this.opt.defaultPackage) + "'/></xml-java-binding-schema>"));
                    }
                    this.checkTooManySchemaErrors();
                    grammar = this.loadDTD(this.opt.getGrammars()[0], bindFile);
                    break;
                }
                case RELAXNG: {
                    this.checkTooManySchemaErrors();
                    grammar = this.loadRELAXNG();
                    break;
                }
                case RELAXNG_COMPACT: {
                    this.checkTooManySchemaErrors();
                    grammar = this.loadRELAXNGCompact();
                    break;
                }
                case WSDL: {
                    grammar = this.annotateXMLSchema(this.loadWSDL());
                    break;
                }
                case XMLSCHEMA: {
                    grammar = this.annotateXMLSchema(this.loadXMLSchema());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.errorReceiver.hadError()) {
                grammar = null;
            } else {
                grammar.setPackageLevelAnnotations(this.opt.packageLevelAnnotations);
            }
            return grammar;
        }
        catch (SAXException e) {
            if (this.opt.verbose) {
                if (e.getException() != null) {
                    e.getException().printStackTrace();
                } else {
                    e.printStackTrace();
                }
            }
            return null;
        }
        catch (AbortException e) {
            return null;
        }
    }

    private boolean sanityCheck() {
        if (this.opt.getSchemaLanguage() == Language.XMLSCHEMA) {
            Language guess = this.opt.guessSchemaLanguage();
            String[] msg = null;
            switch (guess) {
                case DTD: {
                    msg = new String[]{"DTD", "-dtd"};
                    break;
                }
                case RELAXNG: {
                    msg = new String[]{"RELAX NG", "-relaxng"};
                    break;
                }
                case RELAXNG_COMPACT: {
                    msg = new String[]{"RELAX NG compact syntax", "-relaxng-compact"};
                    break;
                }
                case WSDL: {
                    msg = new String[]{"WSDL", "-wsdl"};
                }
            }
            if (msg != null) {
                this.errorReceiver.warning(null, Messages.format("Driver.ExperimentalLanguageWarning", msg[0], msg[1]));
            }
        }
        return true;
    }

    private void checkTooManySchemaErrors() {
        if (this.opt.getGrammars().length != 1) {
            this.errorReceiver.error(null, Messages.format("ModelLoader.TooManySchema", new Object[0]));
        }
    }

    private Model loadDTD(InputSource source, InputSource bindFile) {
        return TDTDReader.parse(source, bindFile, this.errorReceiver, this.opt);
    }

    public DOMForest buildDOMForest(InternalizationLogic logic) throws SAXException {
        DOMForest forest = new DOMForest(logic, this.opt);
        forest.setErrorHandler(this.errorReceiver);
        if (this.opt.entityResolver != null) {
            forest.setEntityResolver(this.opt.entityResolver);
        }
        for (InputSource value : this.opt.getGrammars()) {
            this.errorReceiver.pollAbort();
            forest.parse(value, true);
        }
        for (InputSource value : this.opt.getBindFiles()) {
            Element root;
            this.errorReceiver.pollAbort();
            Document dom = forest.parse(value, true);
            if (dom == null || this.fixNull((root = dom.getDocumentElement()).getNamespaceURI()).equals("http://java.sun.com/xml/ns/jaxb") && root.getLocalName().equals("bindings")) continue;
            this.errorReceiver.error(new SAXParseException(Messages.format("Driver.NotABindingFile", root.getNamespaceURI(), root.getLocalName()), null, value.getSystemId(), -1, -1));
        }
        this.scdBasedBindingSet = forest.transform(this.opt.isExtensionMode());
        return forest;
    }

    private String fixNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public XSSchemaSet loadXMLSchema() throws SAXException {
        if (this.opt.strictCheck && !SchemaConstraintChecker.check(this.opt.getGrammars(), this.errorReceiver, this.opt.entityResolver, this.opt.disableXmlSecurity)) {
            return null;
        }
        if (this.opt.getBindFiles().length == 0) {
            try {
                return this.createXSOMSpeculative();
            }
            catch (SpeculationFailure e) {
                // empty catch block
            }
        }
        DOMForest forest = this.buildDOMForest(new XMLSchemaInternalizationLogic());
        return this.createXSOM(forest, this.scdBasedBindingSet);
    }

    private XSSchemaSet loadWSDL() throws SAXException {
        DOMForest forest = this.buildDOMForest(new XMLSchemaInternalizationLogic());
        DOMForestScanner scanner = new DOMForestScanner(forest);
        XSOMParser xsomParser = this.createXSOMParser(forest);
        for (InputSource grammar : this.opt.getGrammars()) {
            String systemId;
            Document wsdlDom = forest.get(grammar.getSystemId());
            if (wsdlDom == null && forest.get(systemId = Options.normalizeSystemId(grammar.getSystemId())) != null) {
                grammar.setSystemId(systemId);
                wsdlDom = forest.get(grammar.getSystemId());
            }
            NodeList schemas = wsdlDom.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int i = 0; i < schemas.getLength(); ++i) {
                scanner.scan((Element)schemas.item(i), xsomParser.getParserHandler());
            }
        }
        return xsomParser.getResult();
    }

    public Model annotateXMLSchema(XSSchemaSet xs) {
        if (xs == null) {
            return null;
        }
        return BGMBuilder.build(xs, this.codeModel, this.errorReceiver, this.opt);
    }

    public XSOMParser createXSOMParser(XMLParser parser) {
        XSOMParser reader = new XSOMParser(new XMLSchemaParser(parser));
        reader.setAnnotationParser(new AnnotationParserFactoryImpl(this.opt));
        reader.setErrorHandler(this.errorReceiver);
        reader.setEntityResolver(this.opt.entityResolver);
        return reader;
    }

    public XSOMParser createXSOMParser(final DOMForest forest) {
        XSOMParser p = this.createXSOMParser(forest.createParser());
        p.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId != null && forest.get(systemId) != null) {
                    return new InputSource(systemId);
                }
                if (((ModelLoader)ModelLoader.this).opt.entityResolver != null) {
                    return ((ModelLoader)ModelLoader.this).opt.entityResolver.resolveEntity(publicId, systemId);
                }
                return null;
            }
        });
        return p;
    }

    private XSSchemaSet createXSOMSpeculative() throws SAXException, SpeculationFailure {
        XMLParser parser = new XMLParser(){
            private final JAXPParser base;
            {
                this.base = new JAXPParser(XmlFactory.createParserFactory((boolean)((ModelLoader)ModelLoader.this).opt.disableXmlSecurity));
            }

            @Override
            public void parse(InputSource source, ContentHandler handler, ErrorHandler errorHandler, EntityResolver entityResolver) throws SAXException, IOException {
                handler = this.wrapBy(new SpeculationChecker(), handler);
                handler = this.wrapBy(new VersionChecker(null, ModelLoader.this.errorReceiver, entityResolver), handler);
                this.base.parse(source, handler, errorHandler, entityResolver);
            }

            private ContentHandler wrapBy(XMLFilterImpl filter, ContentHandler handler) {
                filter.setContentHandler(handler);
                return filter;
            }
        };
        XSOMParser reader = this.createXSOMParser(parser);
        for (InputSource value : this.opt.getGrammars()) {
            reader.parse(value);
        }
        return reader.getResult();
    }

    public XSSchemaSet createXSOM(DOMForest forest, SCDBasedBindingSet scdBasedBindingSet) throws SAXException {
        XSOMParser reader = this.createXSOMParser(forest);
        for (String systemId : forest.getRootDocuments()) {
            this.errorReceiver.pollAbort();
            Document dom = forest.get(systemId);
            if (dom.getDocumentElement().getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxb")) continue;
            reader.parse(systemId);
        }
        XSSchemaSet result = reader.getResult();
        if (result != null) {
            scdBasedBindingSet.apply(result, this.errorReceiver);
        }
        return result;
    }

    private Model loadRELAXNG() throws SAXException {
        final DOMForest forest = this.buildDOMForest(new RELAXNGInternalizationLogic());
        XMLReaderCreator xrc = new XMLReaderCreator(){

            @Override
            public XMLReader createXMLReader() {
                XMLFilterImpl buffer = new XMLFilterImpl(){

                    @Override
                    public void parse(InputSource source) throws IOException, SAXException {
                        forest.createParser().parse(source, this, this, this);
                    }
                };
                ExtensionBindingChecker f = new ExtensionBindingChecker("http://relaxng.org/ns/structure/1.0", ModelLoader.this.opt, ModelLoader.this.errorReceiver);
                f.setParent(buffer);
                f.setEntityResolver(((ModelLoader)ModelLoader.this).opt.entityResolver);
                return f;
            }
        };
        SAXParseable p = new SAXParseable(this.opt.getGrammars()[0], this.errorReceiver, xrc);
        return this.loadRELAXNG(p);
    }

    private Model loadRELAXNGCompact() {
        if (this.opt.getBindFiles().length > 0) {
            this.errorReceiver.error(new SAXParseException(Messages.format("ModelLoader.BindingFileNotSupportedForRNC", new Object[0]), null));
        }
        CompactParseable p = new CompactParseable(this.opt.getGrammars()[0], this.errorReceiver);
        return this.loadRELAXNG(p);
    }

    private Model loadRELAXNG(Parseable p) {
        CheckingSchemaBuilder sb = new CheckingSchemaBuilder((SchemaBuilder)new DSchemaBuilderImpl(), this.errorReceiver);
        try {
            DPattern out = (DPattern)p.parse(sb);
            return RELAXNGCompiler.build(out, this.codeModel, this.opt);
        }
        catch (IllegalSchemaException e) {
            this.errorReceiver.error(e.getMessage(), e);
            return null;
        }
    }

    private static final class SpeculationChecker
    extends XMLFilterImpl {
        private SpeculationChecker() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("bindings") && uri.equals("http://java.sun.com/xml/ns/jaxb")) {
                throw new SpeculationFailure();
            }
            super.startElement(uri, localName, qName, attributes);
        }
    }

    private static final class SpeculationFailure
    extends Error {
        private SpeculationFailure() {
        }
    }

    private class XMLSchemaParser
    implements XMLParser {
        private final XMLParser baseParser;

        private XMLSchemaParser(XMLParser baseParser) {
            this.baseParser = baseParser;
        }

        @Override
        public void parse(InputSource source, ContentHandler handler, ErrorHandler errorHandler, EntityResolver entityResolver) throws SAXException, IOException {
            handler = this.wrapBy(new ExtensionBindingChecker("http://www.w3.org/2001/XMLSchema", ModelLoader.this.opt, ModelLoader.this.errorReceiver), handler);
            handler = this.wrapBy(new IncorrectNamespaceURIChecker(ModelLoader.this.errorReceiver), handler);
            handler = this.wrapBy(new CustomizationContextChecker(ModelLoader.this.errorReceiver), handler);
            this.baseParser.parse(source, handler, errorHandler, entityResolver);
        }

        private ContentHandler wrapBy(XMLFilterImpl filter, ContentHandler handler) {
            filter.setContentHandler(handler);
            return filter;
        }
    }
}

