/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.amqp.AmqpNioSslTransport;
import org.apache.activemq.transport.amqp.AmqpNioTransportFactory;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.transport.tcp.TcpTransportFactory;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.wireformat.WireFormat;

public class AmqpNioSslTransportFactory
extends AmqpNioTransportFactory {
    protected SSLContext context;

    @Override
    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer((TcpTransportFactory)this, location, serverSocketFactory){

            protected Transport createTransport(Socket socket, WireFormat format) throws IOException {
                AmqpNioSslTransport transport = new AmqpNioSslTransport(format, socket);
                if (AmqpNioSslTransportFactory.this.context != null) {
                    transport.setSslContext(AmqpNioSslTransportFactory.this.context);
                }
                return transport;
            }

            public boolean isSslServer() {
                return true;
            }
        };
    }

    @Override
    protected TcpTransport createTcpTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new AmqpNioSslTransport(wf, socketFactory, location, localLocation);
    }

    public TcpTransport createTransport(WireFormat wireFormat, Socket socket, SSLEngine engine, TcpTransport.InitBuffer initBuffer, ByteBuffer inputBuffer) throws IOException {
        return new AmqpNioSslTransport(wireFormat, socket, engine, initBuffer, inputBuffer);
    }

    public TransportServer doBind(URI location) throws IOException {
        if (SslContext.getCurrentSslContext() != null) {
            try {
                this.context = SslContext.getCurrentSslContext().getSSLContext();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return super.doBind(location);
    }
}

