/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.thread.SchedulerTimerTask;
import org.apache.activemq.transport.AbstractInactivityMonitor;
import org.apache.activemq.transport.InactivityIOException;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.amqp.AmqpTransport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpInactivityMonitor
extends TransportFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpInactivityMonitor.class);
    private static ThreadPoolExecutor ASYNC_TASKS;
    private static int CONNECTION_CHECK_TASK_COUNTER;
    private static Timer CONNECTION_CHECK_TASK_TIMER;
    private static int KEEPALIVE_TASK_COUNTER;
    private static Timer KEEPALIVE_TASK_TIMER;
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private AmqpTransport amqpTransport;
    private long connectionTimeout = 30000L;
    private SchedulerTimerTask connectCheckerTask;
    private final Runnable connectChecker = new Runnable(){
        private final long startTime = System.currentTimeMillis();

        @Override
        public void run() {
            block3: {
                long now = System.currentTimeMillis();
                if (now - this.startTime >= AmqpInactivityMonitor.this.connectionTimeout && AmqpInactivityMonitor.this.connectCheckerTask != null && !ASYNC_TASKS.isShutdown()) {
                    LOG.debug("No connection attempt made in time for {}! Throwing InactivityIOException.", (Object)AmqpInactivityMonitor.this.toString());
                    try {
                        ASYNC_TASKS.execute(new Runnable(){

                            @Override
                            public void run() {
                                AmqpInactivityMonitor.this.onException((IOException)new InactivityIOException("Channel was inactive for too (>" + AmqpInactivityMonitor.this.connectionTimeout + ") long: " + AmqpInactivityMonitor.this.next.getRemoteAddress()));
                            }
                        });
                    }
                    catch (RejectedExecutionException ex) {
                        if (ASYNC_TASKS.isShutdown()) break block3;
                        LOG.error("Async connection timeout task was rejected from the executor: ", (Throwable)ex);
                        throw ex;
                    }
                }
            }
        }
    };
    private SchedulerTimerTask keepAliveTask;
    private final Runnable keepAlive = new Runnable(){

        @Override
        public void run() {
            block3: {
                if (AmqpInactivityMonitor.this.keepAliveTask != null && !ASYNC_TASKS.isShutdown()) {
                    try {
                        ASYNC_TASKS.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                block6: {
                                    try {
                                        long nextIdleUpdate = AmqpInactivityMonitor.this.amqpTransport.keepAlive();
                                        if (nextIdleUpdate <= 0L) break block6;
                                        AmqpInactivityMonitor amqpInactivityMonitor = AmqpInactivityMonitor.this;
                                        synchronized (amqpInactivityMonitor) {
                                            if (AmqpInactivityMonitor.this.keepAliveTask != null) {
                                                AmqpInactivityMonitor.this.keepAliveTask = new SchedulerTimerTask(AmqpInactivityMonitor.this.keepAlive);
                                                KEEPALIVE_TASK_TIMER.schedule((TimerTask)AmqpInactivityMonitor.this.keepAliveTask, nextIdleUpdate);
                                            }
                                        }
                                    }
                                    catch (Exception ex) {
                                        AmqpInactivityMonitor.this.onException((IOException)new InactivityIOException("Exception while performing idle checks for connection: " + AmqpInactivityMonitor.this.next.getRemoteAddress()));
                                    }
                                }
                            }
                        });
                    }
                    catch (RejectedExecutionException ex) {
                        if (ASYNC_TASKS.isShutdown()) break block3;
                        LOG.error("Async connection timeout task was rejected from the executor: ", (Throwable)ex);
                        throw ex;
                    }
                }
            }
        }
    };
    private final ThreadFactory factory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "AmqpInactivityMonitor Async Task: " + String.valueOf(runnable));
            thread.setDaemon(true);
            return thread;
        }
    };

    public AmqpInactivityMonitor(Transport next, WireFormat wireFormat) {
        super(next);
    }

    public void start() throws Exception {
        this.next.start();
    }

    public void stop() throws Exception {
        this.stopConnectionTimeoutChecker();
        this.stopKeepAliveTask();
        this.next.stop();
    }

    public void onException(IOException error) {
        if (this.failed.compareAndSet(false, true)) {
            this.stopConnectionTimeoutChecker();
            if (this.amqpTransport != null) {
                this.amqpTransport.onException(error);
            }
            this.transportListener.onException(error);
        }
    }

    public void setAmqpTransport(AmqpTransport amqpTransport) {
        this.amqpTransport = amqpTransport;
    }

    public AmqpTransport getAmqpTransport() {
        return this.amqpTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void startConnectionTimeoutChecker(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        if (connectionTimeout <= 0L || this.connectCheckerTask != null) return;
        this.connectCheckerTask = new SchedulerTimerTask(this.connectChecker);
        long connectionCheckInterval = Math.min(connectionTimeout, 1000L);
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            if (CONNECTION_CHECK_TASK_COUNTER == 0) {
                if (ASYNC_TASKS == null || ASYNC_TASKS.isShutdown()) {
                    ASYNC_TASKS = this.createExecutor();
                }
                CONNECTION_CHECK_TASK_TIMER = new Timer("AMQP InactivityMonitor State Check", true);
            }
            ++CONNECTION_CHECK_TASK_COUNTER;
            CONNECTION_CHECK_TASK_TIMER.schedule((TimerTask)this.connectCheckerTask, connectionCheckInterval, connectionCheckInterval);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void startKeepAliveTask(long nextKeepAliveCheck) {
        if (nextKeepAliveCheck <= 0L || this.keepAliveTask != null) return;
        this.keepAliveTask = new SchedulerTimerTask(this.keepAlive);
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            if (KEEPALIVE_TASK_COUNTER == 0) {
                if (ASYNC_TASKS == null || ASYNC_TASKS.isShutdown()) {
                    ASYNC_TASKS = this.createExecutor();
                }
                KEEPALIVE_TASK_TIMER = new Timer("AMQP InactivityMonitor Idle Update", true);
            }
            ++KEEPALIVE_TASK_COUNTER;
            KEEPALIVE_TASK_TIMER.schedule((TimerTask)this.keepAliveTask, nextKeepAliveCheck);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void stopConnectionTimeoutChecker() {
        if (this.connectCheckerTask == null) return;
        this.connectCheckerTask.cancel();
        this.connectCheckerTask = null;
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            CONNECTION_CHECK_TASK_TIMER.purge();
            if (--CONNECTION_CHECK_TASK_COUNTER != 0) return;
            CONNECTION_CHECK_TASK_TIMER.cancel();
            CONNECTION_CHECK_TASK_TIMER = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void stopKeepAliveTask() {
        if (this.keepAliveTask == null) return;
        this.keepAliveTask.cancel();
        this.keepAliveTask = null;
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            KEEPALIVE_TASK_TIMER.purge();
            if (--KEEPALIVE_TASK_COUNTER != 0) return;
            KEEPALIVE_TASK_TIMER.cancel();
            KEEPALIVE_TASK_TIMER = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ThreadPoolExecutor createExecutor() {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 90L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.factory);
        exec.allowCoreThreadTimeOut(true);
        return exec;
    }
}

