/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.generator;

import java.beans.PropertyEditorManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.xbean.spring.generator.DocumentationGenerator;
import org.apache.xbean.spring.generator.GeneratorPlugin;
import org.apache.xbean.spring.generator.LogFacade;
import org.apache.xbean.spring.generator.NamespaceMapping;
import org.apache.xbean.spring.generator.QdoxMappingLoader;
import org.apache.xbean.spring.generator.XmlMetadataGenerator;
import org.apache.xbean.spring.generator.XsdGenerator;

public class MappingGeneratorTask
extends MatchingTask
implements LogFacade {
    private String namespace;
    private Path srcDir;
    private String excludedClasses = null;
    private File destFile = new File("target/classes/schema.xsd");
    private String metaInfDir = "target/classes/";
    private String propertyEditorPaths = "org.apache.xbean.spring.context.impl";
    private boolean strictXsdOrder = true;

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public String getMetaInfDir() {
        return this.metaInfDir;
    }

    public void setMetaInfDir(String metaInfDir) {
        this.metaInfDir = metaInfDir;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Path getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(Path srcDir) {
        this.srcDir = srcDir;
    }

    public String getPropertyEditorPaths() {
        return this.propertyEditorPaths;
    }

    public void setPropertyEditorPaths(String propertyEditorPaths) {
        this.propertyEditorPaths = propertyEditorPaths;
    }

    public boolean isStrictXsdOrder() {
        return this.strictXsdOrder;
    }

    public void setStrictXsdOrder(boolean strictXsdOrder) {
        this.strictXsdOrder = strictXsdOrder;
    }

    public void execute() throws BuildException {
        if (this.namespace == null) {
            throw new BuildException("'namespace' must be specified");
        }
        if (this.srcDir == null) {
            throw new BuildException("'srcDir' must be specified");
        }
        if (this.destFile == null) {
            throw new BuildException("'destFile' must be specified");
        }
        if (this.propertyEditorPaths != null) {
            LinkedList<String> editorSearchPath = new LinkedList<String>(Arrays.asList(PropertyEditorManager.getEditorSearchPath()));
            StringTokenizer paths = new StringTokenizer(this.propertyEditorPaths, " ,");
            editorSearchPath.addAll(Collections.list(paths));
            PropertyEditorManager.setEditorSearchPath(editorSearchPath.toArray(new String[editorSearchPath.size()]));
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            String[] excludedClasses = null;
            if (this.excludedClasses != null) {
                excludedClasses = this.excludedClasses.split(" *, *");
            }
            QdoxMappingLoader mappingLoader = new QdoxMappingLoader(this.namespace, this.getFiles(this.srcDir), excludedClasses);
            GeneratorPlugin[] plugins = new GeneratorPlugin[]{new XmlMetadataGenerator(this.metaInfDir, this.destFile), new DocumentationGenerator(this.destFile), new XsdGenerator(this.destFile, this.strictXsdOrder)};
            Set<NamespaceMapping> namespaces = mappingLoader.loadNamespaces();
            if (namespaces.isEmpty()) {
                System.out.println("Warning: no namespaces found!");
            }
            for (NamespaceMapping namespaceMapping : namespaces) {
                for (int i = 0; i < plugins.length; ++i) {
                    GeneratorPlugin plugin = plugins[i];
                    plugin.setLog(this);
                    plugin.generate(namespaceMapping);
                }
            }
            this.log("...done.");
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    private File[] getFiles(Path path) {
        if (path == null) {
            return null;
        }
        String[] paths = path.list();
        File[] files = new File[paths.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(paths[i]).getAbsoluteFile();
        }
        return files;
    }
}

