/**/


call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs




parse arg language texmf source options





packages = 8


ins.1 = "a4.ins"
ins.2 = "dinbrief.ins"
ins.3 = "float.ins"
ins.4 = "subfigure.ins"
ins.5 = "supertabular.ins"
ins.6 = "subeqnarray.ins"
ins.7 = ""
ins.8 = "rotating.ins"

doc.1 = "a4.dtx"
doc.2 = "dinbrief.drv"
doc.3 = "float.dtx"
doc.4 = "subfigure.dtx"
doc.5 = "supertabular.dtx"
doc.6 = "subeqnarray.dtx"
doc.7 = ""
doc.8 = "examples.tex"

dvi.1 = "a4.dvi"
dvi.2 = "dinbrief.dvi"
dvi.3 = "float.dvi"
dvi.4 = "subfigure.dvi"
dvi.5 = "supertabular.dvi"
dvi.6 = "subeqnarray.dvi"
dvi.7 = "fancyhdr.dvi"
dvi.8 = "examples.dvi"

dir.1 = "a4"
dir.2 = "dinbrief"
dir.3 = "float"
dir.4 = "subfigure"
dir.5 = "supertabular"
dir.6 = "subeqnarray"
dir.7 = "fancyhdr"
dir.8 = "rotating"

tit.1 = "a4 [NTG]"
tit.2 = "dinbrief [K.D. Braune]"
tit.3 = "float [A. Lingnau]"
tit.4 = "subfigure [FSF]"
tit.5 = "supertabular [J. Braams]"
tit.6 = "subeqnarray [J. Braams]"
tit.7 = "fancyhdr []"
tit.8 = "rotating [S. Rahtz]"

say "msg:LaTeX2e supported:"


install = texmf"\os2tex\install"



do i = 1 to packages
  obj.i = "<OS2TeX_supported_"dir.i".dvi>"
end



if "" = directory(texmf"\tex\latex") then do
  say "err:Verzeichniswechsel nicht mglich"
  exit 1
end



if Pos("InstallFiles", options) > 0 then do


/* delete target directories */

   do i = 1 to packages
      install"\kdir "dir.i
   end





/* unzip packages */



   say "msg:LaTeX2e supported: unpacking support.zip"



   install"\unzip -o "source"\support.zip"

   call directory texmf


/* delete and create documentation directories */


   do i = 1 to packages
      install"\kdir "texmf"\doc\latex\"dir.i
      "md "texmf"\doc\latex\"dir.i
   end


/* unpack *.ins files via LaTeXs docstrip utility */


   do i = 1 to packages
      if ins.i \= "" then do

         say "msg:LaTeX2e supported: "ins.i

         texmf"\os2tex\bin\tex.exe -r -ff latex.fmt -pf "texmf"\os2tex\bin -po "texmf"\tex\latex\"dir.i" -pi "texmf"\tex\latex\"dir.i";"texmf"\tex "ins.i" -a "source"\support.ans"

      end
   end


/* create documentation (dvi files) */


   do i = 1 to packages

      if doc.i \= "" then do

         do j = 1 to 3

            say "msg:LaTeX2e supported: "dir.i".dvi pass "j" of 3"

            texmf"\os2tex\bin\tex.exe -r -ff latex.fmt -pt "texmf"\fonts\tfm -pf "texmf"\os2tex\bin -po "texmf"\doc\latex\"dir.i" -pi "texmf"\doc\latex\"dir.i";"texmf"\tex\latex\"dir.i";"texmf"\tex "doc.i

         end

      end
      else do

         "copy "texmf"\tex\latex\"dir.i"\"dir.i".dvi "texmf"\doc\latex\"dir.i
         "del "texmf"\tex\latex\"dir.i"\"dir.i".dvi"

      end

   end

end



/* create WPS objects */



if Pos("CreateObjects", options) > 0 then do

   say "msg:LaTeX2e supported: creating WPS objects"


   do i = 1 to packages

      classname = 'WPProgram'
      objtitle  = tit.i

      location  = '<OS2TEX_MISC_FOLDER>'
      setup     = 'EXENAME='texmf'\os2tex\bin\dvi.exe;PROGTYPE=PM;STARTUPDIR='texmf'\os2tex\bin;OBJECTID='obj.i';PARAMETERS='texmf'\doc\latex\'dir.i"\"dvi.i
      duplicate = 'replace'

      rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   end

end



/* copy rotating documentation */


if Pos("InstallFiles", options) > 0 then do


   "copy "texmf"\tex\latex\rotating\cat.eps "texmf"\doc\latex\rotating"
   "copy "texmf"\tex\latex\rotating\example* "texmf"\doc\latex\rotating"

   "del "texmf"\tex\latex\rotating\cat.eps"
   "del "texmf"\tex\latex\rotating\example*"


/* clean up files */



   say "msg:LaTeX2e supported: clean up files"


   do i = 1 to packages

      "del "texmf"\tex\latex\"dir.i"\*.ins"
      "del "texmf"\tex\latex\"dir.i"\*.dtx"

   end

end


