The __SyncTeX parser__ library.
===============================

Since 2008, the Synchronization TeXnology named __SyncTeX__ is a feature
of TeX engines.
It allows to synchronize between input and output, which means to
navigate from the source document to the typeset material and vice versa. Here is how it works: during the typesetting process of `foo.tex`, the TeX engines writes some geometrical information in an auxiliary file named `foo.synctex`, this information is then used by editors or viewers to navigate between input and output.

Package contents
----------------
This package contains a __SyncTeX parser__ library in C to help developers to embed in their viewer or editor the navigation feature between source and output. It consists in

* `synctex_parser.c`
* `synctex_parser.h`
* `synctex_parser_advanced.h`
* `synctex_parser_c-auto.h`
* `synctex_parser_local.h`
* `synctex_parser_readme.md`
* `synctex_parser_readme.txt`
* `synctex_parser_utils.c`
* `synctex_parser_utils.h`
* `synctex_parser_version.txt`


The header file `synctex_parser.h` contains detailed usage explanations.

Versions:
---------
The version of the `.synctex` file format is actually  1. The version of the __SyncTeX parser__ library or the __SyncTeX__ tool are in `synctex_parser_version.txt` (1.21 as of Oct 2017). The very latest stable sources are always available from the TeXLive svn repository.

More details
------------
This technology is threefold:

1) the specifications of the `.synctex` auxiliary files is available as a man page:
`man 5 synctex`

2) the code for writing down the `.synctex` auxiliary file, as part of a TeX engine, is available from TeXLive source repository at

`https://tug.org/svn/texlive/trunk/Build/source/texk/web2c/synctexdir/`

It contains code for various TeX engines including pdfTeX and XeTeX. However, this folder may not contain the whole LuaTeX related code.

3) the C library in this package.

There is a CLI tool simply named `synctex`, available in TeXLive distributions, that implements the navigation using this library. See the man page or `synctex --help` for usage explanations.

Problems and bug reports.
-------------------------
Problems at the TeX engine level should be reported to the TeX development team. Problems concerning the __SyncTeX parser__ library should be reported on the GitHub project page:

`https://github.com/jlaurens/synctex`

Acknowledgments:
----------------
__SyncTeX__ was designed by Jérôme Laurens. From the very beginning, he received useful
remarks from pdfTeX developers, XeTeX developers and other members of the TeX community. Viewers or editors developers have contributed to the __SyncTeX parser__ library.  

Nota Bene:
----------
If you include or use a significant part of the synctex package into a software,
I would appreciate to be listed as contributor and see "__SyncTeX__" highlighted.

Copyright (c) 2017 jerome DOT laurens AT u-bourgogne DOT fr
