/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/


/* re_edit.c editing bibliographic records: write data into text file,
 * transfer from text file into database */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "refs.h"
#include "expo_fun.h"
#include "ix01_fun.h"
#include "ix02_fun.h"
#include "ix03_fun.h"
#include "ix04_fun.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "initial.h"
#include "interf.h"
#include "re_edit.h"
#include "transf.h"

#define MAXARR 32000

#define TMP01_IX     "tmp01.ix"
#define DEST01_IX    "dest01.ix"
#define TMP04_IX     "tmp04.ix"
#define DEST04_IX    "dest04.ix"


 extern char journal_pix_name[PFAD_LEN+1];
 extern char desc_name[PFAD_LEN+1];
 extern char journal_name[PFAD_LEN+1];
 extern char book_name[PFAD_LEN+1];
 extern char autorjl_name[PFAD_LEN+1];
 extern char autorbu_name[PFAD_LEN+1];
 extern char quell_pix_name[PFAD_LEN+1];
 extern char quell_name[PFAD_LEN+1];
 extern char stichw_name[PFAD_LEN+1];
 extern char stichw_pix_name[PFAD_LEN+1];
 extern char abstr_pix_name[PFAD_LEN+1];
 extern char abstr_dat_name[PFAD_LEN+1];
 extern char log_name[PFAD_LEN+1];
 extern char tempt_name[PFAD_LEN+1];
 
 static char tmp01_ix_name[PFAD_LEN+1]; /* temporary ix01 file */
 static char dest01_ix_name[PFAD_LEN+1]; /* temporary ix01 file */
 static char tmp04_ix_name[PFAD_LEN+1]; /* temporary ix04 file */
 static char dest04_ix_name[PFAD_LEN+1]; /* temporary ix04 file */
 
 static char txt_name[PFAD_LEN + 1]; /* name of text file to be read */

 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];

#define ID_ZEILE_LEN  FORM_LABEL_LEN + SCREENLINE_LEN
 static char id_zeile[ID_ZEILE_LEN + 1];
 
 static char * ex_zeile;
 static char * in_zeile;
 static char * abs_zeile;

 extern FILE * ix01file;
 extern FILE * ix02file;
 extern FILE * ix03file;
 extern FILE * ix04file;

 extern FILE * fpjournal;
 extern FILE * fpdesc;
 extern FILE * fpbuch;
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;
 extern FILE * fpquell;
 extern FILE * fpstichw;
 extern FILE * fpabs;

 static FILE * fptxt;
 extern config_set one_config_set;

 extern journal_rec one_journal_rec;
 extern author_rec one_aued_rec;
 extern desc_rec one_desc_rec;
 extern buch_rec one_buch_rec;
 extern quell_rec one_quell_rec;
 static keylist_rec one_key_rec;
 extern abstr_rec one_abstr_rec;
 extern refspix_rec ix01rec;
 extern quellpix_rec ix02rec;
 extern keylistpix_rec ix03rec;
 extern abstrpix_rec ix04rec;
 
 extern char wrtxtbu[WRTXTBU_LEN+1];

 static author_rec * autorenliste;
 static author_rec * editorenliste; 
 static desc_rec * descliste; /* array with keywords */
 static abstr_rec * abstractliste; /* array containing the complete abstract in
                                      MAX_BLOECKE elements  */
 
 static int select_document_type(void);
 static int textdatei_oeffnen(void);
 static int variablen_initialisieren(void);
 static int lies_j1(char * dtyp);
 static int lies_j2(char * dtyp);
 static int lies_b1(char * dtyp);
 static int lies_b2(char * dtyp);
 static int lies_b3(char * dtyp);
 static int lies_m1(char * dtyp);
 static int lies_m2(char * dtyp);
 static int split_abstract(char * abstract);
 static int merge_abstract(char * abs_zeile, abstr_rec * abstractliste);
 static int dokumenttyp_pruefen(char * kennziff, char * dokumenttyp);
 static int aued_eintragen(char * ze, author_rec * one_rec);
 static int desc_eintragen(char * ze, desc_rec * one_rec);
 static int j1_zeigen(void);
 static int j2_zeigen(void);
 static int b1_zeigen(void);
 static int b2_zeigen(void);
 static int b3_zeigen(void);
 static int m1_zeigen(void);
 static int m2_zeigen(void);
 static int j1m1_speichern(char * dtyp);
 static int j2m2_speichern(char * dtyp);
 static int b1_speichern(void);
 static int b2_speichern(void);
 static int b3_speichern(void);
 static void auedstring_schreiben(
            const char * au_datei_name,
            long * aued_rptr,
            author_rec liste[]
                          );

 static void descstring_schreiben(
             const char * desc_datei_name,
             long * desc_rptr
                            );
 static void buch_rec_schreiben(long * bu_rptr);
 static int journal_rec_und_index_schreiben(void);
 static int abstract_und_index_schreiben(char * kennziffer);

 
int re_edit_main(char * code)
{
   /* Initializations */
   if ((autorenliste = (author_rec *) malloc(MAX_N_AUTHORS * sizeof(author_rec))) == NULL)
   {
       fprintf(stderr,"\nError: cannot allocate memory for list of authors\n");
       exit(1);
   }
   if ((editorenliste = (author_rec *) malloc(MAX_N_AUTHORS * sizeof(author_rec))) == NULL)
   {
       fprintf(stderr,"\nError: cannot allocate memory for list of editors\n");
       exit(1);
   }
   if ((descliste = (desc_rec *) malloc(MAX_N_DESC * sizeof(desc_rec))) == NULL)
   {
       fprintf(stderr,"\nError: cannot allocate memory for list of keywords\n");
       exit(1);
   }
   if ((abstractliste = (abstr_rec *) malloc(MAX_BLOECKE * sizeof(abstr_rec))) == NULL)
   {
       fprintf(stderr,"\nError: cannot allocate memory for abstract-array\n");
       exit(1);
   }
   if ((ex_zeile = (char *) malloc((MAXARR+1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nError: cannot allocate memory for "
               "string (ex_zeile in re_edit.c)\n");
       exit(1);
   }
   if ((in_zeile = (char *) malloc((MAXARR+1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nError: cannot allocate memory for "
               "string (in_zeile in re_edit.c)\n");
       exit(1);
   }
   if ((abs_zeile = (char *) malloc((ABSTRACT_ZEILE_LEN+1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nError: cannot allocate memory for "
               "string (abs_zeile in re_edit.c)\n");
       exit(1);
   }
   
   strlimcpy(txt_name,textpfad,PFAD_LEN);
   strlimcat(txt_name,one_config_set.form_name,PFAD_LEN);
   

   strlimcpy(tmp01_ix_name,rdbpfad,PFAD_LEN);
   strlimcat(tmp01_ix_name,TMP01_IX,PFAD_LEN);
   
   strlimcpy(dest01_ix_name,rdbpfad,PFAD_LEN);
   strlimcat(dest01_ix_name,DEST01_IX,PFAD_LEN);
   
   strlimcpy(tmp04_ix_name,rdbpfad,PFAD_LEN);
   strlimcat(tmp04_ix_name,TMP04_IX,PFAD_LEN);

   strlimcpy(dest04_ix_name,rdbpfad,PFAD_LEN);
   strlimcat(dest04_ix_name,DEST04_IX,PFAD_LEN);
   

   /*  
    *  Datenbank-Variablen initialisieren (eigene
    *  Funktion schreiben) 
    */
   variablen_initialisieren();
   /* ... */
   if (strcmp(code,"reference")==0)
   {
      select_document_type();
   }
   /* ... */
   
   free(autorenliste);
   free(editorenliste);
   free(abstractliste);
   free(descliste);
   free(ex_zeile);
   free(in_zeile);
   free(abs_zeile);
   return 1; 
}


int refnr_bereits_vorhanden(char * refnr)
{
   refspix_rec ix01rec_lokal; 
   long ix01zeiger;
   int ok;
   /* Begin new in v4.1 */
   read_ix01(journal_pix_name);
   fseek(ix01file,0L,SEEK_END);
   if (ftell(ix01file)/sizeof(refspix_rec) >= 1)
   {
     fseek(ix01file,-(long) sizeof(refspix_rec),SEEK_END);
     fread(&ix01rec_lokal,sizeof(refspix_rec),1,ix01file);
     sprintf(wrtxtbu,"New reference number "
       "(preferrably higher than %s)",
       ix01rec_lokal.kennziffer);
   } 
   else
   {
     sprintf(wrtxtbu,"New reference number");
   }
   close_ix01();
   /* End new in v4.1 */
   do
   {
     ein_zeile(refnr,wrtxtbu,KENNZIFFER_LEN);
     if (strlen(refnr)==0)
     {
       ok = 0;
     } else
     {
       ok = 1;
     }
      
   } while (ok==0);
   read_ix01(journal_pix_name);
   ix01zeiger = locate_ix01(refnr,&ix01rec_lokal);
   close_ix01();
   if (ix01zeiger==-1)
   {  
      return 0;
   }
   else
   {
      wrtxt("\nReference number already in database, please select another "
        "one!\n");
      return 1;
   }

}

static int textdatei_oeffnen(void)
{
   if ((fptxt=fopen(txt_name,"r"))==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: unable to read %s\n"
           "(probably file does not exist)\n",txt_name);
     wrtxt(wrtxtbu);
     return 0;
   }
   return 1;
}

static int select_document_type(void)
{
   int ok;

   ok = 0;
   wrtxt("\n(Reading record)\n");
   if (!textdatei_oeffnen())
   {
      return 0;
   }
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
     strlimcat(id_zeile,"DOCUMENT-TYPE-",ID_ZEILE_LEN);
     if (locate_substring(id_zeile,in_zeile)==0)
     {
       strcpy(in_zeile,"");
       break;
     }
   }
   if (fgets(in_zeile,MAXARR,fptxt)==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: cannot read "
       "document type in %s\n",txt_name);
     wrtxt(wrtxtbu);
     fclose(fptxt);
     return 0;
   }
   rtrim(in_zeile,'\n');
   fclose(fptxt);
   
   if (!textdatei_oeffnen())
   {
      return 0;
   }
   if (strcmp("j1",in_zeile)==0)
   {
      if ((ok = lies_j1("j1"))==0)
      {
         wrtxt("\n(Record not stored)\n");
      }
   }
   else if (strcmp("j2",in_zeile)==0)
   {
      if ((ok = lies_j2("j2"))==0)
      {
         wrtxt("\n(Record not stored)\n");
      }
   }
   else if (strcmp("b1",in_zeile)==0)
   {
      if ((ok = lies_b1("b1"))==0)
      {
         wrtxt("\n(Record not stored)\n");
      }
   }
   else if (strcmp("b2",in_zeile)==0)
   {
      if ((ok = lies_b2("b2"))==0)
      {
         wrtxt("\n(Record not stored)\n");
      }
   }
   else if (strcmp("b3",in_zeile)==0)
   {
      if ((ok = lies_b3("b3"))==0)
      {
         wrtxt("\n(Record not stored)\n");
      }
   }
   else if (strcmp("m1",in_zeile)==0)
   {
      if ((ok = lies_m1("m1"))==0)
      {
         wrtxt("\n(Record not stored)\n");
      }
   }
   else if (strcmp("m2",in_zeile)==0)
   {
      if ((ok = lies_m2("m2"))==0)
      {
         wrtxt("\n(Record not stored)\n");
      }
   }
   else
   {
     sprintf(wrtxtbu,"\nProblem: no valid "
       "document type found: %s\n",in_zeile);
     wrtxt(wrtxtbu);
     fclose(fptxt);
     return 0;
   }

   /* read text files */
   fclose(fptxt);
   /* put data into database */
   // if (ok==1) ...
   return 1;
}

static int variablen_initialisieren(void)
{
   /* initializes al variables with zeroes. Pointers to records in database
      files are set to -1 for 'void' */
   long i;
   memset(&one_journal_rec,0,sizeof(one_journal_rec));
   memset(&one_aued_rec,0,sizeof(one_aued_rec));
   memset(&one_desc_rec,0,sizeof(one_desc_rec));
   memset(&one_buch_rec,0,sizeof(one_buch_rec));
   memset(&one_quell_rec,0,sizeof(one_quell_rec));
   memset(&one_key_rec,0,sizeof(one_key_rec));
   memset(&one_abstr_rec,0,sizeof(one_abstr_rec));
   memset(&ix01rec,0,sizeof(ix01rec));
   ix01rec.journal_rptr = -1;
   ix01rec.buch_rptr = -1;
   ix01rec.autorjl_rptr = -1;
   ix01rec.autorbu_rptr = -1;
   ix01rec.desc_rptr = -1;
   memset(&ix02rec,0,sizeof(ix02rec));
   ix02rec.quell_rptr = 1;
   memset(&ix03rec,0,sizeof(ix03rec));
   ix03rec.keywords_rptr = -1;
   memset(&ix04rec,0,sizeof(ix04rec));
   ix04rec.abstr_rptr = -1;

   for (i=0;i<=(MAX_N_AUTHORS - 1);i++)
   {
     autorenliste[i]=one_aued_rec; 
   }
   for (i=0;i<=(MAX_N_AUTHORS - 1);i++)
   {
     editorenliste[i]=one_aued_rec; 
   }
   for (i=0;i<=(MAX_N_DESC - 1);i++)
   {
     descliste[i]=one_desc_rec; 
   }
   for (i=0;i<=(MAX_N_DESC - 1);i++)
   {
     descliste[i]=one_desc_rec; 
   }
   for (i=0;i<=(MAX_BLOECKE - 1);i++)
   {
     abstractliste[i]=one_abstr_rec; 
   }
   return 1;
}


static int lies_j1(char * dtyp)
{
   long i, anz_items, laenge;
   static char ein[INPUT_BU_LEN+1];
   int option;
   
   /* proceed to label REFERENCE-NUMBER- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"REFERENCE-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }
   if (fgets(in_zeile,MAXARR,fptxt)==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: cannot read "
       "reference number in %s\n",txt_name);
     wrtxt(wrtxtbu);
     return 0;
   }
   rtrim(in_zeile,'\n');
   /* reference number in in_zeile */
   /* put reference number into the appropriate filds, enter document type */
   strlimcpy(one_journal_rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   if (strlen(one_journal_rec.kennziffer)==0)
   {
      wrtxt("\nProblem: reference number (key) empty\n");
      return 0;
   }
   // strlimcpy(one_journal_rec.reftyp,"j1",REFTYP_LEN);
   strlimcpy(one_journal_rec.reftyp,dtyp,REFTYP_LEN);
   strlimcpy(ix01rec.kennziffer,in_zeile,KENNZIFFER_LEN); 
   strlimcpy(ix04rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   
   /* proceed to label DOCUMENT-TYPE- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DOCUMENT-TYPE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }

   /* proceed to label AUTHORS- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"AUTHORS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }

   i = 0;
   anz_items = 0;
   /* read authors */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"TITLE-ARTICLE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all authors have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of authors not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     // wrtxt(in_zeile);
     rtrim(in_zeile,'\n');
     if (aued_eintragen(in_zeile,&one_aued_rec)==0)
     {
        return 0;
     }
     i++; anz_items++; // wahrscheinlich wird hier an der falschen Stelle gezaehlt
     if (i > MAX_N_AUTHORS)
     {
        break;
     }
     strlimcpy(one_aued_rec.au_kennziffer,one_journal_rec.kennziffer,AUKENNZIFFER_LEN);
     one_aued_rec.in_use_au = 1;
     one_aued_rec.au_i = i;
     /* copy into the autorenliste array: */
     autorenliste[i-1] = one_aued_rec; 
   }
   /* check, if autorenliste is not empty */
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of authors is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      autorenliste[i-1].au_n = anz_items;
   }
   /* completed: reading authors' names */
   /* read title-article: */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"JOURNAL-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: title of article not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,TITEL_LEN);
     } else
     {
       strlimcat(ex_zeile," ",TITEL_LEN);
       strlimcat(ex_zeile,in_zeile,TITEL_LEN);
     }
   }
   strlimcpy(one_journal_rec.titel,ex_zeile,TITEL_LEN);
   /* completed: read title-article: */
   /* read journal code: */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"IDNR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* journal code has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: journal-code not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,KUERZEL_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.kuerzel,ex_zeile,KUERZEL_LEN); 
   /* read journal idnr: */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-YEAR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* idnr has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: idnr not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,IDNR_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.idnr,ex_zeile,IDNR_LEN); 

   /* read date-year */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-MONTH-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-year has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-year not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,JAHRGANG_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.jahrgang,ex_zeile,JAHRGANG_LEN); 
   /* read date-month */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-DAY-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-month has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-month not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,KUERZEL_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.monat,ex_zeile,MONAT_LEN); 
   /* read date-day */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"VOLUME-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-day has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-day not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,KUERZEL_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.tag,ex_zeile,TAG_LEN); 
   /* read volume */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ISSUE-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* volume has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: volume not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,BAND_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.band,ex_zeile,BAND_LEN); 
   /* read issue-number */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"FIRST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* issue-number has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: issue-number not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,ISSUE_NUMMER_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.issue_nummer,ex_zeile,ISSUE_NUMMER_LEN); 
   /* read page-from */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"LAST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* first-page has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: first page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_VON_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_von,ex_zeile,SEITE_VON_LEN); 
   /* read page-to */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"STATUS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* page-to has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: last-page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_BIS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_bis,ex_zeile,SEITE_BIS_LEN); 
   /* read: status */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"KEYWORDS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* status has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: status not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,STATUS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.status,ex_zeile,STATUS_LEN); 
   /* completed: status */
  
   /* read KEYWORDS */
   /* keywords have to be counted */
   i = 0;
   anz_items = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"K-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all keywords have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of keywords not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     // wrtxt(in_zeile);
     rtrim(in_zeile,'\n');
     if (strlen(in_zeile) >= 1)
     {
       strlimcpy(one_desc_rec.keywordsfield,in_zeile,KEYWORDS_LEN);
       i++; 
       anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
       }
   }
   /* Hier die Keywords-Ziffern einlesen! */
   
   /* read K-NUMBER */
   /* Keywords-Datei (Index) zum Lesen oeffnen */
   read_ix03(stichw_pix_name);
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ABSTRACT-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all K-NUMBERs have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of K-NUMBERs not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     
     if (desc_eintragen(in_zeile, &one_desc_rec))
     { 
       i++; anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
     }
   }
   close_ix03();
   /* Keywords-Datei (Index) schliessen*/
  
   /* completed: read K-NUMBER */
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of keywords is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      descliste[i-1].desc_n = anz_items;
   }
   /* completed descliste */

   /* read: abstract */
   strcpy(abs_zeile,"");
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"END-OF-RECORD",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: abstract not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcat(abs_zeile,in_zeile,ABSTRACT_ZEILE_LEN);
   }
   
   
   laenge = strlen(abs_zeile);
   if (laenge  > 1)
   {
     split_abstract(abs_zeile);
   }
   /* completed: abstract */

   j1_zeigen();
   wrtxt("\nWrite this record into database [y/n]?\n");
   option = 0;
   strcpy(ein,"menu");
   option = menu_wahl(ein,
     "[y] yes, format of record is correct, save this record\n"
     "[n] do not save record"
     );
   if (option==1)
   {
     if (j1m1_speichern("j1") ==1)
     {
       wrtxt("\n(Record has been stored successfully)\n");
     }
     else
     {
       wrtxt("\n(Record not stored)\n");
     }
   }
   else
   {
     wrtxt("\n(Record not stored)\n");
   }
   return 1;
}

static int lies_j2(char * dtyp)
{
   long i, anz_items, laenge;
   static char ein[INPUT_BU_LEN+1];
   int option;
   
   /* proceed to label REFERENCE-NUMBER- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"REFERENCE-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }
   if (fgets(in_zeile,MAXARR,fptxt)==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: cannot read "
       "reference number in %s\n",txt_name);
     wrtxt(wrtxtbu);
     return 0;
   }
   rtrim(in_zeile,'\n');
   /* reference number in in_zeile */
   /* put reference number into the appropriate filds, enter document type */
   strlimcpy(one_journal_rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   if (strlen(one_journal_rec.kennziffer)==0)
   {
      wrtxt("\nProblem: reference number (key) empty\n");
      return 0;
   }
   // strlimcpy(one_journal_rec.reftyp,"j2",REFTYP_LEN);
   strlimcpy(one_journal_rec.reftyp,dtyp,REFTYP_LEN);
   strlimcpy(ix01rec.kennziffer,in_zeile,KENNZIFFER_LEN); 
   strlimcpy(ix04rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   
   /* proceed to label DOCUMENT-TYPE- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DOCUMENT-TYPE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }

   /* proceed to label INSTITUTIONAL-AUTHOR- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"INSTITUTIONAL-AUTHOR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }

   /* read institutional authors */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"TITLE-ARTICLE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of institutional author have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: institutional author not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,INSTAU_LEN);
     } else
     {
       strlimcat(ex_zeile," ",INSTAU_LEN);
       strlimcat(ex_zeile,in_zeile,INSTAU_LEN);
     }
   }
   strlimcpy(one_journal_rec.instau,ex_zeile,INSTAU_LEN);
   /* completed: reading institutional authors */
   
   /* read title-article: */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"JOURNAL-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: title of article not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,TITEL_LEN);
     } else
     {
       strlimcat(ex_zeile," ",TITEL_LEN);
       strlimcat(ex_zeile,in_zeile,TITEL_LEN);
     }
   }
   strlimcpy(one_journal_rec.titel,ex_zeile,TITEL_LEN);
   /* completed: read title-article: */
   /* read journal code: */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"IDNR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* journal code has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: journal-code not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,KUERZEL_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.kuerzel,ex_zeile,KUERZEL_LEN); 
   /* read journal idnr: */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-YEAR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* idnr has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: idnr not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,IDNR_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.idnr,ex_zeile,IDNR_LEN); 

   /* read date-year */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-MONTH-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-year has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-year not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,JAHRGANG_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.jahrgang,ex_zeile,JAHRGANG_LEN); 
   /* read date-month */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-DAY-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-month has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-month not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,KUERZEL_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.monat,ex_zeile,MONAT_LEN); 
   /* read date-day */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"VOLUME-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-day has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-day not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,KUERZEL_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.tag,ex_zeile,TAG_LEN); 
   /* read volume */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ISSUE-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* volume has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: volume not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,BAND_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.band,ex_zeile,BAND_LEN); 
   /* read issue-number */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"FIRST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* issue-number has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: issue-number not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,ISSUE_NUMMER_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.issue_nummer,ex_zeile,ISSUE_NUMMER_LEN); 
   /* read page-from */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"LAST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* first-page has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: first page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_VON_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_von,ex_zeile,SEITE_VON_LEN); 
   /* read page-to */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"STATUS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* page-to has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: last-page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_BIS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_bis,ex_zeile,SEITE_BIS_LEN); 
   /* read: status */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"KEYWORDS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* status has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: status not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,STATUS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.status,ex_zeile,STATUS_LEN); 
   /* completed: status */
  
   /* read KEYWORDS */
   /* keywords have to be counted */
   i = 0;
   anz_items = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"K-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all keywords have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of keywords not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     // wrtxt(in_zeile);
     rtrim(in_zeile,'\n');
     if (strlen(in_zeile) >= 1)
     {
       strlimcpy(one_desc_rec.keywordsfield,in_zeile,KEYWORDS_LEN);
       i++; 
       anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
       }
   }
   /* Hier die Keywords-Ziffern einlesen! */
   
   /* read K-NUMBER */
   /* Keywords-Datei (Index) zum Lesen oeffnen */
   read_ix03(stichw_pix_name);
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ABSTRACT-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all K-NUMBERs have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of K-NUMBERs not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     
     if (desc_eintragen(in_zeile, &one_desc_rec))
     { 
       i++; anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
     }
   }
   close_ix03();
   /* Keywords-Datei (Index) schliessen*/
  
   /* completed: read K-NUMBER */
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of keywords is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      descliste[i-1].desc_n = anz_items;
   }
   /* completed descliste */

   /* read: abstract */
   strcpy(abs_zeile,"");
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"END-OF-RECORD",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: abstract not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcat(abs_zeile,in_zeile,ABSTRACT_ZEILE_LEN);
   }
   
   laenge = strlen(abs_zeile);
   if (laenge  > 1)
   {
     split_abstract(abs_zeile);
   }
   /* completed: abstract */

   j2_zeigen();
   wrtxt("\nWrite this record into database [y/n]?\n");
   option = 0;
   strcpy(ein,"menu");
   option = menu_wahl(ein,
     "[y] yes, format of record is correct, save this record\n"
     "[n] do not save record"
     );
   if (option==1)
   {
     if (j2m2_speichern("j2") ==1)
     {
       wrtxt("\n(Record has been stored successfully)\n");
     }
     else
     {
       wrtxt("\n(Record not stored)\n");
     }
   }
   else
   {
     wrtxt("\n(Record not stored)\n");
   }
   return 1;
}



static int lies_b1(char * dtyp)
{
   long i, anz_items, laenge;
   static char ein[INPUT_BU_LEN+1];
   int option;
   
   /* printf("\n...processing b1...\n"); */

   /* proceed to label REFERENCE-NUMBER- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"REFERENCE-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }
   if (fgets(in_zeile,MAXARR,fptxt)==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: cannot read "
       "reference number in %s\n",txt_name);
     wrtxt(wrtxtbu);
     return 0;
   }
   rtrim(in_zeile,'\n');

   /* reference number in in_zeile */
   /* put reference number into the appropriate filds, enter document type */
   strlimcpy(one_journal_rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   strlimcpy(one_buch_rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   if (strlen(one_journal_rec.kennziffer)==0)
   {
      wrtxt("\nProblem: reference number (key) empty\n");
      return 0;
   }
   // strlimcpy(one_journal_rec.reftyp,"b1",REFTYP_LEN);
   strlimcpy(one_journal_rec.reftyp,dtyp,REFTYP_LEN);
   strlimcpy(ix01rec.kennziffer,in_zeile,KENNZIFFER_LEN); 
   strlimcpy(ix04rec.kennziffer,in_zeile,KENNZIFFER_LEN);

   /* proceed to label DOCUMENT-TYPE- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DOCUMENT-TYPE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }
   /* proceed to label EDITORS- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"EDITORS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }

   i = 0;
   anz_items = 0;
   /* read editors */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"TITLE-BOOK-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all editors have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of editors not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     if (aued_eintragen(in_zeile,&one_aued_rec)==0)
     {
        return 0;
     }
     i++; anz_items++; // wahrscheinlich wird hier an der falschen Stelle gezaehlt
     if (i > MAX_N_AUTHORS)
     {
        break;
     }
     strlimcpy(one_aued_rec.au_kennziffer,one_journal_rec.kennziffer,AUKENNZIFFER_LEN);
     one_aued_rec.in_use_au = 1;
     one_aued_rec.au_i = i;
     /* copy into the autorenliste array: */
     editorenliste[i-1] = one_aued_rec; 
   }
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of editors is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      editorenliste[i-1].au_n = anz_items;
   }
   /* completed: reading editors' names */
   /* read title-book: */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"EDITION-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of book-title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: title of book not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,TITELBUCH_LEN);
     } else
     {
       strlimcat(ex_zeile," ",TITELBUCH_LEN);
       strlimcat(ex_zeile,in_zeile,TITELBUCH_LEN);
     }
   }
   strlimcpy(one_buch_rec.titel_bu,ex_zeile,TITELBUCH_LEN);
   /* completed: read book-title: */
   /* read: edition-number */
   /* edition number is stored in 'one_journal_rec.band' position */   
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ISBN-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* edition-number has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: edition-number not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,BAND_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.band,ex_zeile,BAND_LEN); 
   /* completed: edition-number (stored in one_journal_rec.band) */
   /* read: ISBN */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"PLACE-OF-PUBLICATION-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* ISBN has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: ISBN not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,ISBN_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_buch_rec.isbn,ex_zeile,ISBN_LEN); 
   /* completed: ISBN */
   /* read: place of publication */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"IDNR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* place of publication has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: place of publication not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,PUBLORT_LEN);
     } else
     {
       strlimcat(ex_zeile," ",PUBLORT_LEN);
       strlimcat(ex_zeile,in_zeile,PUBLORT_LEN);
     }
   }
   // rtrim(ex_zeile,'\n');
   // rtrim(ex_zeile,' ');
   strlimcpy(one_buch_rec.publ_ort,ex_zeile,PUBLORT_LEN); 
   /* completed: place of publication */
   /* read journal idnr: */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-YEAR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* idnr has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: idnr not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,IDNR_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.idnr,ex_zeile,IDNR_LEN); 

   /* read: date-year */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"PUBLISHER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-year has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-year not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,JAHRGANG_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.jahrgang,ex_zeile,JAHRGANG_LEN); 
   /* completed: date-year */
   /* read: publisher */

   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"FIRST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* publisher has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: publisher not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,VERLAG_LEN);
     } else
     {
       strlimcat(ex_zeile," ",VERLAG_LEN);
       strlimcat(ex_zeile,in_zeile,VERLAG_LEN);
     }
   }
   // rtrim(ex_zeile,'\n');
   // rtrim(ex_zeile,' ');
   strlimcpy(one_buch_rec.verlag,ex_zeile,VERLAG_LEN); 
   /* completed: publisher */
   /* read: page-from */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"LAST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* first page has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: first page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_VON_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_von,ex_zeile,SEITE_VON_LEN); 
   /* completed: page-from */ 
   /* read page-to */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"STATUS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* page-to has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: last page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_BIS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_bis,ex_zeile,SEITE_BIS_LEN); 
   /* completed: page-to */ 
   /* read: status */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"KEYWORDS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* status has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: status not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,STATUS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.status,ex_zeile,STATUS_LEN); 
   /* completed: status */
   /* read KEYWORDS */
   /* keywords have to be counted */
   i = 0;
   anz_items = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"K-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all keywords have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of keywords not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     if (strlen(in_zeile) >= 1)
     {
       strlimcpy(one_desc_rec.keywordsfield,in_zeile,KEYWORDS_LEN);
       i++; anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
     }

   }
   
   /* read K-NUMBER */
   /* Keywords-Datei (Index) zum Lesen oeffnen */
   read_ix03(stichw_pix_name);
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ABSTRACT-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all K-NUMBERs have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of K-NUMBERs not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     
     if (desc_eintragen(in_zeile, &one_desc_rec))
     { 
       i++; anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
     }
   }
   close_ix03();
   /* Keywords-Datei (Index) schliessen*/
  
   /* completed: read K-NUMBER */
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of keywords is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      descliste[i-1].desc_n = anz_items;
   }
   /* completed descliste */
   
   /* read: abstract */
   strcpy(abs_zeile,"");
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"END-OF-RECORD",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: abstract not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcat(abs_zeile,in_zeile,ABSTRACT_ZEILE_LEN);
   }
   
   
   laenge = strlen(abs_zeile);
   if (laenge  > 1)
   {
     split_abstract(abs_zeile);
   }
   /* completed: abstract */


   b1_zeigen();
   wrtxt("\nWrite this record into database [y/n]?\n");
   option = 0;
   strcpy(ein,"menu");
   option = menu_wahl(ein,
     "[y] yes, format of record is correct, save this record\n"
     "[n] do not save record"
     );
   if (option==1)
   {
     if (b1_speichern() ==1)
     {
       wrtxt("\n(Record has been stored successfully)\n");
     }
     else
     {
       wrtxt("\n(Record not stored)\n");
     }
   }
   else
   {
     wrtxt("\n(Record not stored)\n");
   }
   return 1;
}

static int lies_b2(char * dtyp)
{
   long i, anz_items, laenge;
   static char ein[INPUT_BU_LEN+1];
   int option;

   /* proceed to label REFERENCE-NUMBER- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"REFERENCE-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }
   if (fgets(in_zeile,MAXARR,fptxt)==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: cannot read "
       "reference number in %s\n",txt_name);
     wrtxt(wrtxtbu);
     return 0;
   }
   rtrim(in_zeile,'\n');
   /* reference number in in_zeile */
   /* put reference number into the appropriate filds, enter document type */
   strlimcpy(one_journal_rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   strlimcpy(one_buch_rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   if (strlen(one_journal_rec.kennziffer)==0)
   {
      wrtxt("\nProblem: reference number (key) empty\n");
      return 0;
   }
   // strlimcpy(one_journal_rec.reftyp,"b2",REFTYP_LEN);
   strlimcpy(one_journal_rec.reftyp,dtyp,REFTYP_LEN);
   strlimcpy(ix01rec.kennziffer,in_zeile,KENNZIFFER_LEN); 
   strlimcpy(ix04rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   

   /* proceed to label DOCUMENT-TYPE- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DOCUMENT-TYPE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }
   

   /* proceed to label AUTHORS- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"AUTHORS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }

   
   i = 0;
   anz_items = 0;
   /* read authors */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"TITLE-ARTICLE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all authors have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of authors not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     if (aued_eintragen(in_zeile,&one_aued_rec)==0)
     {
        return 0;
     }
     i++; anz_items++; // wahrscheinlich wird hier an der falschen Stelle gezaehlt
     if (i > MAX_N_AUTHORS)
     {
        break;
     }
     strlimcpy(one_aued_rec.au_kennziffer,one_journal_rec.kennziffer,AUKENNZIFFER_LEN);
     one_aued_rec.in_use_au = 1;
     one_aued_rec.au_i = i;
     /* copy into the autorenliste array: */
     autorenliste[i-1] = one_aued_rec; 
   }
   /* check, if autorenliste is not empty */
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of authors is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      autorenliste[i-1].au_n = anz_items;
   }
   /* completed: reading authors' names */
   /* read title-article: */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"EDITORS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: title of article not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,TITEL_LEN);
     } else
     {
       strlimcat(ex_zeile," ",TITEL_LEN);
       strlimcat(ex_zeile,in_zeile,TITEL_LEN);
     }
   }
   strlimcpy(one_journal_rec.titel,ex_zeile,TITEL_LEN);
   /* completed: read title-article: */
   i = 0;
   anz_items = 0;
   /* read editors */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"TITLE-BOOK-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all editors have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of editors not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     if (aued_eintragen(in_zeile,&one_aued_rec)==0)
     {
        return 0;
     }
     i++; anz_items++; // wahrscheinlich wird hier an der falschen Stelle gezaehlt
     if (i > MAX_N_AUTHORS)
     {
        break;
     }
     strlimcpy(one_aued_rec.au_kennziffer,one_journal_rec.kennziffer,AUKENNZIFFER_LEN);
     one_aued_rec.in_use_au = 1;
     one_aued_rec.au_i = i;
     /* copy into the autorenliste array: */
     editorenliste[i-1] = one_aued_rec; 
   }
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of editors is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      editorenliste[i-1].au_n = anz_items;
   }
   /* completed: reading editors' names */
   /* read title-book: */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"EDITION-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of book-title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: title of book not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     // wrtxt(in_zeile);
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,TITELBUCH_LEN);
     } else
     {
       strlimcat(ex_zeile," ",TITELBUCH_LEN);
       strlimcat(ex_zeile,in_zeile,TITELBUCH_LEN);
     }
   }
   strlimcpy(one_buch_rec.titel_bu,ex_zeile,TITELBUCH_LEN);
   /* completed: read book-title: */
   /* read: edition-number */
   /* edition number is stored in 'one_journal_rec.band' position */   
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ISBN-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* edition-number has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: edition-number not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,BAND_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.band,ex_zeile,BAND_LEN); 
   /* completed: edition-number (stored in one_journal_rec.band) */
   /* read: ISBN */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"PLACE-OF-PUBLICATION-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* ISBN has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: ISBN not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,ISBN_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_buch_rec.isbn,ex_zeile,ISBN_LEN); 
   /* completed: ISBN */
   /* read: place of publication */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"IDNR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* place of publication has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: place of publication not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,PUBLORT_LEN);
     } else
     {
       strlimcat(ex_zeile," ",PUBLORT_LEN);
       strlimcat(ex_zeile,in_zeile,PUBLORT_LEN);
     }
   }
   // rtrim(ex_zeile,'\n');
   // rtrim(ex_zeile,' ');
   strlimcpy(one_buch_rec.publ_ort,ex_zeile,PUBLORT_LEN); 
   /* completed: place of publication */
   /* read journal idnr: */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-YEAR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* idnr has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: idnr not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,IDNR_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.idnr,ex_zeile,IDNR_LEN); 

   /* read: date-year */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"PUBLISHER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-year has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-year not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,JAHRGANG_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.jahrgang,ex_zeile,JAHRGANG_LEN); 
   /* completed: date-year */
   /* read: publisher */

   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"FIRST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* publisher has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: publisher not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,VERLAG_LEN);
     } else
     {
       strlimcat(ex_zeile," ",VERLAG_LEN);
       strlimcat(ex_zeile,in_zeile,VERLAG_LEN);
     }
   }
   // rtrim(ex_zeile,'\n');
   // rtrim(ex_zeile,' ');
   strlimcpy(one_buch_rec.verlag,ex_zeile,VERLAG_LEN); 
   /* completed: publisher */
   /* read: page-from */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"LAST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* first page has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: first page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_VON_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_von,ex_zeile,SEITE_VON_LEN); 
   /* completed: page-from */ 
   /* read page-to */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"STATUS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* page-to has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: last page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_BIS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_bis,ex_zeile,SEITE_BIS_LEN); 
   /* completed: page-to */ 
   /* read: status */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"KEYWORDS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* status has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: status not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,STATUS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.status,ex_zeile,STATUS_LEN); 
   /* completed: status */
   /* read KEYWORDS */
   /* keywords have to be counted */
   i = 0;
   anz_items = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"K-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all keywords have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of keywords not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     // wrtxt(in_zeile);
     rtrim(in_zeile,'\n');
     if (strlen(in_zeile) >= 1)
     {
       strlimcpy(one_desc_rec.keywordsfield,in_zeile,KEYWORDS_LEN);
       i++; anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
     }

   }
   
   /* read K-NUMBER */
   /* Keywords-Datei (Index) zum Lesen oeffnen */
   read_ix03(stichw_pix_name);
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ABSTRACT-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all K-NUMBERs have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of K-NUMBERs not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     
     if (desc_eintragen(in_zeile, &one_desc_rec))
     { 
       i++; anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
     }
   }
   close_ix03();
   /* Keywords-Datei (Index) schliessen*/
  
   /* completed: read K-NUMBER */
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of keywords is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      descliste[i-1].desc_n = anz_items;
   }
   /* completed descliste */
   
   /* read: abstract */
   strcpy(abs_zeile,"");
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"END-OF-RECORD",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: abstract not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcat(abs_zeile,in_zeile,ABSTRACT_ZEILE_LEN);
   }
   
   
   laenge = strlen(abs_zeile);
   if (laenge  > 1)
   {
     split_abstract(abs_zeile);
   }
   /* completed: abstract */


   b2_zeigen();
   wrtxt("\nWrite this record into database [y/n]?\n");
   option = 0;
   strcpy(ein,"menu");
   option = menu_wahl(ein,
     "[y] yes, format of record is correct, save this record\n"
     "[n] do not save record"
     );
   if (option==1)
   {
     if (b2_speichern() ==1)
     {
       wrtxt("\n(Record has been stored successfully)\n");
     }
     else
     {
       wrtxt("\n(Record not stored)\n");
     }
   }
   else
   {
     wrtxt("\n(Record not stored)\n");
   }
   return 1;
}

static int lies_b3(char * dtyp)
{
   long i, anz_items, laenge;
   static char ein[INPUT_BU_LEN+1];
   int option;
   
   /* printf("\n...processing b3...\n"); */

   /* proceed to label REFERENCE-NUMBER- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"REFERENCE-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }
   if (fgets(in_zeile,MAXARR,fptxt)==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: cannot read "
       "reference number in %s\n",txt_name);
     wrtxt(wrtxtbu);
     return 0;
   }
   rtrim(in_zeile,'\n');

   /* reference number in in_zeile */
   /* put reference number into the appropriate filds, enter document type */
   strlimcpy(one_journal_rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   strlimcpy(one_buch_rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   if (strlen(one_journal_rec.kennziffer)==0)
   {
      wrtxt("\nProblem: reference number (key) empty\n");
      return 0;
   }
   // strlimcpy(one_journal_rec.reftyp,"b3",REFTYP_LEN);
   strlimcpy(one_journal_rec.reftyp,dtyp,REFTYP_LEN);
   strlimcpy(ix01rec.kennziffer,in_zeile,KENNZIFFER_LEN); 
   strlimcpy(ix04rec.kennziffer,in_zeile,KENNZIFFER_LEN);

   /* proceed to label DOCUMENT-TYPE- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DOCUMENT-TYPE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }
   /* proceed to label INSTITUTIONAL-EDITOR */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"INSTITUTIONAL-EDITOR",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }

   
   /* read institutional editors */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"TITLE-BOOK-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of institutional editor have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: institutional editor not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,INSTED_LEN);
     } else
     {
       strlimcat(ex_zeile," ",INSTED_LEN);
       strlimcat(ex_zeile,in_zeile,INSTED_LEN);
     }
   }
   strlimcpy(one_buch_rec.insted,ex_zeile,INSTED_LEN);
   /* completed: reading institutional editors */
   
   /* read book-title: */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"EDITION-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of book-title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: title of book not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,TITELBUCH_LEN);
     } else
     {
       strlimcat(ex_zeile," ",TITELBUCH_LEN);
       strlimcat(ex_zeile,in_zeile,TITELBUCH_LEN);
     }
   }
   strlimcpy(one_buch_rec.titel_bu,ex_zeile,TITELBUCH_LEN);
   /* completed: read book-title: */
   /* read: edition-number */
   /* edition number is stored in 'one_journal_rec.band' position */   
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ISBN-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* edition-number has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: edition-number not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,BAND_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.band,ex_zeile,BAND_LEN); 
   /* completed: edition-number (stored in one_journal_rec.band) */
   /* read: ISBN */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"PLACE-OF-PUBLICATION-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* ISBN has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: ISBN not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,ISBN_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_buch_rec.isbn,ex_zeile,ISBN_LEN); 
   /* completed: ISBN */
   /* read: place of publication */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"IDNR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* place of publication has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: place of publication not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,PUBLORT_LEN);
     } else
     {
       strlimcat(ex_zeile," ",PUBLORT_LEN);
       strlimcat(ex_zeile,in_zeile,PUBLORT_LEN);
     }
   }
   // rtrim(ex_zeile,'\n');
   // rtrim(ex_zeile,' ');
   strlimcpy(one_buch_rec.publ_ort,ex_zeile,PUBLORT_LEN); 
   /* completed: place of publication */
   /* read journal idnr: */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-YEAR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* idnr has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: idnr not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,IDNR_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.idnr,ex_zeile,IDNR_LEN); 

   /* read: date-year */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"PUBLISHER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-year has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-year not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,JAHRGANG_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.jahrgang,ex_zeile,JAHRGANG_LEN); 
   /* completed: date-year */
   /* read: publisher */

   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"FIRST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* publisher has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: publisher not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,VERLAG_LEN);
     } else
     {
       strlimcat(ex_zeile," ",VERLAG_LEN);
       strlimcat(ex_zeile,in_zeile,VERLAG_LEN);
     }
   }
   // rtrim(ex_zeile,'\n');
   // rtrim(ex_zeile,' ');
   strlimcpy(one_buch_rec.verlag,ex_zeile,VERLAG_LEN); 
   /* completed: publisher */
   /* read: page-from */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"LAST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* first page has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: first page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_VON_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_von,ex_zeile,SEITE_VON_LEN); 
   /* completed: page-from */ 
   /* read page-to */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"STATUS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* page-to has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: last page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_BIS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_bis,ex_zeile,SEITE_BIS_LEN); 
   /* completed: page-to */ 
   /* read: status */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"KEYWORDS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* status has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: status not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,STATUS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.status,ex_zeile,STATUS_LEN); 
   /* completed: status */
   /* read KEYWORDS */
   /* keywords have to be counted */
   i = 0;
   anz_items = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"K-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all keywords have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of keywords not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     if (strlen(in_zeile) >= 1)
     {
       strlimcpy(one_desc_rec.keywordsfield,in_zeile,KEYWORDS_LEN);
       i++; anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
     }

   }
   
   /* read K-NUMBER */
   /* Keywords-Datei (Index) zum Lesen oeffnen */
   read_ix03(stichw_pix_name);
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ABSTRACT-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all K-NUMBERs have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of K-NUMBERs not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     
     if (desc_eintragen(in_zeile, &one_desc_rec))
     { 
       i++; anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
     }
   }
   close_ix03();
   /* Keywords-Datei (Index) schliessen*/
  
   /* completed: read K-NUMBER */
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of keywords is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      descliste[i-1].desc_n = anz_items;
   }
   /* completed descliste */
   
   /* read: abstract */
   strcpy(abs_zeile,"");
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"END-OF-RECORD",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: abstract not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcat(abs_zeile,in_zeile,ABSTRACT_ZEILE_LEN);
   }
   
   laenge = strlen(abs_zeile);
   if (laenge  > 1)
   {
     split_abstract(abs_zeile);
   }
   /* completed: abstract */


   b3_zeigen();
   wrtxt("\nWrite this record into database [y/n]?\n");
   option = 0;
   strcpy(ein,"menu");
   option = menu_wahl(ein,
     "[y] yes, format of record is correct, save this record\n"
     "[n] do not save record"
     );
   if (option==1)
   {
     if (b3_speichern() ==1)
     {
       wrtxt("\n(Record has been stored successfully)\n");
     }
     else
     {
       wrtxt("\n(Record not stored)\n");
     }
   }
   else
   {
     wrtxt("\n(Record not stored)\n");
   }
   return 1;
}


/* modified from j1 */
static int lies_m1(char * dtyp)
{
   long i, anz_items, laenge;
   static char ein[INPUT_BU_LEN+1];
   int option;
   
   /* proceed to label REFERENCE-NUMBER- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"REFERENCE-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }
   if (fgets(in_zeile,MAXARR,fptxt)==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: cannot read "
       "reference number in %s\n",txt_name);
     wrtxt(wrtxtbu);
     return 0;
   }
   rtrim(in_zeile,'\n');
   /* reference number in in_zeile */
   /* put reference number into the appropriate filds, enter document type */
   strlimcpy(one_journal_rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   if (strlen(one_journal_rec.kennziffer)==0)
   {
      wrtxt("\nProblem: reference number (key) empty\n");
      return 0;
   }
   // strlimcpy(one_journal_rec.reftyp,"j1",REFTYP_LEN);
   strlimcpy(one_journal_rec.reftyp,dtyp,REFTYP_LEN);
   strlimcpy(ix01rec.kennziffer,in_zeile,KENNZIFFER_LEN); 
   strlimcpy(ix04rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   
   /* proceed to label DOCUMENT-TYPE- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DOCUMENT-TYPE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }

   /* proceed to label AUTHORS- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"AUTHORS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }

   i = 0;
   anz_items = 0;
   /* read authors */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"TITLE-ARTICLE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all authors have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of authors not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     // wrtxt(in_zeile);
     rtrim(in_zeile,'\n');
     if (aued_eintragen(in_zeile,&one_aued_rec)==0)
     {
        return 0;
     }
     i++; anz_items++; // wahrscheinlich wird hier an der falschen Stelle gezaehlt
     if (i > MAX_N_AUTHORS)
     {
        break;
     }
     strlimcpy(one_aued_rec.au_kennziffer,one_journal_rec.kennziffer,AUKENNZIFFER_LEN);
     one_aued_rec.in_use_au = 1;
     one_aued_rec.au_i = i;
     /* copy into the autorenliste array: */
     autorenliste[i-1] = one_aued_rec; 
   }
   /* check, if autorenliste is not empty */
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of authors is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      autorenliste[i-1].au_n = anz_items;
   }
   /* completed: reading authors' names */
   /* read title-article: */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"HOWPUBLISHED-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: title of article not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,TITEL_LEN);
     } else
     {
       strlimcat(ex_zeile," ",TITEL_LEN);
       strlimcat(ex_zeile,in_zeile,TITEL_LEN);
     }
   }
   strlimcpy(one_journal_rec.titel,ex_zeile,TITEL_LEN);
   /* completed: read title-article: */
   /* read howpublished: */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"IDNR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* howpublished has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: howpublished not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,HOWPUBLISHED_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.howpublished,ex_zeile,HOWPUBLISHED_LEN); 
   /* read journal idnr: */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-YEAR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* idnr has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: idnr not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,IDNR_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.idnr,ex_zeile,IDNR_LEN); 

   /* read date-year */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-MONTH-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-year has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-year not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,JAHRGANG_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.jahrgang,ex_zeile,JAHRGANG_LEN); 
   /* read date-month */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-DAY-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-month has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-month not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,MONAT_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.monat,ex_zeile,MONAT_LEN); 
   /* read date-day */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"FIRST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-day has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-day not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,TAG_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.tag,ex_zeile,TAG_LEN); 
   /* read page-from */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"LAST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* first-page has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: first page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_VON_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_von,ex_zeile,SEITE_VON_LEN); 
   /* read page-to */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"STATUS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* page-to has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: last-page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_BIS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_bis,ex_zeile,SEITE_BIS_LEN); 
   /* read: status */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"KEYWORDS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* status has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: status not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,STATUS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.status,ex_zeile,STATUS_LEN); 
   /* completed: status */
  
   /* read KEYWORDS */
   /* keywords have to be counted */
   i = 0;
   anz_items = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"K-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all keywords have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of keywords not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     // wrtxt(in_zeile);
     rtrim(in_zeile,'\n');
     if (strlen(in_zeile) >= 1)
     {
       strlimcpy(one_desc_rec.keywordsfield,in_zeile,KEYWORDS_LEN);
       i++; 
       anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
       }
   }
   /* Hier die Keywords-Ziffern einlesen! */
   
   /* read K-NUMBER */
   /* Keywords-Datei (Index) zum Lesen oeffnen */
   read_ix03(stichw_pix_name);
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ABSTRACT-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all K-NUMBERs have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of K-NUMBERs not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     
     if (desc_eintragen(in_zeile, &one_desc_rec))
     { 
       i++; anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
     }
   }
   close_ix03();
   /* Keywords-Datei (Index) schliessen*/
  
   /* completed: read K-NUMBER */
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of keywords is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      descliste[i-1].desc_n = anz_items;
   }
   /* completed descliste */

   /* read: abstract */
   strcpy(abs_zeile,"");
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"END-OF-RECORD",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: abstract not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcat(abs_zeile,in_zeile,ABSTRACT_ZEILE_LEN);
   }
   
   
   laenge = strlen(abs_zeile);
   if (laenge  > 1)
   {
     split_abstract(abs_zeile);
   }
   /* completed: abstract */

   m1_zeigen();
   wrtxt("\nWrite this record into database [y/n]?\n");
   option = 0;
   strcpy(ein,"menu");
   option = menu_wahl(ein,
     "[y] yes, format of record is correct, save this record\n"
     "[n] do not save record"
     );
   if (option==1)
   {
     if (j1m1_speichern("m1") ==1)
     {
       wrtxt("\n(Record has been stored successfully)\n");
     }
     else
     {
       wrtxt("\n(Record not stored)\n");
     }
   }
   else
   {
     wrtxt("\n(Record not stored)\n");
   }
   return 1;
}

/* modified from j2 */
static int lies_m2(char * dtyp)
{
   long i, anz_items, laenge;
   static char ein[INPUT_BU_LEN+1];
   int option;
   
   /* proceed to label REFERENCE-NUMBER- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"REFERENCE-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }
   if (fgets(in_zeile,MAXARR,fptxt)==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: cannot read "
       "reference number in %s\n",txt_name);
     wrtxt(wrtxtbu);
     return 0;
   }
   rtrim(in_zeile,'\n');
   /* reference number in in_zeile */
   /* put reference number into the appropriate filds, enter document type */
   strlimcpy(one_journal_rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   if (strlen(one_journal_rec.kennziffer)==0)
   {
      wrtxt("\nProblem: reference number (key) empty\n");
      return 0;
   }
   // strlimcpy(one_journal_rec.reftyp,"j2",REFTYP_LEN);
   strlimcpy(one_journal_rec.reftyp,dtyp,REFTYP_LEN);
   strlimcpy(ix01rec.kennziffer,in_zeile,KENNZIFFER_LEN); 
   strlimcpy(ix04rec.kennziffer,in_zeile,KENNZIFFER_LEN);
   
   /* proceed to label DOCUMENT-TYPE- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DOCUMENT-TYPE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }

   /* proceed to label INSTITUTIONAL-AUTHOR- */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"INSTITUTIONAL-AUTHOR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
   }

   /* read institutional authors */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"TITLE-ARTICLE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of institutional author have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: institutional author not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,INSTAU_LEN);
     } else
     {
       strlimcat(ex_zeile," ",INSTAU_LEN);
       strlimcat(ex_zeile,in_zeile,INSTAU_LEN);
     }
   }
   strlimcpy(one_journal_rec.instau,ex_zeile,INSTAU_LEN);
   /* completed: reading institutional authors */
   
   /* read title-article: */
   strcpy(ex_zeile,"");
   i = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"HOWPUBLISHED-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: title of article not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     if (i==1)
     {
       strlimcpy(ex_zeile,in_zeile,TITEL_LEN);
     } else
     {
       strlimcat(ex_zeile," ",TITEL_LEN);
       strlimcat(ex_zeile,in_zeile,TITEL_LEN);
     }
   }
   strlimcpy(one_journal_rec.titel,ex_zeile,TITEL_LEN);
   /* completed: read title-article: */
   /* read howpublished: */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"IDNR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* howpublished has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: howpublished not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,HOWPUBLISHED_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.howpublished,ex_zeile,HOWPUBLISHED_LEN); 
   /* read journal idnr: */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-YEAR-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* idnr has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: idnr not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,IDNR_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.idnr,ex_zeile,IDNR_LEN); 

   /* read date-year */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-MONTH-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-year has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-year not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,JAHRGANG_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.jahrgang,ex_zeile,JAHRGANG_LEN); 
   /* read date-month */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"DATE-DAY-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-month has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-month not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,KUERZEL_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.monat,ex_zeile,MONAT_LEN); 
   /* read date-day */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"FIRST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* date-day has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: date-day not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,KUERZEL_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.tag,ex_zeile,TAG_LEN); 
   /* read page-from */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"LAST-PAGE-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* first-page has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: first page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_VON_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_von,ex_zeile,SEITE_VON_LEN); 
   /* read page-to */ 
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"STATUS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* page-to has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: last-page not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,SEITE_BIS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.seite_bis,ex_zeile,SEITE_BIS_LEN); 
   /* read: status */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"KEYWORDS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* status has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: status not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,STATUS_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_journal_rec.status,ex_zeile,STATUS_LEN); 
   /* completed: status */
  
   /* read KEYWORDS */
   /* keywords have to be counted */
   i = 0;
   anz_items = 0;
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"K-NUMBER-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all keywords have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of keywords not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     // wrtxt(in_zeile);
     rtrim(in_zeile,'\n');
     if (strlen(in_zeile) >= 1)
     {
       strlimcpy(one_desc_rec.keywordsfield,in_zeile,KEYWORDS_LEN);
       i++; 
       anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
       }
   }
   /* Hier die Keywords-Ziffern einlesen! */
   
   /* read K-NUMBER */
   /* Keywords-Datei (Index) zum Lesen oeffnen */
   read_ix03(stichw_pix_name);
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ABSTRACT-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all K-NUMBERs have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of K-NUMBERs not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     
     if (desc_eintragen(in_zeile, &one_desc_rec))
     { 
       i++; anz_items++;
       if (i > MAX_N_DESC)
       {
          break;
       }
       strlimcpy(one_desc_rec.kennziffer,one_journal_rec.kennziffer,KENNZIFFER_LEN);
       one_desc_rec.in_use = 1;
       one_desc_rec.desc_i = i;
       descliste[i-1] = one_desc_rec;
     }
   }
   close_ix03();
   /* Keywords-Datei (Index) schliessen*/
  
   /* completed: read K-NUMBER */
   if (anz_items < 1)
   {
      sprintf(wrtxtbu,"\nProblem: list of keywords is empty\n");
      wrtxt(wrtxtbu);
      return 0;
   }
   for (i=1;i<=anz_items;i++)
   {
      descliste[i-1].desc_n = anz_items;
   }
   /* completed descliste */

   /* read: abstract */
   strcpy(abs_zeile,"");
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"END-OF-RECORD",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* all lines of title have bee read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: abstract not closed with `%s' "
           "in %s\n",id_zeile,txt_name);
         wrtxt(wrtxtbu);
         return 0;
       }
     }
     strlimcat(abs_zeile,in_zeile,ABSTRACT_ZEILE_LEN);
   }
   
   
   laenge = strlen(abs_zeile);
   if (laenge  > 1)
   {
     split_abstract(abs_zeile);
   }
   /* completed: abstract */

   m2_zeigen();
   wrtxt("\nWrite this record into database [y/n]?\n");
   option = 0;
   strcpy(ein,"menu");
   option = menu_wahl(ein,
     "[y] yes, format of record is correct, save this record\n"
     "[n] do not save record"
     );
   if (option==1)
   {
     if (j2m2_speichern("m2") ==1)
     {
       wrtxt("\n(Record has been stored successfully)\n");
     }
     else
     {
       wrtxt("\n(Record not stored)\n");
     }
   }
   else
   {
     wrtxt("\n(Record not stored)\n");
   }
   return 1;
}



/* puts abstract into abstractliste array */
static int split_abstract(char * abstract)
{
   int anzahl_bloecke, k;
   long i, j, laenge; 
   
   // neu:
   laenge = strlen(abstract);
   for (i=0;i<=laenge;i++)
   {
     if (abstract[i]=='\n')
     {
       abstract[i] = '\xfe';
     }
   }
   

   anzahl_bloecke = blocks_required(abstract);
   if (anzahl_bloecke > MAX_BLOECKE)
   {
      sprintf(wrtxtbu,"\nWarning: abstract in %s contains > %i "
        "characters, will be truncated!\n",
        txt_name, ABSTEXT_LEN * MAX_BLOECKE);
      wrtxt(wrtxtbu);
      anzahl_bloecke = MAX_BLOECKE;
   }
   j = 0; /* Adresse in abstract */
   for (i=1;i<=anzahl_bloecke;i++)
   {
        /* memset(&one_abstr_rec,'\0',sizeof(one_abstr_rec)); */
        memset(&one_abstr_rec,0,sizeof(one_abstr_rec));
        one_abstr_rec.in_use=1;
        one_abstr_rec.abstr_i=i;
        one_abstr_rec.abstr_n=anzahl_bloecke;
        strcpy(one_abstr_rec.kennziffer,one_journal_rec.kennziffer);
        k = 0; /* Adresse in one_abstr_rec.abs_text */
        for (k=0;k < ABSTEXT_LEN;k++)
        {
          if (j<laenge)
          {
            one_abstr_rec.abs_text[k] = abs_zeile[j++];
          }
        }
        abstractliste[i-1] = one_abstr_rec;
   }

 return 1;
}

static int merge_abstract(char * abs_zeile, abstr_rec * abstractliste)
{
   int i,j;
   long laenge;
   
   if (abstractliste[0].abstr_n==0)
   {
     return 1;
   }
   memset(abs_zeile,0,sizeof(char) * (ABSTRACT_ZEILE_LEN+1));
   for (i=1;i<=abstractliste[0].abstr_n;i++)
   {
      memset(ex_zeile,0,sizeof(char) * (MAXARR+1)); 
      for (j=0;j<=ABSTEXT_LEN;j++)
      {
        ex_zeile[j]=abstractliste[i-1].abs_text[j];
      }
      strlimcat(abs_zeile,ex_zeile,ABSTRACT_ZEILE_LEN);
   }
   laenge = strlen(abs_zeile);
   
   for (i=0;i<=laenge;i++)
   {
     if (abs_zeile[i]=='\xfe')
     {
       abs_zeile[i] = '\n';
     }
   }
   return 1;
}


static int aued_eintragen(char * ze, author_rec * one_rec)
{
   /* ze: line with author/editor information; one_rec: record for database */
   strcpy(one_rec->au_kennziffer,"");
   if (countitem(ze,",")!=2)
   {
     sprintf(wrtxtbu,"\nProblem: format for author/editor name not "
       "correct in `%s'\n",ze);
     wrtxt(wrtxtbu);
     return 0;
   }
   rtrim(ze,';');
   extractitem(1,ze,",",ex_zeile);
   strlimcpy(one_rec->au_nachname,ex_zeile,AUNAME_LEN);
   extractitem(2,ze,",",ex_zeile);
   strlimcpy(one_rec->au_vornamen,ex_zeile,AUVORNAMEN_LEN);
   return 1;
}

static int desc_eintragen(char * ze, desc_rec * one_rec)
{
   /* keywords in the thesaurus should be addressed 0..n-1 */
   long position, anzahl_records, byte_zeiger;
   int ok;
   keylistpix_rec ix03rec; 

   fseek(ix03file,0L,SEEK_END);
   byte_zeiger = ftell(ix03file);
   
   anzahl_records = byte_zeiger / sizeof(ix03rec);
   anzahl_records--;
   
   string_in_long(ze,&position,&ok);
   if (!ok)
   {
     return 0;
   }
   if ((position < 0) || (position > anzahl_records))
   {
     return 0;
   }
   byte_zeiger = position * sizeof(ix03rec);
   fseek(ix03file,byte_zeiger,SEEK_SET);
   fread(&ix03rec,sizeof(ix03rec),1,ix03file);
   strlimcpy(one_rec->keywordsfield,ix03rec.keywordsfield,KEYWORDS_LEN);
   return 1;
}

static int j1_zeigen(void)
{
   int i;

   temptextdatei_oeffnen();
   temptextdatei_schreiben("Reference number:\n");
   temptextdatei_schreiben(one_journal_rec.kennziffer);
   temptextdatei_schreiben("\n\nAuthors:\n");
   for (i=1;i<=autorenliste[i-1].au_n;i++)
   {
      temptextdatei_schreiben(autorenliste[i-1].au_nachname);
      temptextdatei_schreiben(", ");
      temptextdatei_schreiben(autorenliste[i-1].au_vornamen);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nTitle:\n");
   strlimcpy(in_zeile,one_journal_rec.titel,MAXARR);
   wwrap(in_zeile,EDITING_LINE_LEN);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nJournal-code:\n");
   temptextdatei_schreiben(one_journal_rec.kuerzel);
   temptextdatei_schreiben("\n\nIDNr:\n");
   temptextdatei_schreiben(one_journal_rec.idnr);
   temptextdatei_schreiben("\n\nVolume:\n");
   temptextdatei_schreiben(one_journal_rec.band);
   temptextdatei_schreiben("\n\nDate of publication (YYYY/MM/DD):\n");
   temptextdatei_schreiben(one_journal_rec.jahrgang);
   temptextdatei_schreiben("/");
   temptextdatei_schreiben(one_journal_rec.monat);
   temptextdatei_schreiben("/");
   temptextdatei_schreiben(one_journal_rec.tag);
   temptextdatei_schreiben("\n\nIssue number:\n");
   temptextdatei_schreiben(one_journal_rec.issue_nummer);
   temptextdatei_schreiben("\n\nRange of pages:\n");
   temptextdatei_schreiben(one_journal_rec.seite_von);
   temptextdatei_schreiben("-");
   temptextdatei_schreiben(one_journal_rec.seite_bis);
   temptextdatei_schreiben("\n\nStatus:\n");
   temptextdatei_schreiben(one_journal_rec.status);
   temptextdatei_schreiben("\n\nKeywords:\n");
   for (i=1;i<=descliste[0].desc_n;i++)
   {
      temptextdatei_schreiben(descliste[i-1].keywordsfield);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nAbstract:\n");
   merge_abstract(abs_zeile, abstractliste);
   temptextdatei_schreiben(abs_zeile);
    
   temptextdatei_schliessen();
   vtxt(tempt_name,MESSAGE_VIEW_DATA_ENTERED);
   
   return 1;
}

static int j2_zeigen(void)
{
   int i;

   temptextdatei_oeffnen();
   temptextdatei_schreiben("Reference number:\n");
   temptextdatei_schreiben(one_journal_rec.kennziffer);
   temptextdatei_schreiben("\n\nAuthor (institutional):\n");
   temptextdatei_schreiben(one_journal_rec.instau);
   temptextdatei_schreiben("\n");
   temptextdatei_schreiben("\nTitle:\n");
   strlimcpy(in_zeile,one_journal_rec.titel,MAXARR);
   wwrap(in_zeile,EDITING_LINE_LEN);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nJournal-code:\n");
   temptextdatei_schreiben(one_journal_rec.kuerzel);
   temptextdatei_schreiben("\n\nIDNr:\n");
   temptextdatei_schreiben(one_journal_rec.idnr);
   temptextdatei_schreiben("\n\nVolume:\n");
   temptextdatei_schreiben(one_journal_rec.band);
   temptextdatei_schreiben("\n\nDate of publication (YYYY/MM/DD):\n");
   temptextdatei_schreiben(one_journal_rec.jahrgang);
   temptextdatei_schreiben("/");
   temptextdatei_schreiben(one_journal_rec.monat);
   temptextdatei_schreiben("/");
   temptextdatei_schreiben(one_journal_rec.tag);
   temptextdatei_schreiben("\n\nIssue number:\n");
   temptextdatei_schreiben(one_journal_rec.issue_nummer);
   temptextdatei_schreiben("\n\nRange of pages:\n");
   temptextdatei_schreiben(one_journal_rec.seite_von);
   temptextdatei_schreiben("-");
   temptextdatei_schreiben(one_journal_rec.seite_bis);
   temptextdatei_schreiben("\n\nStatus:\n");
   temptextdatei_schreiben(one_journal_rec.status);
   temptextdatei_schreiben("\n\nKeywords:\n");
   for (i=1;i<=descliste[0].desc_n;i++)
   {
      temptextdatei_schreiben(descliste[i-1].keywordsfield);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nAbstract:\n");
   //  Abstract zusammensetzen (bei den Einzelfragmenten handelt es sich nicht
   //  um Null-terminierte strings!)
   merge_abstract(abs_zeile, abstractliste);
   temptextdatei_schreiben(abs_zeile);
    
   temptextdatei_schliessen();
   vtxt(tempt_name,MESSAGE_VIEW_DATA_ENTERED);
   
   return 1;
}


static int b1_zeigen(void)
{
   int i;
   temptextdatei_oeffnen();
   temptextdatei_schreiben("Reference number:\n");
   temptextdatei_schreiben(one_journal_rec.kennziffer);
   temptextdatei_schreiben("\n\nEditors:\n");
   for (i=1;i<=editorenliste[i-1].au_n;i++)
   {
      temptextdatei_schreiben(editorenliste[i-1].au_nachname);
      temptextdatei_schreiben(", ");
      temptextdatei_schreiben(editorenliste[i-1].au_vornamen);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nTitle of book:\n");
   strlimcpy(in_zeile,one_buch_rec.titel_bu,MAXARR);
   wwrap(in_zeile,EDITING_LINE_LEN);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nEdition number:\n");
   /* edition number is stored in 'one_journal_rec.band' position */   
   strlimcpy(in_zeile,one_journal_rec.band,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nISBN:\n");
   strlimcpy(in_zeile,one_buch_rec.isbn,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nIDNr:\n");
   strlimcpy(in_zeile,one_journal_rec.idnr,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nPlace of publication:\n");
   strlimcpy(in_zeile,one_buch_rec.publ_ort,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nDate of publication:\n");
   strlimcpy(in_zeile,one_journal_rec.jahrgang,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nPublisher:\n");
   strlimcpy(in_zeile,one_buch_rec.verlag,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nRange of pages:\n");
   temptextdatei_schreiben(one_journal_rec.seite_von);
   temptextdatei_schreiben("-");
   temptextdatei_schreiben(one_journal_rec.seite_bis);
   temptextdatei_schreiben("\n\nStatus:\n");
   temptextdatei_schreiben(one_journal_rec.status);
   temptextdatei_schreiben("\n\nKeywords:\n");
   for (i=1;i<=descliste[0].desc_n;i++)
   {
      temptextdatei_schreiben(descliste[i-1].keywordsfield);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nAbstract:\n");
   /*  Abstract zusammensetzen (bei den Einzelfragmenten handelt es sich nicht */
   /*  um Null-terminierte strings!) */
   merge_abstract(abs_zeile, abstractliste);
   temptextdatei_schreiben(abs_zeile);
    
   temptextdatei_schliessen();
   vtxt(tempt_name,MESSAGE_VIEW_DATA_ENTERED);

  

   return 1;
}

static int b2_zeigen(void)
{
   int i;
   temptextdatei_oeffnen();
   temptextdatei_schreiben("Reference number:\n");
   temptextdatei_schreiben(one_journal_rec.kennziffer);
   temptextdatei_schreiben("\n\nAuthors:\n");
   for (i=1;i<=autorenliste[i-1].au_n;i++)
   {
      temptextdatei_schreiben(autorenliste[i-1].au_nachname);
      temptextdatei_schreiben(", ");
      temptextdatei_schreiben(autorenliste[i-1].au_vornamen);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nTitle of article:\n");
   strlimcpy(in_zeile,one_journal_rec.titel,MAXARR);
   wwrap(in_zeile,EDITING_LINE_LEN);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nEditors:\n");
   for (i=1;i<=editorenliste[i-1].au_n;i++)
   {
      temptextdatei_schreiben(editorenliste[i-1].au_nachname);
      temptextdatei_schreiben(", ");
      temptextdatei_schreiben(editorenliste[i-1].au_vornamen);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nTitle of book:\n");
   strlimcpy(in_zeile,one_buch_rec.titel_bu,MAXARR);
   wwrap(in_zeile,EDITING_LINE_LEN);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nEdition number:\n");
   /* edition number is stored in 'one_journal_rec.band' position */   
   strlimcpy(in_zeile,one_journal_rec.band,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nISBN:\n");
   strlimcpy(in_zeile,one_buch_rec.isbn,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nIDNr:\n");
   strlimcpy(in_zeile,one_journal_rec.idnr,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nPlace of publication:\n");
   strlimcpy(in_zeile,one_buch_rec.publ_ort,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nDate of publication:\n");
   strlimcpy(in_zeile,one_journal_rec.jahrgang,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nPublisher:\n");
   strlimcpy(in_zeile,one_buch_rec.verlag,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nRange of pages:\n");
   temptextdatei_schreiben(one_journal_rec.seite_von);
   temptextdatei_schreiben("-");
   temptextdatei_schreiben(one_journal_rec.seite_bis);
   temptextdatei_schreiben("\n\nStatus:\n");
   temptextdatei_schreiben(one_journal_rec.status);
   temptextdatei_schreiben("\n\nKeywords:\n");
   for (i=1;i<=descliste[0].desc_n;i++)
   {
      temptextdatei_schreiben(descliste[i-1].keywordsfield);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nAbstract:\n");
   /*  Abstract zusammensetzen (bei den Einzelfragmenten handelt es sich nicht */
   /*  um Null-terminierte strings!) */
   merge_abstract(abs_zeile, abstractliste);
   temptextdatei_schreiben(abs_zeile);
    
   temptextdatei_schliessen();
   vtxt(tempt_name,MESSAGE_VIEW_DATA_ENTERED);
   return 1;
}

static int b3_zeigen(void)
{
   int i;
   temptextdatei_oeffnen();
   temptextdatei_schreiben("Reference number:\n");
   temptextdatei_schreiben(one_journal_rec.kennziffer);
   temptextdatei_schreiben("\n\nEditor (institutional):\n");
   temptextdatei_schreiben(one_buch_rec.insted);
   temptextdatei_schreiben("\n");
   temptextdatei_schreiben("\nTitle of book:\n");
   strlimcpy(in_zeile,one_buch_rec.titel_bu,MAXARR);
   wwrap(in_zeile,EDITING_LINE_LEN);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nEdition number:\n");
   /* edition number is stored in 'one_journal_rec.band' position */   
   strlimcpy(in_zeile,one_journal_rec.band,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nISBN:\n");
   strlimcpy(in_zeile,one_buch_rec.isbn,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nIDNr:\n");
   strlimcpy(in_zeile,one_journal_rec.idnr,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nPlace of publication:\n");
   strlimcpy(in_zeile,one_buch_rec.publ_ort,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nDate of publication:\n");
   strlimcpy(in_zeile,one_journal_rec.jahrgang,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nPublisher:\n");
   strlimcpy(in_zeile,one_buch_rec.verlag,MAXARR);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nRange of pages:\n");
   temptextdatei_schreiben(one_journal_rec.seite_von);
   temptextdatei_schreiben("-");
   temptextdatei_schreiben(one_journal_rec.seite_bis);
   temptextdatei_schreiben("\n\nStatus:\n");
   temptextdatei_schreiben(one_journal_rec.status);
   temptextdatei_schreiben("\n\nKeywords:\n");
   for (i=1;i<=descliste[0].desc_n;i++)
   {
      temptextdatei_schreiben(descliste[i-1].keywordsfield);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nAbstract:\n");
   /*  Abstract zusammensetzen (bei den Einzelfragmenten handelt es sich nicht */
   /*  um Null-terminierte strings!) */
   merge_abstract(abs_zeile, abstractliste);
   temptextdatei_schreiben(abs_zeile);
    
   temptextdatei_schliessen();
   vtxt(tempt_name,MESSAGE_VIEW_DATA_ENTERED);

  

   return 1;
}

static int m1_zeigen(void)
{
   int i;

   temptextdatei_oeffnen();
   temptextdatei_schreiben("Reference number:\n");
   temptextdatei_schreiben(one_journal_rec.kennziffer);
   temptextdatei_schreiben("\n\nAuthors:\n");
   for (i=1;i<=autorenliste[i-1].au_n;i++)
   {
      temptextdatei_schreiben(autorenliste[i-1].au_nachname);
      temptextdatei_schreiben(", ");
      temptextdatei_schreiben(autorenliste[i-1].au_vornamen);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nTitle:\n");
   strlimcpy(in_zeile,one_journal_rec.titel,MAXARR);
   wwrap(in_zeile,EDITING_LINE_LEN);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nHowpublished:\n");
   temptextdatei_schreiben(one_journal_rec.howpublished);
   temptextdatei_schreiben("\n\nIDNr:\n");
   temptextdatei_schreiben(one_journal_rec.idnr);
   temptextdatei_schreiben("\n\nDate of publication (YYYY/MM/DD):\n");
   temptextdatei_schreiben(one_journal_rec.jahrgang);
   temptextdatei_schreiben("/");
   temptextdatei_schreiben(one_journal_rec.monat);
   temptextdatei_schreiben("/");
   temptextdatei_schreiben(one_journal_rec.tag);
   temptextdatei_schreiben("\n\nRange of pages:\n");
   temptextdatei_schreiben(one_journal_rec.seite_von);
   temptextdatei_schreiben("-");
   temptextdatei_schreiben(one_journal_rec.seite_bis);
   temptextdatei_schreiben("\n\nStatus:\n");
   temptextdatei_schreiben(one_journal_rec.status);
   temptextdatei_schreiben("\n\nKeywords:\n");
   for (i=1;i<=descliste[0].desc_n;i++)
   {
      temptextdatei_schreiben(descliste[i-1].keywordsfield);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nAbstract:\n");
   merge_abstract(abs_zeile, abstractliste);
   temptextdatei_schreiben(abs_zeile);
    
   temptextdatei_schliessen();
   vtxt(tempt_name,MESSAGE_VIEW_DATA_ENTERED);
   
   return 1;
}

static int m2_zeigen(void)
{
   // in_zeile MAXARR
   int i;

   temptextdatei_oeffnen();
   temptextdatei_schreiben("Reference number:\n");
   temptextdatei_schreiben(one_journal_rec.kennziffer);
   temptextdatei_schreiben("\n\nAuthor (institutional):\n");
   temptextdatei_schreiben(one_journal_rec.instau);
   temptextdatei_schreiben("\n");
   temptextdatei_schreiben("\nTitle:\n");
   strlimcpy(in_zeile,one_journal_rec.titel,MAXARR);
   wwrap(in_zeile,EDITING_LINE_LEN);
   temptextdatei_schreiben(in_zeile);
   temptextdatei_schreiben("\n\nHowpublished:\n");
   temptextdatei_schreiben(one_journal_rec.howpublished);
   temptextdatei_schreiben("\n\nIDNr:\n");
   temptextdatei_schreiben(one_journal_rec.idnr);
   temptextdatei_schreiben("\n\nDate of publication (YYYY/MM/DD):\n");
   temptextdatei_schreiben(one_journal_rec.jahrgang);
   temptextdatei_schreiben("/");
   temptextdatei_schreiben(one_journal_rec.monat);
   temptextdatei_schreiben("/");
   temptextdatei_schreiben(one_journal_rec.tag);
   temptextdatei_schreiben("\n\nRange of pages:\n");
   temptextdatei_schreiben(one_journal_rec.seite_von);
   temptextdatei_schreiben("-");
   temptextdatei_schreiben(one_journal_rec.seite_bis);
   temptextdatei_schreiben("\n\nStatus:\n");
   temptextdatei_schreiben(one_journal_rec.status);
   temptextdatei_schreiben("\n\nKeywords:\n");
   for (i=1;i<=descliste[0].desc_n;i++)
   {
      temptextdatei_schreiben(descliste[i-1].keywordsfield);
      temptextdatei_schreiben("\n");
   }
   temptextdatei_schreiben("\nAbstract:\n");
   merge_abstract(abs_zeile, abstractliste);
   temptextdatei_schreiben(abs_zeile);
    
   temptextdatei_schliessen();
   vtxt(tempt_name,MESSAGE_VIEW_DATA_ENTERED);
   
   return 1;
}



static int j1m1_speichern(char * dtyp)
{
   refspix_rec ix01_local;
   abstrpix_rec ix04_local;
   long ix_pos;
   long au_rptr, desc_rptr;
   /* 1: record with reference number is already stored in database */
   int is_in_journal, is_in_abstract;

   /* check if document type of 'old' record in database is of type j1 */
   if (dokumenttyp_pruefen(one_journal_rec.kennziffer,dtyp)==0)
   {
     return 0;
   }
   one_journal_rec.in_use = 1;

   read_ix01(journal_pix_name);
    ix_pos = locate_ix01(one_journal_rec.kennziffer,&ix01_local);
   close_ix01();
   /* printf("\n----%li\n",ix_pos); */
   if (ix_pos < 0)
   {
     is_in_journal = 0;
     au_rptr = -1; /* no author names stored */
     desc_rptr = -1; /* no keywords stored */
   }
   else
   {
     is_in_journal = 1;
     au_rptr = ix01_local.autorjl_rptr;
     desc_rptr = ix01_local.desc_rptr;
   }
   read_ix04(abstr_pix_name);
    ix_pos = locate_ix04(one_journal_rec.kennziffer,&ix04_local);
   close_ix04();

   if (ix_pos < 0)
   {
     is_in_abstract = 0; 
   }
   else
   {
     is_in_abstract = 1;
   }
   if ((is_in_abstract==1) && (is_in_journal==0))
   {
      sprintf(wrtxtbu,"\n(Warning: Record number appears in `%s',\n"
        "but not in `%s':\n"
        "inconsistency in database)",
        abstr_pix_name,journal_pix_name);
      wrtxt(wrtxtbu);
      return 0;
   }
   /* Writing data into database starts here */ 
   auedstring_schreiben(autorjl_name,&au_rptr,autorenliste);
   ix01rec.autorjl_rptr = au_rptr;
   descstring_schreiben(desc_name,&desc_rptr);
   ix01rec.desc_rptr = desc_rptr;
   journal_rec_und_index_schreiben();
   if (abstractliste[0].abstr_n > 0)
   {
     abstract_und_index_schreiben(one_journal_rec.kennziffer);
   }
   sprintf(wrtxtbu,"Record `%s' transferred into database",
     one_journal_rec.kennziffer);
   protokollieren(wrtxtbu); 
   return 1;
}


static int j2m2_speichern(char * dtyp)
{
   refspix_rec ix01_local;
   abstrpix_rec ix04_local;
   long ix_pos;
   long au_rptr, desc_rptr;
   /* 1: record with reference number is already stored in database */
   int is_in_journal, is_in_abstract;

   /* check if document type of 'old' record in database is of type j2 */
   if (dokumenttyp_pruefen(one_journal_rec.kennziffer,dtyp)==0)
   {
     return 0;
   }
   one_journal_rec.in_use = 1;

   read_ix01(journal_pix_name);
    ix_pos = locate_ix01(one_journal_rec.kennziffer,&ix01_local);
   close_ix01();
   /* printf("\n----%li\n",ix_pos); */
   if (ix_pos < 0)
   {
     is_in_journal = 0;
     au_rptr = -1; /* no author names stored */
     desc_rptr = -1; /* no keywords stored */
   }
   else
   {
     is_in_journal = 1;
     /* au_rptr = ix01_local.autorjl_rptr; */
     au_rptr = -1;   /* this document type does not know personal authors! */
     desc_rptr = ix01_local.desc_rptr;
   }
   read_ix04(abstr_pix_name);
    ix_pos = locate_ix04(one_journal_rec.kennziffer,&ix04_local);
   close_ix04();

   if (ix_pos < 0)
   {
     is_in_abstract = 0; 
   }
   else
   {
     is_in_abstract = 1;
   }
   if ((is_in_abstract==1) && (is_in_journal==0))
   {
      sprintf(wrtxtbu,"\n(Warning: Record number appears in `%s',\n"
        "but not in `%s':\n"
        "inconsistency in database)",
        abstr_pix_name,journal_pix_name);
      wrtxt(wrtxtbu);
      return 0;
   }
   /* Writing data into database starts here */ 
   /* auedstring_schreiben(autorjl_name,&au_rptr,autorenliste); */
   ix01rec.autorjl_rptr = au_rptr; /* always -1! */
   descstring_schreiben(desc_name,&desc_rptr);
   ix01rec.desc_rptr = desc_rptr;
   journal_rec_und_index_schreiben();
   if (abstractliste[0].abstr_n > 0)
   {
     abstract_und_index_schreiben(one_journal_rec.kennziffer);
   }
   sprintf(wrtxtbu,"Record `%s' transferred into database",
     one_journal_rec.kennziffer);
   protokollieren(wrtxtbu); 
   return 1;
}



static int b1_speichern(void)
{
   refspix_rec ix01_local;
   abstrpix_rec ix04_local;
   long ix_pos;
   long ed_rptr, desc_rptr, buch_rptr;
   /* 1: record with reference number is already stored in database */
   int is_in_journal, is_in_abstract;

   /* check if document type of 'old' record in databbase is of type b1 */
   if (dokumenttyp_pruefen(one_journal_rec.kennziffer,"b1")==0)
   {
     return 0;
   }
   one_journal_rec.in_use = 1;
   one_buch_rec.in_use_bu = 1;

   read_ix01(journal_pix_name);
    ix_pos = locate_ix01(one_journal_rec.kennziffer,&ix01_local);
   close_ix01();
   if (ix_pos < 0)
   {
     is_in_journal = 0;
     buch_rptr = -1; /* no book record stored */
     ed_rptr = -1; /* no editor names stored */
     desc_rptr = -1; /* no keywords stored */
   }
   else
   {
     is_in_journal = 1;
     buch_rptr = ix01_local.buch_rptr;
     ed_rptr = ix01_local.autorbu_rptr;
     desc_rptr = ix01_local.desc_rptr;
   }
   read_ix04(abstr_pix_name);
    ix_pos = locate_ix04(one_journal_rec.kennziffer,&ix04_local);
   close_ix04();

   if (ix_pos < 0)
   {
     is_in_abstract = 0; 
   }
   else
   {
     is_in_abstract = 1;
   }
   if ((is_in_abstract==1) && (is_in_journal==0))
   {
      sprintf(wrtxtbu,"\n(Warning: Record number appears in `%s',\n"
        "but not in `%s':\n"
        "inconsistency in database)",
        abstr_pix_name,journal_pix_name);
      wrtxt(wrtxtbu);
      return 0;
   }
   /* Writing data into database starts here */ 
   auedstring_schreiben(autorbu_name,&ed_rptr,editorenliste);
   ix01rec.autorbu_rptr = ed_rptr;
   descstring_schreiben(desc_name,&desc_rptr);
   ix01rec.desc_rptr = desc_rptr;
   buch_rec_schreiben(&buch_rptr); 
   ix01rec.buch_rptr = buch_rptr;
   journal_rec_und_index_schreiben();
   if (abstractliste[0].abstr_n > 0)
   {
     abstract_und_index_schreiben(one_journal_rec.kennziffer);
   }
   sprintf(wrtxtbu,"Record `%s' transferred into database",
     one_journal_rec.kennziffer);
   protokollieren(wrtxtbu); 

   
   return 1;
}

static int b2_speichern(void)
{
   refspix_rec ix01_local;
   abstrpix_rec ix04_local;
   long ix_pos;
   long au_rptr, ed_rptr, desc_rptr, buch_rptr;
   /* 1: record with reference number is already stored in database */
   int is_in_journal, is_in_abstract;

   /* check if document type of 'old' record in databbase is of type j1 */
   if (dokumenttyp_pruefen(one_journal_rec.kennziffer,"b2")==0)
   {
     return 0;
   }
   one_journal_rec.in_use = 1;
   one_buch_rec.in_use_bu = 1;

   read_ix01(journal_pix_name);
    ix_pos = locate_ix01(one_journal_rec.kennziffer,&ix01_local);
   close_ix01();
   if (ix_pos < 0)
   {
     is_in_journal = 0;
     buch_rptr = -1; /* no book record stored */
     au_rptr = -1; /* no author names stored */
     ed_rptr = -1; /* no editor names stored */
     desc_rptr = -1; /* no keywords stored */
   }
   else
   {
     is_in_journal = 1;
     buch_rptr = ix01_local.buch_rptr;
     au_rptr = ix01_local.autorjl_rptr;
     ed_rptr = ix01_local.autorbu_rptr;
     desc_rptr = ix01_local.desc_rptr;
   }
   read_ix04(abstr_pix_name);
    ix_pos = locate_ix04(one_journal_rec.kennziffer,&ix04_local);
   close_ix04();

   if (ix_pos < 0)
   {
     is_in_abstract = 0; 
   }
   else
   {
     is_in_abstract = 1;
   }
   if ((is_in_abstract==1) && (is_in_journal==0))
   {
      sprintf(wrtxtbu,"\n(Warning: Record number appears in `%s',\n"
        "but not in `%s':\n"
        "inconsistency in database)",
        abstr_pix_name,journal_pix_name);
      wrtxt(wrtxtbu);
      return 0;
   }
   /* Writing data into database starts here */ 
   auedstring_schreiben(autorjl_name,&au_rptr,autorenliste);
   ix01rec.autorjl_rptr = au_rptr;
   auedstring_schreiben(autorbu_name,&ed_rptr,editorenliste);
   ix01rec.autorbu_rptr = ed_rptr;
   descstring_schreiben(desc_name,&desc_rptr);
   ix01rec.desc_rptr = desc_rptr;
   buch_rec_schreiben(&buch_rptr); 
   ix01rec.buch_rptr = buch_rptr;
   journal_rec_und_index_schreiben();
   if (abstractliste[0].abstr_n > 0)
   {
     abstract_und_index_schreiben(one_journal_rec.kennziffer);
   }
   sprintf(wrtxtbu,"Record `%s' transferred into database",
     one_journal_rec.kennziffer);
   protokollieren(wrtxtbu); 
    
   return 1;
}


static int b3_speichern(void)
{
   refspix_rec ix01_local;
   abstrpix_rec ix04_local;
   long ix_pos;
   long ed_rptr, desc_rptr, buch_rptr;
   /* 1: record with reference number is already stored in database */
   int is_in_journal, is_in_abstract;

   /* check if document type of 'old' record in databbase is of type b1 */
   if (dokumenttyp_pruefen(one_journal_rec.kennziffer,"b3")==0)
   {
     return 0;
   }
   one_journal_rec.in_use = 1;
   one_buch_rec.in_use_bu = 1;

   read_ix01(journal_pix_name);
    ix_pos = locate_ix01(one_journal_rec.kennziffer,&ix01_local);
   close_ix01();
   if (ix_pos < 0)
   {
     is_in_journal = 0;
     buch_rptr = -1; /* no book record stored */
     ed_rptr = -1; /* no editor names stored */
     desc_rptr = -1; /* no keywords stored */
   }
   else
   {
     is_in_journal = 1;
     buch_rptr = ix01_local.buch_rptr;
     /* ed_rptr = ix01_local.autorbu_rptr; */
     ed_rptr = -1; /* this document type does not know personal editors! */
     desc_rptr = ix01_local.desc_rptr;
   }
   read_ix04(abstr_pix_name);
    ix_pos = locate_ix04(one_journal_rec.kennziffer,&ix04_local);
   close_ix04();

   if (ix_pos < 0)
   {
     is_in_abstract = 0; 
   }
   else
   {
     is_in_abstract = 1;
   }
   if ((is_in_abstract==1) && (is_in_journal==0))
   {
      sprintf(wrtxtbu,"\n(Warning: Record number appears in `%s',\n"
        "but not in `%s':\n"
        "inconsistency in database)",
        abstr_pix_name,journal_pix_name);
      wrtxt(wrtxtbu);
      return 0;
   }
   /* Writing data into database starts here */ 
   /* auedstring_schreiben(autorbu_name,&ed_rptr,editorenliste); */
   ix01rec.autorbu_rptr = ed_rptr; /* always -1! */
   descstring_schreiben(desc_name,&desc_rptr);
   ix01rec.desc_rptr = desc_rptr;
   buch_rec_schreiben(&buch_rptr); 
   ix01rec.buch_rptr = buch_rptr;
   journal_rec_und_index_schreiben();
   if (abstractliste[0].abstr_n > 0)
   {
     abstract_und_index_schreiben(one_journal_rec.kennziffer);
   }
   sprintf(wrtxtbu,"Record `%s' transferred into database",
     one_journal_rec.kennziffer);
   protokollieren(wrtxtbu); 
   return 1;
}



/* 'dokumenttyp_pruefen()' checks if document-type of the record in text file 
   is identical with document type of the same record in database. Returns 1
   if document types do not differ or if 'kennziff' refers to a new record, 0
   if there is a difference. */
static int dokumenttyp_pruefen(char * kennziff, char * dokumenttyp)
{
   long ix_pos, byte_zeiger;
   refspix_rec ix01_local;
   journal_rec journal_local;
   FILE * datfl;

   read_ix01(journal_pix_name);
    ix_pos = locate_ix01(kennziff,&ix01_local);
   close_ix01();
   if (ix_pos ==-1)
   {
      wrtxt("\n(This is a new record)\n");
      return 1;
   }
   else
   {
      byte_zeiger = ix01_local.journal_rptr * sizeof(journal_local);
      if ((datfl = fopen(journal_name,"rb"))==0)
      {
         fprintf(stderr,"\nError: cannot open `%s'\n",journal_name);
         exit(1);
      }
      fseek(datfl,byte_zeiger,SEEK_SET);
      fread(&journal_local,sizeof(journal_local),1,datfl);
      fclose(datfl);
      if (strcmp(dokumenttyp,journal_local.reftyp)==0)
      {
         wrtxt("\n(Record with identical reference number/document type already in database)\n");
         if (do_overwrite_yn())
         {
            return 1;
         }
         else
         {
            return 0;
         }
      }
      else
      {
         wrtxt("\n(Warning: Document type in text file differs from "
           "record in database)\n");
         return 0;
      }
   }
}


static void auedstring_schreiben(
           const char * au_datei_name,
           long * aued_rptr,
           author_rec liste[]
                         )
{
    FILE * datfl;
    long rec_zeiger, byte_zeiger;
    author_rec aued_rec;
    int i; 
    /* int anz_autoren_string;  wird zu: */
    int anz_autoren_liste; /* n of authors in the new list */
    int anz_autoren_datei; /* n of authors in the old list to be overwritten */

    if (* aued_rptr>=0) /* author names already in database */
    {
       if((datfl=fopen(au_datei_name,"rb"))==NULL)
       {
           fprintf(stderr,"\nError: Cannot open %s\n",au_datei_name);
           exit(1);
       }
       fseek(datfl,(long) sizeof(author_rec)*(* aued_rptr),SEEK_SET);
       fread(&aued_rec,sizeof(author_rec),1,datfl);
       anz_autoren_datei=aued_rec.au_n;
       fclose(datfl);
    } else anz_autoren_datei=0;
    anz_autoren_liste = liste[0].au_n;

    if((datfl=fopen(au_datei_name,"r+b"))==NULL)
    {
        fprintf(stderr,"\nError Cannot open %s\n",au_datei_name);
        exit(1);
    }

    /* thist is a new database record, create 
       new list of authors: go to end of file */
    if (* aued_rptr==-1)
    {
        fseek(datfl,0L,SEEK_END);
        byte_zeiger=ftell(datfl);
        rec_zeiger = byte_zeiger/sizeof(author_rec);
    }
   /* old list of authors already in file: overwrite with 0s 
      including in_use_au */
    else
    {
        memset(&aued_rec,0,sizeof(aued_rec));
        fseek(datfl,(long) sizeof(author_rec)*(* aued_rptr),SEEK_SET);
        for (i=1;i<=anz_autoren_datei;i++)
        {
           if (fwrite(&aued_rec,sizeof(aued_rec),1,datfl) < 1) schreibfehler();
        }
        /* put file pointer to new position in au_datei_name */
        if (anz_autoren_liste > anz_autoren_datei)
        {
             /* case: new list of authors is longer: put file fointer to 
                end of file */
             fseek(datfl,0L,SEEK_END);
             byte_zeiger=ftell(datfl);
             rec_zeiger = byte_zeiger/sizeof(author_rec);
        }
        else
        {
             /* case: new list is not longer: put file pointer to same
                position, where old list started */
             fseek(datfl,(long) sizeof(author_rec)*(* aued_rptr),SEEK_SET);
             byte_zeiger = ftell(datfl);
             rec_zeiger = byte_zeiger/sizeof(author_rec);
        }
     }

    for (i=1;i<=anz_autoren_liste;i++)
    {
        aued_rec = liste[i-1];
        if (fwrite(&aued_rec,sizeof(aued_rec),1,datfl) < 1) schreibfehler();
    }
    fclose(datfl);
    * aued_rptr = rec_zeiger;

    return;
}



static void descstring_schreiben( const char * desc_datei_name,
            long * desc_rptr
                           )
{
    FILE * datfl;
    long rec_zeiger, byte_zeiger;
    desc_rec dr;
    int i;
    /* int anz_desc_string; wird zu: */
    int anz_desc_liste; /* n of keywords in the new list */                   
    int anz_desc_datei; /* n of keywords in the old list to be overwritten */

    memset(&dr,0,sizeof(dr));

    if (* desc_rptr>=0) /* keywords already in database */
    {
       if((datfl=fopen(desc_datei_name,"rb"))==NULL)
       {
           fprintf(stderr,"\nError: Cannot open %s\n",desc_datei_name);
           exit(1);
       }
       fseek(datfl,(long) sizeof(dr)*(* desc_rptr),SEEK_SET);
       fread(&dr,sizeof(dr),1,datfl);
       anz_desc_datei=dr.desc_n;
       fclose(datfl);
    } else anz_desc_datei=0;
    anz_desc_liste = descliste[0].desc_n;

    if((datfl=fopen(desc_datei_name,"r+b"))==NULL)
    {
        fprintf(stderr,"\nError Cannot open %s\n",desc_datei_name);
        exit(1);
    }

    /* thist is a new database record, create 
       new list of keywords: go to end of file */
    if (* desc_rptr==-1)
    {
        fseek(datfl,0L,SEEK_END);
        byte_zeiger=ftell(datfl);
        rec_zeiger = byte_zeiger/sizeof(dr);
    }
    else
   /* old list of keywords already in file: overwrite with 0s 
      including in_use */
    {
        memset(&dr,0,sizeof(dr));
        fseek(datfl,(long) sizeof(dr)*(* desc_rptr),SEEK_SET);
        for (i=1;i<=anz_desc_datei;i++)
        {
           if (fwrite(&dr,sizeof(dr),1,datfl) < 1) schreibfehler();
        }
        /* put file pointer to new position in desc_datei_name */
        if (anz_desc_liste > anz_desc_datei)
        {
             /* case: new list of keywords is longer: put file fointer to 
                end of file */
             fseek(datfl,0L,SEEK_END);
             byte_zeiger=ftell(datfl);
             rec_zeiger = byte_zeiger/sizeof(dr);
        }
        else
        {
             /* case: new list is not longer: put file pointer to same
                position, where old list started */
             fseek(datfl,(long) sizeof(dr)*(* desc_rptr),SEEK_SET);
             byte_zeiger = ftell(datfl);
             rec_zeiger = byte_zeiger/sizeof(dr);
        }
    }

    for (i=1;i<=anz_desc_liste;i++)
    {
        dr = descliste[i-1];  
        if (fwrite(&dr,sizeof(dr),1,datfl) < 1) schreibfehler();
    }
    fclose(datfl);
    /* in Zukunft entfernen - vermutlich ueberfluessig: das Programm erwartet
     * immer mindestens eine keywords-Eintragung! */ 
    if (anz_desc_liste == 0)
    {
       * desc_rptr = -1;
    }
    else
    {
       * desc_rptr = rec_zeiger;
    }

    return;
}

static void buch_rec_schreiben(long * bu_rptr)
{
  FILE * datfl;
  long byte_zeiger, rec_zeiger /*ix01_zeiger*/ ;

  if ((datfl=fopen(book_name,"r+b"))==NULL)
  {
      fprintf(stderr,"Cannot write into %s",book_name);
      exit(1);
  }
  if (* bu_rptr==-1)
  {
      /* enter a new record */
      fseek(datfl,0L,SEEK_END);
      byte_zeiger=ftell(datfl);
      rec_zeiger=byte_zeiger/sizeof(one_buch_rec);
      /* ix01rec.buch_rptr=rec_zeiger; */
      * bu_rptr = rec_zeiger;
  }
  else
  {
      /* write record into previous position */
      rec_zeiger=(* bu_rptr);
      byte_zeiger=rec_zeiger*sizeof(one_buch_rec);
      /* bu_rptr needs not to be changed */
  }
  fseek(datfl,byte_zeiger,SEEK_SET);
  if (fwrite(&one_buch_rec,sizeof(one_buch_rec),1,datfl) < 1) schreibfehler();
  fclose(datfl);
}


static int journal_rec_und_index_schreiben(void)
{
   FILE * datfl;
   FILE * tmpix01;
   FILE * ix01;
   long rec_zeiger, ix01_zeiger;
   refspix_rec ix01_local;

   long byte_zeiger;

   ix01_zeiger = -1;  /* initialize for formal reasons */

   if ((datfl=fopen(journal_name,"r+b"))==NULL)
   {
        fprintf(stderr,"\nError: Cannot write into %s\n",journal_name);
        exit(1);
   }

   if (filesize(journal_pix_name)<=0)
   {
        ix01_zeiger=-1;
        rec_zeiger=-1;
   } else
   {
       read_ix01(journal_pix_name);
       ix01_zeiger = locate_ix01(one_journal_rec.kennziffer,&ix01_local);
       if (ix01_zeiger>=0)
       {
          rec_zeiger=ix01_local.journal_rptr;
       }
       else 
       {
          rec_zeiger=-1;
       }
       close_ix01();
   }

   if (ix01_zeiger==-1) /* this is a new record in database */
   {
       fseek(datfl,0L,SEEK_END);
       byte_zeiger = ftell(datfl);
       rec_zeiger = byte_zeiger/sizeof(journal_rec);

        
       ix01rec.journal_rptr=rec_zeiger; 
       /* create temporary ix01-type file */
       if ((tmpix01=fopen(tmp01_ix_name,"wb"))== NULL)
       {
           fprintf(stderr,"\nError: Cannot open/create `%s'\n",tmp01_ix_name);
           exit(1);
       }

       if (fwrite(&ix01rec,sizeof(ix01rec),1,tmpix01) < 1) schreibfehler();
       fclose(tmpix01);
   } 
   else /* this is NOT a new record in database */
   {
       if ((ix01=fopen(journal_pix_name,"r+b"))==NULL)
       {
          fprintf(stderr,"\nError: unable to update `%s'\n",journal_pix_name);
          exit(1);
       }
       /* make index entry actual */
       ix01rec.journal_rptr=rec_zeiger; 
       fseek(ix01,ix01_zeiger * sizeof(ix01rec),SEEK_SET);
       if (fwrite(&ix01rec,sizeof(ix01rec),1,ix01) < 1) schreibfehler();
       fclose(ix01);

       byte_zeiger=rec_zeiger * sizeof(journal_rec);
       fseek(datfl,byte_zeiger,SEEK_SET);
   }
   if (fwrite(&one_journal_rec, sizeof(journal_rec), 1, datfl) < 1) schreibfehler();
   fclose(datfl);

   if (isfile(tmp01_ix_name))
   {
      if (filesize(journal_pix_name)==0)
      {
         remove(journal_pix_name);
         rename(tmp01_ix_name,journal_pix_name);
         wrtxt("\n(Main index file created)");
      }
      else if (ok_appix01(journal_pix_name,tmp01_ix_name))
      {
         appendix01(journal_pix_name,tmp01_ix_name);
         wrtxt("\n(New keys appended to main index file)");
         remove(tmp01_ix_name);
      }
      else
      {
         mrgeix01(journal_pix_name,tmp01_ix_name,dest01_ix_name);
         remove(journal_pix_name);remove(tmp01_ix_name);
         rename(dest01_ix_name,journal_pix_name);
         wrtxt("\n(Main index file merged)");
      }
   }
   return 1;
}

static int abstract_und_index_schreiben(char * kennziffer)
{
   int i,j, anzahl_bloecke, anzahl_loeschen, lauf;
   long byte_zeiger, rec_zeiger;   /* position in Dat-file */
   long pos_zeiger;                /* position in index file */
   FILE * fpab01ix;
   FILE * fpabsdat; 

   anzahl_bloecke = abstractliste[0].abstr_n;
   if (!isfile(abstr_dat_name))
   {
     if ((fpabsdat=fopen(abstr_dat_name,"wb"))==NULL)
     {
         fprintf(stderr,"\nError: Cannot create `%s'\n",
                 abstr_dat_name);
         exit(1);
     }
   } else
   {
     if ((fpabsdat=fopen(abstr_dat_name,"r+b"))==NULL)
     {
         fprintf(stderr,"\nError: Cannot write into `%s'\n",
                 abstr_dat_name);
         exit(1);
     }
   }
   if (!isfile(abstr_pix_name))
   {
     if ((ix04file=fopen(abstr_pix_name,"wb"))==NULL)
     {
         fprintf(stderr,"\nError: Cannot create `%s'\n",
                 abstr_pix_name);
         exit(1);
     }
     fclose(ix04file);
   }
   /* Index zum lesen oeffnen etc.. */
   memset(&ix04rec,0,sizeof(ix04rec));

   read_ix04(abstr_pix_name);
   pos_zeiger = locate_ix04(kennziffer,&ix04rec);
   close_ix04();



   /* New record is appended to database */
   if (pos_zeiger==-1)
   {
       fseek(fpabsdat,0L,SEEK_END);
       byte_zeiger=ftell(fpabsdat);
       rec_zeiger = byte_zeiger/sizeof(one_abstr_rec);

       strcpy(ix04rec.kennziffer,kennziffer);
       ix04rec.abstr_rptr = rec_zeiger;

       if ((fpab01ix=fopen(tmp04_ix_name,"wb"))==NULL)
       {
          fprintf(stderr,"\nError: cannot create `%s'\n",tmp04_ix_name);
          exit(1);
       }
       if (fwrite(&ix04rec,sizeof(ix04rec),1,fpab01ix) < 1) schreibfehler();
       fclose(fpab01ix);
   }
   else
   {
       /* record already exists */
       rec_zeiger = ix04rec.abstr_rptr;
       byte_zeiger = rec_zeiger * sizeof(one_abstr_rec);
       fseek(fpabsdat,byte_zeiger,SEEK_SET);
       fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);
       anzahl_loeschen = one_abstr_rec.abstr_n;
       fseek(fpabsdat,byte_zeiger,SEEK_SET);

        memset(&one_abstr_rec,0,sizeof(one_abstr_rec));
        for (lauf=1;lauf<=anzahl_loeschen;lauf++)
        {
           if (fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat) < 1) schreibfehler();
        }

         /* record already exists, however, more blocks are required than
            previously */
       if (anzahl_bloecke > anzahl_loeschen)
       {
          fseek(fpabsdat,0L,SEEK_END);
       }
       else
       {
          fseek(fpabsdat,byte_zeiger,SEEK_SET);
       }
       byte_zeiger=ftell(fpabsdat);
       rec_zeiger = byte_zeiger/sizeof(one_abstr_rec);
       if (anzahl_bloecke > anzahl_loeschen)
       {
         read_write_ix04(abstr_pix_name);
         fseek(ix04file,(long) pos_zeiger * sizeof(ix04rec),SEEK_SET);
         strcpy(ix04rec.kennziffer,kennziffer);
         ix04rec.abstr_rptr = rec_zeiger;
         if (fwrite(&ix04rec,sizeof(ix04rec),1,ix04file) < 1) schreibfehler();
         close_ix04();
       }
   }


   j = 0; /* Adresse in abstract */
   for (i=1;i<=anzahl_bloecke;i++)
   {
        memset(&one_abstr_rec,'\0',sizeof(one_abstr_rec));
        one_abstr_rec = abstractliste[i-1]; 
        if (fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat) < 1) schreibfehler();
   }
   fclose(fpabsdat);


   if (isfile(tmp04_ix_name))
   {
     /* Beginn Einfuegung vom 20.06.1997 */
     if (filesize(abstr_pix_name)==0)
     {
       remove(abstr_pix_name);
       rename(tmp04_ix_name,abstr_pix_name);
       wrtxt("\n(Index file for abstracts created)");
     }
     /* Ende Einfuegung vom 20.06.1997 nach 'else' in folg. Zeile */
     else if (ok_appix04(abstr_pix_name,tmp04_ix_name))
     {
       appendix04(abstr_pix_name,tmp04_ix_name);
       remove(tmp04_ix_name);
       wrtxt("\n(Index file for abstracts appended)");
     }
     else
     {
       mrgeix04(abstr_pix_name,tmp04_ix_name,dest04_ix_name);
       remove(abstr_pix_name);remove(tmp04_ix_name);
       rename(dest04_ix_name,abstr_pix_name);
       wrtxt("\n(Index file for abstracts merged)");
     }
   }
   return 1;
}
