/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.jmakepdfx;

import com.dickimawbooks.jmakepdfx.Jmakepdfx;
import com.dickimawbooks.jmakepdfx.JpdfxResources;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class ErrorDialog
extends JDialog
implements ActionListener {
    private JTextArea messageArea = this.createMessageArea();
    private JTextArea stackTraceArea = this.createMessageArea();
    private JTabbedPane tabbedPane = new JTabbedPane();

    public ErrorDialog() {
        super((Frame)null, Jmakepdfx.getLabelWithAlt("error.title", "Error"), true);
        this.tabbedPane.addTab(Jmakepdfx.getLabelWithAlt("error.message", "Error Message"), new JScrollPane(this.messageArea));
        this.tabbedPane.setMnemonicAt(this.tabbedPane.getTabCount() - 1, Jmakepdfx.getMnemonic("error.message"));
        this.tabbedPane.addTab(Jmakepdfx.getLabelWithAlt("error.stacktrace", "Stack Trace"), new JScrollPane(this.stackTraceArea));
        this.tabbedPane.setMnemonicAt(this.tabbedPane.getTabCount() - 1, Jmakepdfx.getMnemonic("error.stacktrace"));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.add(JpdfxResources.createCloseButton(this));
        jPanel.add(JpdfxResources.createActionButton(Jmakepdfx.getLabel("button.copy"), Jmakepdfx.getMnemonic("button.copy"), "copy", this, KeyStroke.getKeyStroke(67, 1), Jmakepdfx.getLabel("button.copy.tooltip")));
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JTextArea createMessageArea() {
        JTextArea jTextArea = new JTextArea(8, 30);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        return jTextArea;
    }

    public void display(String string) {
        this.display(string, null);
    }

    public void display(String string, Exception exception) {
        this.messageArea.setText(string);
        String string2 = "";
        if (exception != null) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                string2 = string2 + stackTraceElementArray.toString() + "\n";
            }
        }
        this.stackTraceArea.setText(string2);
        this.tabbedPane.setSelectedIndex(0);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("copy")) {
            int n = this.tabbedPane.getSelectedIndex();
            if (n == 0) {
                String string2 = this.messageArea.getText();
            } else {
                String string3 = this.stackTraceArea.getText();
            }
        } else if (string.equals("okay")) {
            this.setVisible(false);
        }
    }
}

