/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.FixedUnit;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXGlue;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserDimension;
import java.io.IOException;

public class DimenRegister
extends NumericRegister
implements TeXDimension {
    private TeXGlue dimension;

    public DimenRegister(String string) {
        this(string, 0.0f, FixedUnit.SP);
    }

    public DimenRegister(String string, float f, TeXUnit teXUnit) {
        this(string, new TeXGlue());
        try {
            this.dimension.setDimension(null, new UserDimension(f, teXUnit));
        }
        catch (TeXSyntaxException teXSyntaxException) {
            // empty catch block
        }
    }

    public DimenRegister(String string, TeXGlue teXGlue) {
        super(string);
        this.dimension = teXGlue;
    }

    public void setValue(TeXParser teXParser, float f, TeXUnit teXUnit) throws TeXSyntaxException {
        TeXDimension teXDimension = this.dimension.getFixed();
        if (teXDimension instanceof UserDimension) {
            ((UserDimension)teXDimension).setValue(f, teXUnit);
        } else {
            this.dimension.setFixed(teXParser, new UserDimension(f, teXUnit));
        }
        this.dimension.setShrink(teXParser, null);
        this.dimension.setStretch(teXParser, null);
    }

    @Override
    public void setValue(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        if (!(numerical instanceof TeXDimension)) {
            this.dimension.setDimension(teXParser, new UserDimension(numerical.number(teXParser), (TeXUnit)FixedUnit.SP));
            throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", numerical.toString(teXParser));
        }
        this.setDimension(teXParser, (TeXDimension)numerical);
    }

    @Override
    public void setDimension(TeXParser teXParser, TeXDimension teXDimension) throws TeXSyntaxException {
        this.dimension.setDimension(teXParser, teXDimension);
    }

    public TeXDimension getDimension() {
        return this.dimension;
    }

    @Override
    public float getValue() {
        return this.dimension.getValue();
    }

    @Override
    public TeXUnit getUnit() {
        return this.dimension.getUnit();
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.dimension.number(teXParser);
    }

    @Override
    public TeXObject getContents(TeXParser teXParser) throws TeXSyntaxException {
        return teXParser.string(this.dimension.toString(teXParser));
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.dimension.advance(teXParser, numerical);
    }

    @Override
    public void multiply(int n) {
        this.dimension.multiply(n);
    }

    @Override
    public void multiply(float f) {
        this.dimension.multiply(f);
    }

    @Override
    public void divide(int n) {
        this.dimension.divide(n);
    }

    @Override
    protected TeXObject popValue(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return teXObjectList.popDimension(teXParser);
    }

    @Override
    public Object clone() {
        return new DimenRegister(this.getName(), (TeXGlue)this.dimension.clone());
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,value=%s]", this.getClass().getSimpleName(), this.getName(), this.dimension);
    }
}

