/*
 * Decompiled with CFR 0.152.
 */
class DviStack {
    private int[] h = new int[100];
    private int[] v = new int[100];
    private int[] w = new int[100];
    private int[] x = new int[100];
    private int[] y = new int[100];
    private int[] z = new int[100];
    private int sp;
    private int m_h;
    private int m_v;
    private int m_w;
    private int m_x;
    private int m_y;
    private int m_z;
    private double m_Scale = 1.0;

    public DviStack() {
        this.reset();
    }

    public void reset() {
        this.sp = -1;
        int n = 0;
        while (n < 100) {
            this.h[n] = 0;
            this.v[n] = 0;
            this.w[n] = 0;
            this.x[n] = 0;
            this.y[n] = 0;
            this.z[n] = 0;
            ++n;
        }
        this.m_z = 0;
        this.m_y = 0;
        this.m_x = 0;
        this.m_w = 0;
        this.m_v = 0;
        this.m_h = 0;
    }

    public void push() throws StackOverflowError {
        if (this.sp < 99) {
            ++this.sp;
        } else {
            throw new StackOverflowError("DviStack overflow");
        }
        this.h[this.sp] = this.m_h;
        this.v[this.sp] = this.m_v;
        this.w[this.sp] = this.m_w;
        this.x[this.sp] = this.m_x;
        this.y[this.sp] = this.m_y;
        this.z[this.sp] = this.m_z;
    }

    public void pop() throws StackOverflowError {
        if (this.sp >= 0) {
            this.m_h = this.h[this.sp];
            this.m_v = this.v[this.sp];
            this.m_w = this.w[this.sp];
            this.m_x = this.x[this.sp];
            this.m_y = this.y[this.sp];
            this.m_z = this.z[this.sp];
            --this.sp;
        } else {
            throw new StackOverflowError("DviStack underflow");
        }
    }

    public int geth() {
        return this.m_h;
    }

    public int getv() {
        return this.m_v;
    }

    public int getw() {
        return this.m_w;
    }

    public int getx() {
        return this.m_x;
    }

    public int gety() {
        return this.m_y;
    }

    public int getz() {
        return this.m_z;
    }

    public float gethh() {
        return (float)(this.m_Scale * (double)this.m_h + 720.0);
    }

    public float getvv() {
        return (float)(this.m_Scale * (double)this.m_v + 720.0);
    }

    public void setScale(double d) {
        this.m_Scale = 2.834645669E-4 * d;
    }

    public double applyScale(double d) {
        return this.m_Scale * d;
    }

    public void addHoriz(float f) {
        this.m_h += (int)Math.round((double)f / this.m_Scale);
    }

    public void addh(int n) {
        this.m_h += n;
    }

    public void addv(int n) {
        this.m_v += n;
    }

    public void setw(int n) {
        this.m_w = n;
    }

    public void setx(int n) {
        this.m_x = n;
    }

    public void sety(int n) {
        this.m_y = n;
    }

    public void setz(int n) {
        this.m_z = n;
    }
}

