/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui.handwritingRecognizer;

import java.io.File;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import net.sourceforge.javaocr.gui.GUIController;
import net.sourceforge.javaocr.gui.handwritingRecognizer.ConfigPanel;
import net.sourceforge.javaocr.gui.handwritingRecognizer.TrainingPanel;

public class HandWritingFormProcessor {
    public static final long serialVersionUID = 0L;
    private final GUIController guiController;
    private static final Logger LOG = Logger.getLogger(HandWritingFormProcessor.class.getName());

    public HandWritingFormProcessor(GUIController guiController) {
        this.guiController = guiController;
    }

    public boolean isValid() {
        if (!this.getSourceImageFile().exists()) {
            JOptionPane.showMessageDialog(null, "Source Image File Does Not Exist!");
            return false;
        }
        TrainingPanel trainPanel = this.guiController.getHandWriteTrainingPanel();
        if (!(trainPanel.isLearnLowerCaseAtoZ() || trainPanel.isLearnUpCaseAtoZ() || trainPanel.isLearnZeroToNine())) {
            JOptionPane.showMessageDialog(null, "Please Select a Training Option!");
            return false;
        }
        ConfigPanel cfgPanel = this.guiController.getHandWriteConfigPanel();
        if (!cfgPanel.isMSEEnabled() && !cfgPanel.isRatioAnzEnabled()) {
            JOptionPane.showMessageDialog(null, "Please Select a Recognition Option!");
            return false;
        }
        if (!this.getTargetImageFile().exists()) {
            JOptionPane.showMessageDialog(null, "Target Image File Does Not Exist!");
            return false;
        }
        return true;
    }

    public File getSourceImageFile() {
        return this.guiController.getHandWriteTrainingPanel().getTrainingImgFile();
    }

    public File getTargetImageFile() {
        return this.guiController.getHandWriteProcess().getTargetFile();
    }

    public boolean isLearnZeroToNine() {
        TrainingPanel trainPanel = this.guiController.getHandWriteTrainingPanel();
        return trainPanel.isLearnZeroToNine();
    }

    public boolean isLearnLowerAtoZ() {
        TrainingPanel trainPanel = this.guiController.getHandWriteTrainingPanel();
        return trainPanel.isLearnLowerCaseAtoZ();
    }

    public boolean isLearnUpperAtoZ() {
        TrainingPanel trainPanel = this.guiController.getHandWriteTrainingPanel();
        return trainPanel.isLearnUpCaseAtoZ();
    }

    public boolean isMSEOCR() {
        ConfigPanel cfgPanel = this.guiController.getHandWriteConfigPanel();
        return cfgPanel.isMSEEnabled();
    }

    public boolean isAspectOCR() {
        ConfigPanel cfgPanel = this.guiController.getHandWriteConfigPanel();
        return cfgPanel.isRatioAnzEnabled();
    }
}

