/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.syntax;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.UmlDiagramType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxResult {
    private UmlDiagramType umlDiagramType;
    private boolean isError;
    private String description;
    private int errorLinePosition;
    private Collection<String> errors = new TreeSet<String>();
    private List<String> suggest;
    private boolean hasCmapData;
    private PSystemError systemError;

    public UmlDiagramType getUmlDiagramType() {
        return this.umlDiagramType;
    }

    public boolean isError() {
        return this.isError;
    }

    public String getDescription() {
        return this.description;
    }

    public int getErrorLinePosition() {
        return this.errorLinePosition;
    }

    public List<String> getSuggest() {
        return this.suggest;
    }

    public Collection<String> getErrors() {
        return Collections.unmodifiableCollection(this.errors);
    }

    public void setUmlDiagramType(UmlDiagramType umlDiagramType) {
        this.umlDiagramType = umlDiagramType;
    }

    public void setError(boolean bl) {
        this.isError = bl;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setErrorLinePosition(int n) {
        this.errorLinePosition = n;
    }

    public void addErrorText(String string) {
        this.errors.add(string);
    }

    public void setSuggest(List<String> list) {
        this.suggest = list;
    }

    public final boolean hasCmapData() {
        return this.hasCmapData;
    }

    public final void setCmapData(boolean bl) {
        this.hasCmapData = bl;
    }

    public void setSystemError(PSystemError pSystemError) {
        this.systemError = pSystemError;
    }

    public void generateDiagramDescriptionForError(OutputStream outputStream, FileFormatOption fileFormatOption) throws IOException {
        if (this.systemError == null) {
            throw new IllegalStateException();
        }
        this.systemError.exportDiagram(outputStream, 0, fileFormatOption);
    }
}

