--[[-------------------------------------------------------------------
Palm Wireless IR keyboard

9600 baud, 8N1

Key down sends two bytes:  KEY, 0xC0
Key up sends two bytes:    KEY | 0x80, 0xC0

Photo:
http://www.slis.keio.ac.jp/~mine/palm/5.jpg

-----------

Copyright (c) 2005, David J. Kessler <dkessler@kopsisengineering.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-------------------------------------------------------------------]]--

-- Basic information about this driver
description = "Palm Wireless IR Keyboard Driver"
version = "0.2"

-- Modifier key information
scancode_fn = 0x22
scancode_punc = 0
scancode_num = 0x24
scancode_shiftl = 0x58
scancode_shiftr = 0x59
scancode_caps = 0x18
has_num_lock = 0
has_punc_lock = 0
has_fn_lock = 0

map_normal = {
	   0, 0, ZK_Z, 0, 0, 0, 0,
	0, ZK_Q, ZK_W, ZK_E, ZK_R, ZK_T, ZK_Y, 0,
	ZK_X, ZK_A, ZK_S, ZK_D, ZK_F, ZK_G, ZK_H, ZK_SPACE,
	0, 0, ZK_CONTROLL, ZK_TAB, 0, 0, 0, 0,
	0, 0, 0, ZK_ALTL, 0, 0, 0, 0,
	0, 0, 0, 0, ZK_C, ZK_V, ZK_B, ZK_N,
	0, 0, ZK_BACKSPACE, 0, 0, 0, 0, ZK_SPACE,
	ZK_MINUS, ZK_EQUAL, ZK_SLASH, 0, ZK_U, ZK_I, ZK_O, ZK_P,
	0, 0, 0, 0, ZK_J, ZK_K, ZK_L, ZK_SEMICOLON,
	ZK_UP, 0, 0, 0, ZK_M, ZK_COMMA, ZK_PERIOD, 0,
	ZK_DELETE, ZK_LEFT, ZK_DOWN, ZK_RIGHT, 0, 0, ZK_APOSTROPHE, ZK_RETURN,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0}

map_shift = {
	   0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	ZK_UNDERSCORE, ZK_PLUS, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, ZK_COLON,
	ZK_QUESTION, 0, 0, 0, 0, ZK_LESS, ZK_GREATER, 0,
	0, 0, 0, 0, 0, 0, ZK_QUOTEDBL, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0}

map_num = {
	   0, 0, 0, 0, 0, 0, 0,
	0, ZK_1, ZK_2, ZK_3, ZK_4, ZK_5, ZK_6, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	ZK_BRACKETLEFT, ZK_BRACKETRIGHT, ZK_BAR, 0, ZK_7, ZK_8, ZK_9, ZK_0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, ZK_TILDE, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0}

map_fn = {
	   0, 0, ZK_OK, 0, 0, 0, 0,
	0, ZK_EXCLAIM, ZK_AT, ZK_NUMBERSIGN, ZK_DOLLAR, ZK_PERCENT, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, ZK_SIDECANCEL, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	ZK_BRACELEFT, ZK_BRACERIGHT, ZK_BACKSLASH, 0, ZK_AMPERSAND, ZK_ASTERISK, ZK_PARENLEFT, ZK_PARENRIGHT,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, ZK_GRAVE, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0}

last_key = 0
last_key_down = 0

-- Function to convert a byte received from the kb to a scancode
function do_scancode ( s )
	key = 0
	key_down = 0

	key = s & 0x7f;
	if (s & 0x80 == 0x80) then
		key_down = 1
	else
		key_down = 0
	end

	-- look for final sequence byte 
	if (s != 0xC0) then
		last_key = key
		last_key_down = key_down
		key = 0
		key_down = 0
	else
		key = last_key;
		key_down = last_key_down;
	end

	return key, key_down
end

