/*
    This file is part of KDEPim/Pi.
    Copyright (c) 2004 Ulf Schenk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

/*
Enhanced Version of the file for platform independent KDE tools.
Copyright (c) 2004 Ulf Schenk

$Id: kdepimconfigwidget.h,v 1.2 2004/08/10 01:34:28 ulf69 Exp $
*/

#ifndef KDEPIMCONFIGWIDGET_H
#define KDEPIMCONFIGWIDGET_H

#include <qwidget.h>
#include <qmap.h>

#include "externalapphandler.h"


/*
class QCheckBox;
class QListViewItem;
class QPushButton;
class KListView;
*/
class QComboBox;
class QLineEdit;
class KPimGlobalPrefs;
class QGroupBox;

class KDEPIMConfigWidget : public QWidget
{
  Q_OBJECT

  public:
    KDEPIMConfigWidget( QWidget *parent, const char *name = 0 );

    void restoreSettings(KPimGlobalPrefs* prefs);
    void saveSettings(KPimGlobalPrefs* prefs);
    void defaults(KPimGlobalPrefs* prefs);

  signals:
    void changed( bool );


  public slots:
    void modified();
    void textChanged( const QString& text );



  private slots:
//    void configureExtension();
//    void selectionChanged( QListViewItem* );
//    void itemClicked( QListViewItem* );
    void client_changed( int newClient );
    void externalapp_changed( int newApp );

  private:
    void saveEditFieldSettings();
    void updateClientWidgets();

//    void restoreExtensionSettings();
//    void saveExtensionSettings();

//    KListView *mExtensionView;

//    QCheckBox *mNameParsing;
//    QCheckBox *mViewsSingleClickBox;
//    QPushButton *mConfigureButton;
	QComboBox* mExternalApps;
	QGroupBox* mExternalAppGroupBox;


    QComboBox* mClient;
    QLineEdit* mChannel;
    QLineEdit* mMessage;
    QLineEdit* mParameters;
    QLineEdit* mMessage2;
    QLineEdit* mParameters2;

    ExternalAppHandler::Types mCurrentApp;
    int mCurrentClient;


    int mEmailClient;
    QString mEmailOtherChannel;
    QString mEmailOtherMessage;
    QString mEmailOtherMessageParameters;
    QString mEmailOtherMessage2;
    QString mEmailOtherMessageParameters2;

    int mPhoneClient;
    QString mPhoneOtherChannel;
    QString mPhoneOtherMessage;
    QString mPhoneOtherMessageParameters;

    int mFaxClient;
    QString mFaxOtherChannel;
    QString mFaxOtherMessage;
    QString mFaxOtherMessageParameters;

    int mSMSClient;
    QString mSMSOtherChannel;
    QString mSMSOtherMessage;
    QString mSMSOtherMessageParameters;

    int mPagerClient;
    QString mPagerOtherChannel;
    QString mPagerOtherMessage;
    QString mPagerOtherMessageParameters;



    QMap<ExternalAppHandler::Types, QString> mExternalAppsMap;

//    AddresseeWidget *mAddresseeWidget;
};

#endif
