/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.filter.insn;

import eu.bibl.banalysis.filter.ConstantFilter;
import eu.bibl.banalysis.filter.OpcodeFilter;
import eu.bibl.banalysis.filter.insn.OpcodeInstructionFilter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class MethodInstructionFilter
extends OpcodeInstructionFilter {
    private ConstantFilter<String> ownerFilter;
    private ConstantFilter<String> nameFilter;
    private ConstantFilter<String> descFilter;

    public MethodInstructionFilter(OpcodeFilter filter, String owner, String name, String desc) {
        super(filter);
        this.ownerFilter = this.createFilter(owner);
        this.nameFilter = this.createFilter(name);
        this.descFilter = this.createFilter(desc);
    }

    public MethodInstructionFilter(int opcode, String owner, String name, String desc) {
        super(new OpcodeFilter(opcode));
        this.ownerFilter = this.createFilter(owner);
        this.nameFilter = this.createFilter(name);
        this.descFilter = this.createFilter(desc);
    }

    private ConstantFilter<String> createFilter(String s) {
        if (s == null) {
            return new ConstantFilter<String>();
        }
        return new ConstantFilter<String>(s);
    }

    @Override
    public boolean accept(AbstractInsnNode t) {
        if (!(t instanceof MethodInsnNode)) {
            return false;
        }
        if (!this.opcodeFilter.accept(t)) {
            return false;
        }
        MethodInsnNode min = (MethodInsnNode)t;
        if (!this.ownerFilter.accept(min.owner)) {
            return false;
        }
        if (!this.nameFilter.accept(min.name)) {
            return false;
        }
        return this.descFilter.accept(min.desc);
    }
}

