/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.asm.refactor.asm;

import eu.bibl.banalysis.storage.CallbackMappingData;
import eu.bibl.banalysis.storage.ClassMappingData;
import eu.bibl.banalysis.storage.FieldMappingData;
import eu.bibl.banalysis.storage.HookMap;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.commons.Remapper;

public class RefactorMapper
extends Remapper {
    protected final Map<String, ClassMappingData> sortedClasses = new HashMap<String, ClassMappingData>();
    protected final Map<String, CallbackMappingData> sortedMethods = new HashMap<String, CallbackMappingData>();
    protected final Map<String, FieldMappingData> sortedFields = new HashMap<String, FieldMappingData>();

    public RefactorMapper(HookMap hookMap) {
        String refactoredCname;
        String obfuscatedCname;
        String obfuscatedDesc;
        String obfuscatedName;
        for (ClassMappingData classMappingData : hookMap.getClasses()) {
            if (classMappingData.getObfuscatedName().contains("$")) continue;
            obfuscatedName = classMappingData.getObfuscatedName();
            String refactoredName = classMappingData.getRefactoredName();
            this.sortedClasses.put(obfuscatedName, classMappingData);
            this.sortedClasses.put(refactoredName, classMappingData);
        }
        for (CallbackMappingData callbackMappingData : hookMap.getMethods()) {
            obfuscatedName = callbackMappingData.getMethodName().getObfuscatedName();
            obfuscatedDesc = callbackMappingData.getMethodName().getRefactoredName();
            obfuscatedCname = callbackMappingData.getMethodOwner().getObfuscatedName();
            refactoredCname = callbackMappingData.getMethodOwner().getRefactoredName();
            this.sortedMethods.put(obfuscatedCname + "$$$$" + obfuscatedName + "$$$$" + obfuscatedDesc, callbackMappingData);
            this.sortedMethods.put(refactoredCname + "$$$$" + obfuscatedName + "$$$$" + obfuscatedDesc, callbackMappingData);
        }
        for (FieldMappingData fieldMappingData : hookMap.getFields()) {
            obfuscatedName = fieldMappingData.getName().getObfuscatedName();
            obfuscatedDesc = fieldMappingData.getDesc().getObfuscatedName();
            obfuscatedCname = fieldMappingData.getFieldOwner().getObfuscatedName();
            refactoredCname = fieldMappingData.getFieldOwner().getRefactoredName();
            this.sortedFields.put(obfuscatedCname + "$$$$" + obfuscatedName + "$$$$" + obfuscatedDesc, fieldMappingData);
            this.sortedFields.put(refactoredCname + "$$$$" + obfuscatedName + "$$$$" + obfuscatedDesc, fieldMappingData);
        }
    }

    public String map(String type) {
        if (this.sortedClasses.containsKey(type)) {
            return this.sortedClasses.get(type).getRefactoredName();
        }
        return type;
    }

    public String mapFieldName(String owner, String name, String desc) {
        String obfKey = owner + "$$$$" + name + "$$$$" + desc;
        if (this.sortedFields.containsKey(obfKey)) {
            name = this.sortedFields.get(obfKey).getName().getRefactoredName();
        }
        return name;
    }

    public String mapMethodName(String owner, String name, String desc) {
        String obfKey = owner + "$$$$" + name + "$$$$" + desc;
        if (this.sortedMethods.containsKey(obfKey)) {
            name = this.sortedMethods.get(obfKey).getMethodName().getRefactoredName();
        }
        return name;
    }
}

