<?
//   XUL Webmail, a web based mailclient
//
//   Copyright (C) 2004 Wouter van Wijk (wvw@dds.nl),
//   Copyright (C) 2004-05 Achim J. Latz (xwm a@t latz.org)
//   based on XUL Channels, Copyright (C) 2003 Tim Broddin
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// session check

include('settings.php');

session_start();
if (!isset($_SESSION['user']))
{
	header("Location: error.php?ec=2");
	exit;
}

$to = trim($HTTP_POST_VARS["to"]);
$cc = trim($HTTP_POST_VARS["cc"]);
$bcc = trim($HTTP_POST_VARS["bcc"]);
$files = stripslashes(trim($HTTP_POST_VARS["attachment"]));
$body = $HTTP_POST_VARS["message"];
$body_newline = str_replace("&","\n\n", $body);
$subject = trim($HTTP_POST_VARS["subject"]);
$email = $_SESSION['email'];
$fromname = $_SESSION['realname'];

require("phpmailer/class.phpmailer.php");

$message = new PHPMailer();

$message->IsHTML(false);              # set email format to plain text
$message->WordWrap = 80;              # set word wrap to 50 characters
$message->Priority = 0;               # Urgent = 1, Not Urgent = 5, Disable = 0
$message->From = stripslashes($email);
$message->FromName = stripslashes($fromname);

if ($smtpserver != '') {
	$message->IsSMTP();
	$message->Host = $smtpserver;
	$message->Username  = $smtpusername;
	$message->Password  = $smtppassword;
}

$message->IsMail();

$mailer .= "X-Mailer: $standardtitle $appversion using PHP/" . phpversion();

$message->AddCustomHeader($mailer);

// split TO, CC and BCC fields for multiple recipients, usually separated by ',' (comma)

$addresses = explode(",", $to);
for($i = 0; $i < count($addresses); $i++) {
     $message->AddAddress($addresses[$i]);
}

$addresses = explode(",", $cc);
for($i = 0; $i < count($addresses); $i++) {
     $message->AddCC($addresses[$i]);
}

$addresses = explode(",", $bcc);
for($i = 0; $i < count($addresses); $i++) {
     $message->AddBCC($addresses[$i]);
}

// to remove all the slashes like \' \" that usually would appear
$message->Subject = stripslashes($subject);
$message->Body = stripslashes($body_newline);

// from settings.php
$message->WordWrap = $wordwrap;

// attachment filenames are split by ' (tick), as decided
// in xulwebmail.js in finishedUpload()  
$attachments = explode("'", $files);
for($i = 0; $i < count($attachments); $i++) {
	$message->AddAttachment($upload_dir.rawurlencode($attachments[$i]), $attachments[$i]);
}

// required for appending the message to the SENT folder
// RFC 2822 formatted date, see http://uk.php.net/manual/en/function.date.php
$dateformat = "r";

$header = "From: $fromname <$email>\r\nTo: $to\r\nCC: $cc\r\nBCC:\r\nSubject: $subject\r\nDate: ".date($dateformat)."\r\n$mailer";
$flatmsg = getMailMessage($header, $body_newline);

// details will contain the message and a list of attachments
$details = $flatmsg;

// add the list of attachments
$details .= $files."\r\n";
for($i = 0; $i < count($attachments)-1; $i++) {
	$details .= "Attachment $i: ".$attachments[$i]."\r\n";
}

// make the confirmation window a bit more readable by substituting line-breaks by HTML <br />
$details = str_replace ("\r\n", "<br />",$details);


$isSent = $message->Send();

// append to sent folder only if sending was successful
if (true == $isSent) {
	$isAppended = appendMessage($sentmailfolder, $flatmsg);
} else {
	$isAppended = false;
}

echo "<html><body>";

if(!$isSent) {
	echo "<h1><font color=red>ERROR: Message not sent!</font></h1>";
	echo "Error: " . $message->ErrorInfo;
} else {
	echo "<h1>Message sent.</h1>";
}

if(!$isAppended) {
	echo "<h1><font color=red>ERROR: Message not saved to $sentmailfolder!</font></h1>";
} else {
	echo "<h1>Message saved to $sentmailfolder.</h1>";
}

echo $details;

//mail($to, $subject, $body_newline, "From: $email\r\n");
	echo "<br /><a href=\"#\" onclick=\"javascript:window.close();\">Close</a></body></html>";

	//Finally, delete the attachment file
	for($i = 0; $i < count($attachments)-1; $i++) {
		unlink($upload_dir.rawurlencode($attachments[$i]));
	}

	?>
