var myTimeout;

function getWeather(zipcode) { // Gets weather data from a remote xml file
  var weatherRequest = new XMLHttpRequest();
  weatherRequest.open("GET", "http://www.ejse.com/WeatherService/Service.asmx/GetWeatherInfo?zipCode=" + zipcode, true);
 
  // Code to execute when you hear back from the web service.
  weatherRequest.onload = function parse() {
    // Clear the timeout we set when we sent the request below 
    clearTimeout(myTimeout);

    var return_data = new Array();
    var return_data_needed = new Array("Location", "IconIndex", "Temprature", "FeelsLike", "Forecast", "Visibility", "Pressure", "DewPoint", "UVIndex", "Humidity", "Wind", "ReportedAt", "LastUpdated");

    // Try to parse the data we need
    try {
      for (var value in return_data_needed) {
         return_data[return_data_needed[value]] = weatherRequest.responseXML.getElementsByTagName(return_data_needed[value])[0].firstChild.nodeValue;
      }
    }
    // If the file is corrupted, display the error message.
    catch (e) {
      displayWeather("Error");
      return true;
    }

    // Everything must be okay, so pass the array of current weather to the display function
    displayWeather(return_data);
  }

  // Reset the display to the "Loading..." message
  document.getElementById('weatherDeck').selectedIndex = '1';

  // Try to get the xml from the web.
  try {
    weatherRequest.send(null);
    // If we don't hear back from the remote web service in 5 seconds, display the error message.
    myTimeout = setTimeout("displayWeather('Error');", 5000);
  }
  // If we can't send the request, display the error message.
  catch (e) {
    displayWeather("Error");
  }
};

function displayWeather(current_weather) {
  // gets reference to localized strings
  var stringbundle = document.getElementById("strings");

  // if the weather server is down, display the error message (the string "Error" doesn't really mean anything)
  if (current_weather == "Error") {
    document.getElementById('weatherDeck').selectedIndex = '2';
    return true;
  }

  // Load the current icon into the display
  document.getElementById("displayWeather-Icon").setAttribute("src", "chrome://weather/skin/icons/" + current_weather["IconIndex"] + ".png");

  // Load the current temperature into the display
  document.getElementById("displayWeather-Temperature").setAttribute("value", current_weather["Temprature"]);

  // Load the location into the display
  document.getElementById("displayWeather-Location").setAttribute("value", stringbundle.getFormattedString("location", [current_weather["Location"]]));

  // Populate the tooltip grid
  for (var value in current_weather) {
    if (document.getElementById("weatherMoreData-" + value) != null){
      document.getElementById("weatherMoreData-" + value).setAttribute("value", current_weather[value]);
    }
  }

  // Change the display from the loading message to the main info message
  document.getElementById('weatherDeck').selectedIndex = "0";
}

// Function called on start up and every time weather refreshes
function initiateWeather() {
  // Get current user preferences
  var weather_prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("weather.");

  // If any of the preferences aren't set, display the options dialog.
  if (weather_prefs.getPrefType("zipcode") == 0 || weather_prefs.getPrefType("refresh") == 0 || weather_prefs.getPrefType("interval") == 0) {
    window.openDialog('chrome://weather/content/weatherOptions.xul', 'weatherOptions', 'chrome');
  }
  // Otherwise, load the preferences and get the current conditions from the web
  else {
    var zipcode = weather_prefs.getCharPref("zipcode");
    var refresh = weather_prefs.getBoolPref("refresh")
    var interval = weather_prefs.getCharPref("interval")

    getWeather(zipcode);

    // If the user wants to auto-refresh, call this function again in x minutes
    if(refresh){
      setTimeout("initiateWeather()", interval * 60 * 1000);
    }
  }
}

// Put the whole shabang in motion once thunderbird loads.
addEventListener("load", initiateWeather, false);